/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.railsprojects.server.RailsApplication;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.nodes.RubyServerNode;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

class Passenger
implements RubyServer,
ServerInstanceImplementation {
    static final String GEM_NAME = "passenger";
    static final String SERVER_URI = "PASSENGER";
    private final RubyPlatform platform;
    private final String version;
    private final List<RailsApplication> applications = new ArrayList<RailsApplication>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Node node;

    Passenger(RubyPlatform platform, String version) {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        this.platform = platform;
        this.version = version;
    }

    private Node getNode() {
        if (this.node == null) {
            this.node = new RubyServerNode(this);
        }
        return this.node;
    }

    @Override
    public String getNodeName() {
        return NbBundle.getMessage(Passenger.class, (String)"LBL_ServerNodeName", (Object)this.getDisplayName(), (Object)this.platform.getLabel());
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public List<String> getStartupParams(RailsProjectUtil.RailsVersion version) {
        if (version.isRails3OrHigher()) {
            return Arrays.asList("server", GEM_NAME);
        }
        return Arrays.asList(GEM_NAME);
    }

    @Override
    public String getScriptPrefix() {
        return null;
    }

    @Override
    public String getServerPath(RailsProjectUtil.RailsVersion version) {
        return null;
    }

    @Override
    public boolean isStartupMsg(String arg0) {
        return true;
    }

    @Override
    public List<RailsApplication> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    @Override
    public boolean addApplication(RailsApplication application) {
        boolean result = this.applications.add(application);
        this.changeSupport.fireChange();
        return result;
    }

    @Override
    public boolean removeApplication(int port) {
        boolean result = false;
        for (RailsApplication app : this.applications) {
            if (app.getPort() != port) continue;
            result = this.applications.remove(app);
            this.changeSupport.fireChange();
            break;
        }
        return result;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public String getServerUri() {
        return SERVER_URI;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(Passenger.class, (String)"LBL_Passenger", (Object)this.version);
    }

    @Override
    public RubyInstance.ServerState getServerState() {
        return RubyInstance.ServerState.RUNNING;
    }

    @Override
    public Future<RubyInstance.OperationState> startServer(RubyPlatform arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stopServer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> deploy(String arg0, File arg1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stop(String arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> runApplication(RubyPlatform arg0, String arg1, File arg2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPlatformSupported(RubyPlatform platform) {
        return this.platform.equals((Object)platform);
    }

    @Override
    public String getContextRoot(String applicationName) {
        return applicationName;
    }

    @Override
    public int getRailsPort() {
        return 80;
    }

    @Override
    public String getServerCommand(RubyPlatform arg0, String arg1, File arg2, int arg3, boolean arg4) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getServerDisplayName() {
        return this.getNodeName();
    }

    public Node getFullNode() {
        return this.getNode();
    }

    public Node getBasicNode() {
        return this.getNode();
    }

    public JComponent getCustomizer() {
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRemovable() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Passenger other = (Passenger)obj;
        if (!(this.platform == other.platform || this.platform != null && this.platform.equals((Object)other.platform))) {
            return false;
        }
        return this.version == other.version || this.version != null && this.version.equals(other.version);
    }

    public int hashCode() {
        int hash = 3;
        hash = 55 * hash + (this.platform != null ? this.platform.hashCode() : 0);
        hash = 55 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }
}

