/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ParagraphViewChildren;
import org.netbeans.modules.editor.lib2.view.WrapInfo;
import org.netbeans.modules.editor.lib2.view.WrapLine;

final class WrapInfoUpdater {
    private static final Logger LOG = Logger.getLogger(WrapInfoUpdater.class.getName());
    private static final long serialVersionUID = 0L;
    private final WrapInfo wrapInfo;
    private final ParagraphViewChildren children;
    private final ParagraphView paragraphView;
    private final DocumentView documentView;
    private List<WrapLine> wrapLines;
    private WrapLine wrapLine;
    private int childIndex;
    private float x;
    private EditorView breakView;
    private float breakVisualOffset;
    private int breakOffset;
    private float availableWidth;
    private float maxLineWidth;
    private boolean wrapLineNonEmpty;
    private StringBuilder logMsgBuilder;

    WrapInfoUpdater(WrapInfo wrapInfo, ParagraphViewChildren children, ParagraphView paragraphView) {
        this.wrapInfo = wrapInfo;
        this.children = children;
        this.paragraphView = paragraphView;
        this.documentView = paragraphView.getDocumentView();
        assert (this.documentView != null) : "Null documentView";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float initWrapInfo() {
        this.wrapLines = new ArrayList<WrapLine>(2);
        int childCount = this.children.size();
        if (childCount > 0) {
            float visibleWidth = this.documentView.getVisibleWidth();
            TextLayout lineContinuationTextLayout = this.documentView.getLineContinuationCharTextLayout();
            this.availableWidth = Math.max(visibleWidth - lineContinuationTextLayout.getAdvance(), this.documentView.getDefaultCharWidth() * 4.0f);
            double nextVisualOffset = 0.0;
            StringBuilder stringBuilder = this.logMsgBuilder = LOG.isLoggable(Level.FINE) ? new StringBuilder(100) : null;
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append("lineContCharW:").append(lineContinuationTextLayout.getAdvance());
                this.logMsgBuilder.append(", availW:").append(this.availableWidth);
                this.logMsgBuilder.append("\n");
            }
            try {
                while (this.childIndex < childCount) {
                    EditorView childView = (EditorView)this.children.get(this.childIndex);
                    double visualOffset = nextVisualOffset;
                    nextVisualOffset = this.paragraphView.getViewVisualOffset(this.childIndex + 1);
                    double childWidth = nextVisualOffset - visualOffset;
                    if (this.logMsgBuilder != null) {
                        this.logMsgBuilder.append("child[").append(this.childIndex).append("]:").append(childView);
                        this.logMsgBuilder.append(",W=").append(childWidth);
                        this.logMsgBuilder.append(": ");
                    }
                    if ((double)this.x + childWidth <= (double)this.availableWidth) {
                        this.addChild(childWidth);
                    } else if (this.breakViewLineEnd(childView, visualOffset)) {
                        while (this.breakViewNext()) {
                        }
                    } else {
                        boolean forceAdd = true;
                        if (this.wrapLineNonEmpty) {
                            this.finishWrapLine();
                            if (this.logMsgBuilder != null) {
                                this.logMsgBuilder.append("ROEL;");
                            }
                            if ((double)this.x + childWidth <= (double)this.availableWidth) {
                                this.addChild(childWidth);
                                forceAdd = false;
                            } else if (this.breakViewLineEnd(childView, visualOffset)) {
                                forceAdd = false;
                                while (this.breakViewNext()) {
                                }
                            }
                        }
                        if (forceAdd) {
                            if (this.logMsgBuilder != null) {
                                this.logMsgBuilder.append("addFORCED;");
                            }
                            this.addChild(childWidth);
                        }
                    }
                    if (this.logMsgBuilder != null) {
                        this.logMsgBuilder.append('\n');
                    }
                    ++this.childIndex;
                }
                this.finishWrapLine();
            }
            finally {
                if (this.logMsgBuilder != null) {
                    this.logMsgBuilder.append('\n');
                    LOG.fine(this.logMsgBuilder.toString());
                }
            }
        }
        this.wrapInfo.addAll(this.wrapLines);
        this.wrapInfo.checkIntegrity(this.paragraphView);
        if (this.logMsgBuilder != null) {
            LOG.fine("Inited wrapInfo:\n" + this.wrapInfo.toString(this.paragraphView) + "\n");
        }
        return this.maxLineWidth;
    }

    float preferredWidth() {
        return this.maxLineWidth;
    }

    private WrapLine wrapLine() {
        if (this.wrapLine == null) {
            this.wrapLine = new WrapLine();
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append("WL[").append(this.wrapLines.size());
                this.logMsgBuilder.append("]{");
            }
        }
        return this.wrapLine;
    }

    private void finishWrapLine() {
        if (this.wrapLine != null) {
            if (this.wrapLineNonEmpty) {
                if (this.x > this.maxLineWidth) {
                    this.maxLineWidth = this.x;
                }
                if (this.logMsgBuilder != null) {
                    this.logMsgBuilder.append("};");
                }
                this.wrapLines.add(this.wrapLine);
            }
            this.wrapLine = null;
            this.wrapLineNonEmpty = false;
            this.x = 0.0f;
        }
    }

    private void addChild(double childWidth) {
        WrapLine wl = this.wrapLine();
        if (!wl.isInited()) {
            wl.startViewIndex = this.childIndex;
        }
        wl.endViewIndex = this.childIndex + 1;
        this.wrapLineNonEmpty = true;
        this.x = (float)((double)this.x + childWidth);
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("added,x=").append(this.x).append(';');
        }
    }

    private boolean breakViewLineEnd(EditorView childView, double childVisualOffset) {
        assert (this.breakView == null);
        this.breakView = childView;
        this.breakOffset = childView.getStartOffset();
        this.breakVisualOffset = (float)childVisualOffset;
        this.wrapLine().endViewPart = this.breakViewImpl();
        if (this.wrapLine().endViewPart != null) {
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append("brEND,x=").append(this.x).append(';');
            }
            this.finishWrapLine();
            return true;
        }
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("brEND-FAIL;");
        }
        this.breakView = null;
        return false;
    }

    private boolean breakViewNext() {
        boolean fits;
        float width = this.breakView.getPreferredSpan(0);
        boolean bl = fits = width <= this.availableWidth - this.x;
        if (!fits && (this.wrapLine().startViewPart = this.breakViewImpl()) != null) {
            if (this.logMsgBuilder != null) {
                this.logMsgBuilder.append("brSTART,x=").append(this.x).append(';');
            }
            this.wrapLine.startViewX = this.x;
            this.wrapLineNonEmpty = true;
            if (this.wrapLine.startViewPart.getEndOffset() == this.breakView.getEndOffset()) {
                this.breakView = null;
                return false;
            }
            this.finishWrapLine();
            return true;
        }
        this.wrapLine().startViewPart = this.breakView;
        this.breakView = null;
        this.wrapLineNonEmpty = true;
        this.x += width;
        this.wrapLine.startViewX = this.x;
        if (this.logMsgBuilder != null) {
            this.logMsgBuilder.append("brSTART-");
            this.logMsgBuilder.append(fits ? "FITS" : "FAIL");
            this.logMsgBuilder.append(",x=").append(this.x).append(';');
        }
        if (this.x >= this.availableWidth) {
            this.finishWrapLine();
        }
        return false;
    }

    private EditorView breakViewImpl() {
        int partEndOffset;
        EditorView fragment;
        EditorView part;
        int breakViewStartOffset;
        if (this.logMsgBuilder != null && (breakViewStartOffset = this.breakView.getStartOffset()) != this.breakOffset) {
            this.logMsgBuilder.append("\nERROR!: breakViewStartOffset=").append(breakViewStartOffset).append(" != breakOffset=").append(this.breakOffset);
        }
        if ((part = (EditorView)this.breakView.breakView(0, this.breakOffset, this.breakVisualOffset, this.availableWidth - this.x)) != null && part != this.breakView && (fragment = (EditorView)this.breakView.createFragment(partEndOffset = part.getEndOffset(), this.breakView.getEndOffset())) != null && fragment != this.breakView) {
            if (this.logMsgBuilder != null) {
                int breakViewStartOffset2 = this.breakView.getStartOffset();
                if (part.getStartOffset() != breakViewStartOffset2) {
                    this.logMsgBuilder.append("\nbreakView() ERROR!: partStartOffset=").append(part.getStartOffset()).append(" != breakViewStartOffset=").append(breakViewStartOffset2);
                }
                if (partEndOffset != fragment.getStartOffset()) {
                    this.logMsgBuilder.append("\nERROR!: partEndOffset=").append(partEndOffset).append(" !=  fragmentStartOffset=").append(fragment.getStartOffset());
                }
                if (fragment.getEndOffset() != this.breakView.getEndOffset()) {
                    this.logMsgBuilder.append("\ncreateFragment() ERROR!: fragmentEndOffset=").append(fragment.getEndOffset()).append(" != breakViewEndOffset=").append(this.breakView.getEndOffset());
                }
            }
            this.wrapLineNonEmpty = true;
            float width = part.getPreferredSpan(0);
            this.breakView = fragment;
            this.breakVisualOffset += width;
            this.breakOffset = partEndOffset;
            this.x += width;
        } else {
            part = null;
        }
        return part;
    }
}

