/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.repository.GroupListChildren;
import org.netbeans.modules.maven.repository.register.RepositoryRegisterUI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RepositoryNode
extends AbstractNode {
    private RepositoryInfo info;

    public RepositoryNode(RepositoryInfo info) {
        super((Children)new GroupListChildren(info));
        this.info = info;
        this.setName(info.getId());
        this.setDisplayName(info.getName());
    }

    public Image getIcon(int arg0) {
        if (this.info.isRemoteDownloadable()) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/remoterepo.png", (boolean)true);
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/localrepo.png", (boolean)true);
    }

    public Image getOpenedIcon(int arg0) {
        return this.getIcon(arg0);
    }

    public String getShortDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_ID", (Object)this.info.getId()));
        buffer.append(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_Name", (Object)this.info.getName()));
        if (this.info.getRepositoryUrl() != null) {
            buffer.append(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_Url", (Object)this.info.getRepositoryUrl()));
        }
        if (this.info.getIndexUpdateUrl() != null) {
            buffer.append(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_Index_Url", (Object)this.info.getIndexUpdateUrl()));
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    public void destroy() throws IOException {
        RepositoryPreferences.getInstance().removeRepositoryInfo(this.info);
        super.destroy();
    }

    public boolean canDestroy() {
        return !this.info.isLocal();
    }

    public Action[] getActions(boolean arg0) {
        return new Action[]{new RefreshIndexAction(), new EditAction(), DeleteAction.get(DeleteAction.class), null, PropertiesAction.get(PropertiesAction.class)};
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set basicProps = sheet.get("properties");
        try {
            PropertySupport.Reflection id = new PropertySupport.Reflection((Object)this.info, String.class, "getId", null);
            id.setName("Id");
            id.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Id"));
            id.setShortDescription("");
            PropertySupport.Reflection name = new PropertySupport.Reflection((Object)this.info, String.class, "getName", null);
            name.setName("name");
            name.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Name"));
            name.setShortDescription("");
            PropertySupport.Reflection type = new PropertySupport.Reflection((Object)this.info, String.class, "getType", null);
            type.setName("type");
            type.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Repository_Type"));
            PropertySupport.Reflection local = new PropertySupport.Reflection((Object)this.info, Boolean.TYPE, "isLocal", null);
            local.setName("local");
            local.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Local"));
            local.setShortDescription("");
            PropertySupport.Reflection localRepoLocation = new PropertySupport.Reflection((Object)this.info, String.class, "getRepositoryPath", null);
            localRepoLocation.setName("repositoryPath");
            localRepoLocation.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Local_repository_path"));
            PropertySupport.Reflection remoteDownloadable = new PropertySupport.Reflection((Object)this.info, Boolean.TYPE, "isRemoteDownloadable", null);
            remoteDownloadable.setName("remoteDownloadable");
            remoteDownloadable.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Remote_Index"));
            PropertySupport.Reflection repoURL = new PropertySupport.Reflection((Object)this.info, String.class, "getRepositoryUrl", null);
            repoURL.setName("repositoryUrl");
            repoURL.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Remote_URL"));
            PropertySupport.Reflection indexURL = new PropertySupport.Reflection((Object)this.info, String.class, "getIndexUpdateUrl", null);
            indexURL.setName("indexUpdateUrl");
            indexURL.setDisplayName(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Remote_Index_URL"));
            basicProps.put(new Node.Property[]{id, name, type, local, localRepoLocation, remoteDownloadable, repoURL, indexURL});
        }
        catch (NoSuchMethodException exc) {
            exc.printStackTrace();
        }
        return sheet;
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("Name", NbBundle.getMessage(RepositoryNode.class, (String)"ACT_Edit..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RepositoryRegisterUI rrui = new RepositoryRegisterUI();
            rrui.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Add_Repo"));
            rrui.modify(RepositoryNode.this.info);
            DialogDescriptor dd = new DialogDescriptor((Object)rrui, NbBundle.getMessage(RepositoryNode.class, (String)"LBL_Add_Repo"));
            dd.setClosingOptions(new Object[]{rrui.getButton(), DialogDescriptor.CANCEL_OPTION});
            dd.setOptions(new Object[]{rrui.getButton(), DialogDescriptor.CANCEL_OPTION});
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (rrui.getButton() == ret) {
                RepositoryInfo info = rrui.getRepositoryInfo();
                RepositoryPreferences.getInstance().addOrModifyRepositoryInfo(info);
                RepositoryNode.this.info = info;
                RepositoryNode.this.setDisplayName(info.getName());
                RepositoryNode.this.fireIconChange();
                RepositoryNode.this.fireOpenedIconChange();
                ((GroupListChildren)RepositoryNode.this.getChildren()).refreshGroups();
            }
        }
    }

    public class RefreshIndexAction
    extends AbstractAction {
        public RefreshIndexAction() {
            this.putValue("Name", NbBundle.getMessage(RepositoryNode.class, (String)"LBL_REPO_Update_Index"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    RepositoryIndexer.indexRepo((RepositoryInfo)RepositoryNode.this.info);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RefreshIndexAction.this.setEnabled(true);
                        }
                    });
                }
            });
        }
    }
}

