/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.BrandingUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class OpenBrandingEditorAction
extends AbstractAction
implements ContextAwareAction {
    private final Lookup context;
    private static final String BRANDING_GROUP_ID = "org.codehaus.mojo";
    private static final String BRANDING_ARTIFACT_ID = "nbm-maven-plugin";
    private static final String BRANDING_GOAL = "branding";

    public OpenBrandingEditorAction() {
        this(Lookup.EMPTY);
    }

    private OpenBrandingEditorAction(Lookup lookup) {
        super(NbBundle.getMessage(OpenBrandingEditorAction.class, (String)"LBL_OpenBrandingEditor"));
        this.putValue("hideWhenDisabled", true);
        this.context = lookup;
        this.enable(lookup);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Project project = (Project)this.context.lookup(Project.class);
        if (null == project) {
            return;
        }
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (null == nbMavenProject) {
            return;
        }
        String string = PluginPropertyUtils.getPluginProperty((MavenProject)nbMavenProject.getMavenProject(), (String)BRANDING_GROUP_ID, (String)BRANDING_ARTIFACT_ID, (String)"brandingSources", (String)BRANDING_GOAL);
        if (null == string) {
            string = "src/main/nbm-branding";
        }
        BrandingUtils.openBrandingEditor((String)nbMavenProject.getMavenProject().getName(), (Project)project, (String)string);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new OpenBrandingEditorAction(lookup);
    }

    private void enable(Lookup lookup) {
        NbMavenProject nbMavenProject;
        boolean bl = false;
        Project project = (Project)lookup.lookup(Project.class);
        if (null != project && null != (nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class))) {
            bl = OpenBrandingEditorAction.isBrandingProject(nbMavenProject.getMavenProject());
        }
        this.setEnabled(bl);
    }

    private static boolean isBrandingProject(MavenProject mavenProject) {
        if (mavenProject.getBuildPlugins() == null) {
            return false;
        }
        for (Object e : mavenProject.getBuildPlugins()) {
            Plugin plugin = (Plugin)e;
            if (!BRANDING_ARTIFACT_ID.equals(plugin.getArtifactId()) || !BRANDING_GROUP_ID.equals(plugin.getGroupId()) || plugin.getExecutions() == null) continue;
            for (Object e2 : plugin.getExecutions()) {
                PluginExecution pluginExecution = (PluginExecution)e2;
                if (!pluginExecution.getGoals().contains(BRANDING_GOAL) && !"default-branding".equals(pluginExecution.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

