/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MakeProjectGenerator {
    private MakeProjectGenerator() {
    }

    public static String getDefaultProjectFolder() {
        return ProjectChooser.getProjectsFolder().getPath();
    }

    public static String getValidProjectName(String projectFolder) {
        return MakeProjectGenerator.getValidProjectName(projectFolder, "Project");
    }

    public static String getValidProjectName(String projectFolder, String name) {
        File projectNameFile;
        int baseCount = 0;
        String projectName = null;
        while ((projectNameFile = new File(projectFolder, projectName = baseCount == 0 ? name : name + baseCount)).exists()) {
            ++baseCount;
        }
        return projectName;
    }

    public static MakeProject createBlankProject(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        MakeConfiguration[] confs = prjParams.getConfigurations();
        File projectFolder = prjParams.getProjectFolder();
        MakeConfiguration[] copyConfs = new MakeConfiguration[confs.length];
        for (int i = 0; i < confs.length; ++i) {
            copyConfs[i] = (MakeConfiguration)confs[i].clone();
            copyConfs[i].setBaseDir(projectFolder.getPath());
            RunProfile profile = (RunProfile)copyConfs[i].getAuxObject("runprofile");
            profile.setBuildFirst(false);
        }
        FileObject dirFO = MakeProjectGenerator.createProjectDir(projectFolder);
        prjParams.setConfigurations(copyConfs);
        MakeProjectGenerator.createProject(dirFO, prjParams, true);
        MakeProject p = (MakeProject)ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject((Project)p);
        if (prjParams.getOpenFlag()) {
            OpenProjects.getDefault().open(new Project[]{p}, false);
            OpenProjects.getDefault().setMainProject((Project)p);
        }
        return p;
    }

    public static MakeProject createProject(ProjectGenerator.ProjectParameters prjParams) throws IOException {
        FileObject dirFO = MakeProjectGenerator.createProjectDir(prjParams.getProjectFolder());
        AntProjectHelper h = MakeProjectGenerator.createProject(dirFO, prjParams, false);
        MakeProject p = (MakeProject)ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject((Project)p);
        return p;
    }

    private static AntProjectHelper createProject(FileObject dirFO, ProjectGenerator.ProjectParameters prjParams, boolean saveNow) throws IOException {
        String name = prjParams.getProjectName();
        String makefileName = prjParams.getMakefileName();
        Configuration[] confs = prjParams.getConfigurations();
        final Iterator<SourceFolderInfo> sourceFolders = prjParams.getSourceFolders();
        String sourceFoldersFilter = prjParams.getSourceFoldersFilter();
        final Iterator<SourceFolderInfo> testFolders = prjParams.getTestFolders();
        final Iterator<String> importantItems = prjParams.getImportantFiles();
        String mainFile = prjParams.getMainFile();
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.cnd.makeproject");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element nativeProjectType = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "make-project-type");
        nativeProjectType.appendChild(doc.createTextNode("0"));
        data.appendChild(nativeProjectType);
        h.putPrimaryConfigurationData(data, true);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        h.putProperties("nbproject/private/private.properties", ep);
        final MakeConfigurationDescriptor projectDescriptor = new MakeConfigurationDescriptor(FileUtil.toFile((FileObject)dirFO).getPath());
        projectDescriptor.setProjectMakefileName(makefileName);
        projectDescriptor.init(confs);
        projectDescriptor.setState(ConfigurationDescriptor.State.READY);
        Project project = projectDescriptor.getProject();
        final String mainFilePath = mainFile.length() > 0 ? MakeProjectGenerator.createMain(mainFile, dirFO) : null;
        if (sourceFoldersFilter != null && !"^(nbproject|build|test|tests)$".equals(sourceFoldersFilter)) {
            projectDescriptor.setFolderVisibilityQuery(sourceFoldersFilter);
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                projectDescriptor.initLogicalFolders(sourceFolders, sourceFolders == null, testFolders, importantItems, mainFilePath);
                projectDescriptor.save();
                projectDescriptor.closed();
                projectDescriptor.clean();
            }
        };
        if (project instanceof MakeProject && !saveNow) {
            MakeProject makeProject = (MakeProject)project;
            makeProject.addOpenedTask(task);
        } else {
            task.run();
        }
        MakeProjectGenerator.copyURLFile("nbresloc:/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile", projectDescriptor.getBaseDir() + File.separator + projectDescriptor.getProjectMakefileName());
        return h;
    }

    private static void copyURLFile(String fromURL, String toFile) throws IOException {
        InputStream is = null;
        try {
            URL url = new URL(fromURL);
            is = url.openStream();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is != null) {
            FileOutputStream os = new FileOutputStream(toFile);
            MakeProjectGenerator.copy(is, os);
        }
    }

    private static void copy(InputStream is, OutputStream os) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        while ((line = br.readLine()) != null) {
            bw.write(line + "\n");
        }
        bw.flush();
    }

    private static FileObject createProjectDir(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Can not create project folder.");
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        assert (dirFO != null) : "No such dir on disk: " + dir;
        assert (dirFO.isFolder()) : "Not really a dir: " + dir;
        return dirFO;
    }

    private static String createMain(String mainFile, FileObject srcFolder) throws IOException {
        String mainName = mainFile.substring(0, mainFile.indexOf(124));
        String template = mainFile.substring(mainFile.indexOf(124) + 1);
        if (mainName.length() == 0) {
            return null;
        }
        FileObject mainTemplate = FileUtil.getConfigFile((String)template);
        if (mainTemplate == null) {
            return null;
        }
        String createdMainName = mainName;
        if (mainName.indexOf(92) > 0 || mainName.indexOf(47) > 0) {
            File file = new File(srcFolder.getPath(), mainName).getCanonicalFile();
            srcFolder = FileUtil.createFolder((File)file.getParentFile());
            createdMainName = file.getName();
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        DataFolder pDf = DataFolder.findFolder((FileObject)srcFolder);
        mt.createFromTemplate(pDf, createdMainName);
        return mainName;
    }
}

