/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.model;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.StringInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.profile.ProfilesModel;
import org.netbeans.modules.maven.model.profile.ProfilesModelFactory;
import org.netbeans.modules.maven.model.settings.SettingsModel;
import org.netbeans.modules.maven.model.settings.SettingsModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class Utilities {
    private static final Logger logger = Logger.getLogger(Utilities.class.getName());
    private static final String PROFILES_SKELETON = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<profilesXml xmlns=\"http://maven.apache.org/PROFILES/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://maven.apache.org/PROFILES/1.0.0 http://maven.apache.org/xsd/profiles-1.0.0.xsd\">\n</profilesXml>";

    public static ModelSource createModelSourceForMissingFile(File file, boolean editable, String skeleton, String mimeType) {
        try {
            BaseDocument doc = new BaseDocument(false, mimeType);
            doc.insertString(0, skeleton, null);
            InstanceContent ic = new InstanceContent();
            AbstractLookup lookup = new AbstractLookup((AbstractLookup.Content)ic);
            ic.add((Object)file);
            ic.add((Object)doc);
            ModelSource ms = new ModelSource((Lookup)lookup, editable);
            return ms;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            assert (false) : "Failed to load the model for non-existing file";
            return null;
        }
    }

    public static Document getDocument(FileObject modelSourceFileObject) {
        Document result = null;
        try {
            DataObject dObject = DataObject.find((FileObject)modelSourceFileObject);
            EditorCookie ec = (EditorCookie)dObject.getCookie(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            if (doc instanceof BaseDocument) {
                return doc;
            }
        }
        catch (Exception dObjEx) {
            return null;
        }
        return result;
    }

    private static Document _getDocument(DataObject modelSourceDataObject) throws IOException {
        StyledDocument result = null;
        if (modelSourceDataObject != null && modelSourceDataObject.isValid()) {
            EditorCookie ec = (EditorCookie)modelSourceDataObject.getCookie(EditorCookie.class);
            assert (ec != null) : "Data object " + modelSourceDataObject.getPrimaryFile().getPath() + " has no editor cookies.";
            StyledDocument doc = null;
            try {
                doc = ec.openDocument();
            }
            catch (UserQuestionException uce) {
                uce.confirmed();
                doc = ec.openDocument();
            }
            result = doc;
        }
        return result;
    }

    protected static Document _getDocument(FileObject modelSourceFileObject) throws DataObjectNotFoundException, IOException {
        DataObject dObject = DataObject.find((FileObject)modelSourceFileObject);
        return Utilities._getDocument(dObject);
    }

    public static FileObject getFileObject(ModelSource ms) {
        return (FileObject)ms.getLookup().lookup(FileObject.class);
    }

    public static CatalogModel getCatalogModel(ModelSource ms) throws CatalogModelException {
        return CatalogModelFactory.getDefault().getCatalogModel(ms);
    }

    public static ModelSource createModelSource(FileObject thisFileObj) {
        DataObject tempdobj;
        assert (thisFileObj != null) : "Null file object.";
        final FileObject fobj = thisFileObj;
        try {
            tempdobj = DataObject.find((FileObject)fobj);
        }
        catch (DataObjectNotFoundException ex) {
            tempdobj = null;
        }
        final DataObject dobj = tempdobj;
        final File fl = FileUtil.toFile((FileObject)fobj);
        boolean editable = fl != null;
        Lookup proxyLookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

            public Lookup getLookup() {
                Document document = null;
                try {
                    document = Utilities._getDocument(dobj);
                    if (document != null) {
                        return Lookups.fixed((Object[])new Object[]{fobj, dobj, fl, document});
                    }
                    return Lookups.fixed((Object[])new Object[]{fobj, dobj, fl});
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, ioe.getMessage());
                    return Lookups.fixed((Object[])new Object[]{fobj, dobj, fl});
                }
            }
        });
        return new ModelSource(proxyLookup, editable);
    }

    public static void saveChanges(AbstractDocumentModel model) throws IOException {
        if (model.isIntransaction()) {
            model.endTransaction();
        }
        model.sync();
        DataObject dobj = (DataObject)model.getModelSource().getLookup().lookup(DataObject.class);
        if (dobj == null) {
            FileObject fParentFo;
            final Document doc = (Document)model.getModelSource().getLookup().lookup(Document.class);
            final File file = (File)model.getModelSource().getLookup().lookup(File.class);
            File parent = file.getParentFile();
            FileObject parentFo = FileUtil.toFileObject((File)parent);
            if (parentFo == null) {
                parent.mkdirs();
                FileUtil.refreshFor((File[])new File[]{parent});
                parentFo = FileUtil.toFileObject((File)parent);
            }
            if ((fParentFo = parentFo) != null) {
                FileSystem fs = parentFo.getFileSystem();
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        FileObject fo = fParentFo.getFileObject(file.getName());
                        if (fo == null) {
                            fo = fParentFo.createData(file.getName());
                        }
                        OutputStream out = null;
                        try {
                            String text = doc.getText(0, doc.getLength());
                            StringInputStream in = new StringInputStream(text);
                            out = fo.getOutputStream();
                            FileUtil.copy((InputStream)in, (OutputStream)out);
                            out.close();
                            IOUtil.close((OutputStream)out);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            IOUtil.close(out);
                        }
                    }
                });
            }
        } else {
            SaveCookie save = (SaveCookie)dobj.getLookup().lookup(SaveCookie.class);
            if (save != null) {
                save.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performPOMModelOperations(FileObject pomFileObject, List<ModelOperation<POMModel>> operations) {
        assert (pomFileObject != null);
        assert (operations != null);
        ModelSource source = Utilities.createModelSource(pomFileObject);
        POMModel model = POMModelFactory.getDefault().getModel(source);
        if (model != null) {
            try {
                model.sync();
                if (Model.State.VALID != model.getState()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_POM", (Object)NbBundle.getMessage(Utilities.class, (String)"ERR_INVALID_MODEL")), 700).clear(10000);
                    return;
                }
                model.startTransaction();
                for (ModelOperation<POMModel> op : operations) {
                    op.performOperation(model);
                }
                model.endTransaction();
                Utilities.saveChanges(model);
            }
            catch (IOException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_POM", (Object)ex.getLocalizedMessage()), 700).clear(10000);
                Logger.getLogger(Utilities.class.getName()).log(Level.INFO, "Canot write POM", ex);
            }
            finally {
                if (model.isIntransaction()) {
                    model.rollbackTransaction();
                }
            }
        } else {
            Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "Cannot create model from current content of " + pomFileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performProfilesModelOperations(FileObject profilesFileObject, List<ModelOperation<ProfilesModel>> operations) {
        assert (profilesFileObject != null);
        assert (operations != null);
        ModelSource source = profilesFileObject.getSize() == 0L ? Utilities.createModelSourceForMissingFile(FileUtil.toFile((FileObject)profilesFileObject), true, PROFILES_SKELETON, "text/x-maven-profile+xml") : Utilities.createModelSource(profilesFileObject);
        ProfilesModel model = ProfilesModelFactory.getDefault().getModel(source);
        if (model != null) {
            try {
                model.sync();
                if (Model.State.VALID != model.getState()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_PROFILE", (Object)NbBundle.getMessage(Utilities.class, (String)"ERR_INVALID_MODEL")), 700).clear(10000);
                    return;
                }
                model.startTransaction();
                for (ModelOperation<ProfilesModel> op : operations) {
                    op.performOperation(model);
                }
                model.endTransaction();
                Utilities.saveChanges(model);
            }
            catch (IOException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_PROFILE", (Object)ex.getLocalizedMessage()), 700).clear(10000);
                Logger.getLogger(Utilities.class.getName()).log(Level.INFO, "Cannot write profiles.xml", ex);
            }
            finally {
                if (model.isIntransaction()) {
                    model.rollbackTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performSettingsModelOperations(FileObject settingsFileObject, List<ModelOperation<SettingsModel>> operations) {
        assert (settingsFileObject != null);
        assert (operations != null);
        ModelSource source = Utilities.createModelSource(settingsFileObject);
        SettingsModel model = SettingsModelFactory.getDefault().getModel(source);
        if (model != null) {
            try {
                model.sync();
                if (Model.State.VALID != model.getState()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_PROFILE", (Object)NbBundle.getMessage(Utilities.class, (String)"ERR_INVALID_MODEL")), 700).clear(10000);
                    return;
                }
                model.startTransaction();
                for (ModelOperation<SettingsModel> op : operations) {
                    op.performOperation(model);
                }
                model.endTransaction();
                Utilities.saveChanges(model);
            }
            catch (IOException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Utilities.class, (String)"ERR_SETTINGS", (Object)ex.getLocalizedMessage()), 700).clear(10000);
                Logger.getLogger(Utilities.class.getName()).log(Level.INFO, "Cannot write settings.xml", ex);
            }
            finally {
                if (model.isIntransaction()) {
                    model.rollbackTransaction();
                }
            }
        }
    }
}

