/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;

public class PPDirectiveCompletionItem
implements CompletionItem {
    private static ImageIcon icon;
    private final String name;
    private final String description;
    private String leftText;

    public PPDirectiveCompletionItem(String name, String desc) {
        this.name = name;
        this.description = desc;
    }

    public void defaultAction(JTextComponent component) {
        this.substitute(component, this.name);
        Completion.get().hideAll();
    }

    public void processKeyEvent(KeyEvent event) {
        if (event.getKeyChar() == ' ' && !event.isControlDown()) {
            Completion.get().hideCompletion();
        }
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        PPDirectiveCompletionItem pPDirectiveCompletionItem = this;
        synchronized (pPDirectiveCompletionItem) {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mobility/editor/resources/d.png", (boolean)false);
            }
        }
        if (selected) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
            g.setColor(defaultColor);
        }
        CompletionUtilities.renderHtml((ImageIcon)icon, (String)this.getLeftText(), (String)this.getRightText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }

    public int getSortPriority() {
        return 50;
    }

    public CharSequence getSortText() {
        return this.name;
    }

    private String getLeftText() {
        if (this.leftText == null) {
            this.leftText = "<b>" + PPDirectiveCompletionItem.toHtmlText(this.name) + "</b>  ";
        }
        return this.leftText;
    }

    private String getRightText() {
        return PPDirectiveCompletionItem.toHtmlText(this.description);
    }

    private void substitute(JTextComponent component, String directive) {
        int offset = component.getCaret().getDot();
        Document doc = component.getDocument();
        try {
            int wordStart = Utilities.getWordStart((JTextComponent)component, (int)offset);
            int wordEnd = Utilities.getWordEnd((JTextComponent)component, (int)offset);
            if (wordStart > 0) {
                String word = doc.getText(wordStart, wordEnd - wordStart);
                if (word.startsWith("//#")) {
                    word = word.substring(3);
                    wordStart += 3;
                }
                doc.remove(wordStart, word.length());
                doc.insertString(wordStart, directive, null);
            } else {
                doc.insertString(offset, directive, null);
            }
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    private static String toHtmlText(String text) {
        StringBuffer htmlText = null;
        for (int i = 0; i < text.length(); ++i) {
            String rep;
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                    break;
                }
                case '\n': {
                    rep = "<br>";
                    break;
                }
                default: {
                    rep = null;
                }
            }
            if (rep != null) {
                if (htmlText == null) {
                    htmlText = new StringBuffer(120 * text.length() / 100);
                    if (i > 0) {
                        htmlText.append(text.substring(0, i));
                    }
                }
                htmlText.append(rep);
                continue;
            }
            if (htmlText == null) continue;
            htmlText.append(ch);
        }
        return htmlText != null ? htmlText.toString() : text;
    }

    public CharSequence getInsertPrefix() {
        return this.name;
    }
}

