/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import org.netbeans.modules.editor.options.ScrollInsetsCustomEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class ScrollInsetsEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private PropertyEnv env;

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new ScrollInsetsCustomEditor(this, this.env);
    }

    @Override
    public String getAsText() {
        Insets val = (Insets)this.getValue();
        if (val == null) {
            return null;
        }
        return "[" + this.int2percent(val.top) + ',' + this.int2percent(val.left) + ',' + this.int2percent(val.bottom) + ',' + this.int2percent(val.right) + ']';
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        int[] newVal = new int[4];
        int nextNumber = 0;
        StringTokenizer tuk = new StringTokenizer(text, "[] ,;", false);
        while (tuk.hasMoreTokens()) {
            String token = tuk.nextToken();
            if (nextNumber >= 4) {
                this.badFormat();
            }
            try {
                newVal[nextNumber++] = this.percent2int(token);
            }
            catch (NumberFormatException e) {
                this.badFormat();
            }
        }
        if (nextNumber != 4 && nextNumber > 0) {
            int copyValue = newVal[nextNumber - 1];
            for (int i = nextNumber; i < 4; ++i) {
                newVal[i] = copyValue;
            }
        }
        this.setValue(new Insets(newVal[0], newVal[1], newVal[2], newVal[3]));
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage(ScrollInsetsEditor.class, (String)s);
    }

    private void badFormat() throws IllegalArgumentException {
        throw new IllegalArgumentException(this.getBundleString("SIE_EXC_BadFormatValue"));
    }

    private String int2percent(int i) {
        if (i < 0) {
            return "" + -i + '%';
        }
        return "" + i;
    }

    private int percent2int(String val) throws NumberFormatException {
        if ((val = val.trim()).endsWith("%")) {
            return -Integer.parseInt(val.substring(0, val.length() - 1));
        }
        return Integer.parseInt(val);
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }
}

