/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class CsmModificationRefactoringPlugin
extends CsmRefactoringPlugin {
    private final CsmObject startReferenceObject;
    private final CsmContext editorContext;
    private final AbstractRefactoring refactoring;

    protected CsmModificationRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
        this.startReferenceObject = (CsmObject)refactoring.getRefactoringSource().lookup(CsmObject.class);
        this.editorContext = (CsmContext)refactoring.getRefactoringSource().lookup(CsmContext.class);
        assert (this.startReferenceObject != null || this.editorContext != null) : "no start reference or editor context";
    }

    protected final CsmObject getStartReferenceObject() {
        return this.startReferenceObject;
    }

    protected final CsmContext getEditorContext() {
        return this.editorContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Problem prepare(RefactoringElementsBag elements) {
        Problem out = null;
        try {
            Collection<CsmFile> files = this.getRefactoredFiles();
            this.fireProgressListenerStart(1, files.size());
            out = this.createAndAddElements(files, elements, this.refactoring);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return out;
    }

    protected abstract Collection<CsmFile> getRefactoredFiles();

    protected final Problem checkIfModificationPossible(Problem problem, CsmObject referencedObject, String fatalMessage, String warnMessage) {
        problem = this.checkIfModificationPossibleInFile(problem, referencedObject);
        this.fireProgressListenerStep();
        if (problem != null) {
            return problem;
        }
        if (CsmKindUtilities.isMethod((CsmObject)referencedObject)) {
            Collection overridenMethods;
            this.fireProgressListenerStep();
            CsmMethod method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)referencedObject));
            if (CsmVirtualInfoQuery.getDefault().isVirtual(method) && (overridenMethods = CsmVirtualInfoQuery.getDefault().getOverriddenMethods(method, true)).size() > 1) {
                for (CsmMethod csmMethod : overridenMethods) {
                    problem = this.checkIfModificationPossibleInFile(problem, (CsmObject)csmMethod);
                    CsmFunctionDefinition def = csmMethod.getDefinition();
                    if (def == null || csmMethod.equals(def)) continue;
                    problem = this.checkIfModificationPossibleInFile(problem, (CsmObject)def);
                }
                boolean fatal = problem != null;
                String msg = fatal ? fatalMessage : warnMessage;
                problem = CsmModificationRefactoringPlugin.createProblem(problem, fatal, msg);
            }
        } else {
            this.fireProgressListenerStep();
        }
        return problem;
    }

    private Problem checkIfModificationPossibleInFile(Problem problem, CsmObject csmObject) {
        CsmFile csmFile = null;
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmFile = (CsmFile)csmObject;
        } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        }
        if (csmFile != null) {
            FileObject fo = CsmUtilities.getFileObject((CsmFile)csmFile);
            if (!CsmRefactoringUtils.isRefactorable(fo)) {
                problem = CsmModificationRefactoringPlugin.createProblem(problem, true, this.getCannotRename(fo));
            }
            if (problem == null && !CsmRefactoringUtils.isElementInOpenProject(fo)) {
                problem = new Problem(true, NbBundle.getMessage(CsmModificationRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
        }
        return problem;
    }

    private String getCannotRename(FileObject r) {
        return new MessageFormat(NbBundle.getMessage(CsmModificationRefactoringPlugin.class, (String)"ERR_CannotModifyInFile")).format(new Object[]{r.getNameExt()});
    }

    @Override
    protected final ModificationResult processFiles(Collection<CsmFile> files, AtomicReference<Problem> outProblem) {
        ModificationResult out = null;
        for (CsmFile csmFile : files) {
            if (this.isCancelled()) {
                return null;
            }
            if (out == null) {
                out = new ModificationResult(csmFile.getProject());
            }
            this.processFile(csmFile, out, outProblem);
            this.fireProgressListenerStep();
        }
        return out;
    }

    protected abstract void processFile(CsmFile var1, ModificationResult var2, AtomicReference<Problem> var3);
}

