/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.GraphicUtils;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.openide.util.ImageUtilities;

public final class RotateActionFactory
extends AbstractComposerActionFactory {
    private static final int ROTATE_PIVOT_SIZE = 4;
    private static final Color COLOR_ROTATE_PIVOT_BODY = Color.BLACK;
    private static final Color COLOR_ROTATE_PIVOT_OUTLINE = Color.WHITE;
    private static final ActionMouseCursor ROTATE_MOUSE_CURSOR = new ActionMouseCursor(Toolkit.getDefaultToolkit().createCustomCursor(ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/svgcore/resources/rotate_cursor.png"), new Point(8, 8), "rotateCursor"), 3);

    public RotateActionFactory(SceneManager sceneMgr) {
        super(sceneMgr);
    }

    @Override
    public synchronized ComposerAction startAction(AWTEvent e, boolean isOutsideEvent) {
        MouseEvent me;
        SVGObject selObj;
        if (!isOutsideEvent && !this.m_sceneMgr.isReadOnly() && e.getID() == 501 && (selObj = this.getObjectToRotateAt(me = (MouseEvent)e)) != null) {
            return new RotateAction(selObj, me);
        }
        return null;
    }

    @Override
    public ActionMouseCursor getMouseCursor(MouseEvent evt, boolean isOutsideEvent) {
        if (!isOutsideEvent && this.getObjectToRotateAt(evt) != null) {
            return ROTATE_MOUSE_CURSOR;
        }
        return null;
    }

    private SVGObject getObjectToRotateAt(MouseEvent me) {
        SVGObject selObj;
        SVGObject[] selectedObjects = this.m_sceneMgr.getSelected();
        if (selectedObjects != null && selectedObjects.length > 0 && (selObj = selectedObjects[0]).getOutline().isAtRotateHandlePoint(me.getX(), me.getY())) {
            return selObj;
        }
        return null;
    }

    private class RotateAction
    extends AbstractComposerAction {
        private final SVGObject m_rotated;
        private final float m_initialAngle;

        public RotateAction(SVGObject rotated, MouseEvent me) {
            super(RotateActionFactory.this);
            this.m_rotated = rotated;
            this.repaintRotatePivot();
            this.m_initialAngle = this.calculateRotate(me.getX(), me.getY());
        }

        @Override
        public boolean consumeEvent(AWTEvent evt, boolean isOutsideEvent) {
            if (!isOutsideEvent && evt.getID() == 506) {
                MouseEvent me = (MouseEvent)evt;
                Rectangle bBox = this.m_rotated.getScreenBBox();
                float angleDiff = this.calculateRotate(me.getX(), me.getY()) - this.m_initialAngle;
                if (angleDiff < 0.0f) {
                    angleDiff += 360.0f;
                }
                this.m_rotated.rotate(angleDiff);
                bBox.add(this.m_rotated.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(bBox, 5);
            } else if (evt.getID() == 502) {
                this.actionCompleted();
                this.m_rotated.commitChanges();
            }
            return false;
        }

        @Override
        public void paint(Graphics g, int x, int y, boolean isReadOnly) {
            if (!isReadOnly) {
                float[] pt = this.m_rotated.getOutline().getRotatePivotPoint();
                GraphicUtils.drawRoundSelectorCorner(g, COLOR_ROTATE_PIVOT_OUTLINE, COLOR_ROTATE_PIVOT_BODY, (int)(pt[0] + (float)x), (int)(pt[1] + (float)y), 4);
            }
        }

        @Override
        public ActionMouseCursor getMouseCursor(boolean isOutsideEvent) {
            return isOutsideEvent ? null : ROTATE_MOUSE_CURSOR;
        }

        @Override
        public void actionCompleted() {
            this.m_rotated.repaint(5);
            this.repaintRotatePivot();
            this.m_rotated.applyTextChanges();
            this.m_rotated.commitChanges();
            if (this.getScreenManager().getShowAllArea()) {
                this.getScreenManager().refresh();
            }
            super.actionCompleted();
        }

        private void repaintRotatePivot() {
            float[] pt = this.m_rotated.getOutline().getRotatePivotPoint();
            this.m_rotated.repaint((int)pt[0] - 4 - 1, (int)pt[1] - 4 - 1, 11, 11);
        }

        protected float calculateRotate(int x, int y) {
            float[] pivot = this.m_rotated.getOutline().getRotatePivotPoint();
            return GraphicUtils.calcAngle(pivot[0], pivot[1], x, y);
        }
    }
}

