/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.modules.apisupport.project.ui.SuiteOperations;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.branding.BrandingEditor;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizer;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.awt.DynamicMenuContent;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class SuiteActions
implements ActionProvider {
    private final SuiteProject project;
    private static final int PROMPT_FOR_APP_NAME_MODE_JNLP = 0;
    private static final int PROMPT_FOR_APP_NAME_MODE_ZIP = 1;

    static Action[] getProjectActions(SuiteProject suiteProject) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(CommonProjectActions.newFileAction());
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_rebuild"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_clean"), null));
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_run"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_debug"), null));
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/Profiler_Actions_temporary"));
        arrayList.add(null);
        NbPlatform nbPlatform = suiteProject.getPlatform(true);
        if (nbPlatform != null && nbPlatform.getHarnessVersion().compareTo(HarnessVersion.V61) >= 0) {
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_test"), null));
            arrayList.add(null);
        }
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build-zip", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_zip"), null));
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build-jnlp", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build_jnlp"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run-jnlp", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_run_jnlp"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug-jnlp", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_debug_jnlp"), null));
        arrayList.add(null);
        if (nbPlatform != null && nbPlatform.getHarnessVersion().compareTo(HarnessVersion.V69) >= 0) {
            arrayList.add(new OSGiSubMenuAction());
            arrayList.add(null);
        }
        if (nbPlatform != null && nbPlatform.getHarnessVersion().compareTo(HarnessVersion.V55u1) >= 0) {
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build-mac", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_mac"), null));
            arrayList.add(null);
        }
        if (nbPlatform != null && nbPlatform.getHarnessVersion().compareTo(HarnessVersion.V50u1) >= 0) {
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"nbms", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_nbms"), null));
            arrayList.add(null);
        }
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/org-netbeans-modules-apisupport-project-suite/Actions"));
        arrayList.add(null);
        arrayList.add(CommonProjectActions.setAsMainProjectAction());
        arrayList.add(CommonProjectActions.openSubprojectsAction());
        arrayList.add(CommonProjectActions.closeProjectAction());
        arrayList.add(null);
        arrayList.add(CommonProjectActions.renameProjectAction());
        arrayList.add(CommonProjectActions.moveProjectAction());
        arrayList.add(CommonProjectActions.deleteProjectAction());
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(FindAction.class));
        arrayList.add(null);
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"branding", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_branding"), null));
        arrayList.add(CommonProjectActions.customizeProjectAction());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public SuiteActions(SuiteProject suiteProject) {
        this.project = suiteProject;
    }

    public String[] getSupportedActions() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("build", "clean", "rebuild", "run", "debug", "build-zip", "build-jnlp", "run-jnlp", "debug-jnlp", "build-osgi", "build-osgi-obr", "run-osgi", "debug-osgi", "profile-osgi", "build-mac", "nbms", "profile", "branding", "rename", "move", "delete"));
        NbPlatform nbPlatform = this.project.getPlatform(true);
        if (nbPlatform != null && nbPlatform.getHarnessVersion().compareTo(HarnessVersion.V61) >= 0) {
            arrayList.add("test");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        if ("branding".equals(string)) {
            boolean bl = false;
            EditableProperties editableProperties = this.project.getHelper().getProperties("nbproject/project.properties");
            if (null != editableProperties) {
                String string2 = editableProperties.get((Object)"branding.token");
                bl = null != string2;
            }
            return bl;
        }
        if ("delete".equals(string) || "rename".equals(string) || "move".equals(string)) {
            return true;
        }
        if (Arrays.asList(this.getSupportedActions()).contains(string)) {
            return SuiteActions.findBuildXml(this.project) != null;
        }
        throw new IllegalArgumentException(string);
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            if (SuiteOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            }
        } else if ("rename".equals(string)) {
            if (SuiteOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            }
        } else if ("move".equals(string)) {
            if (SuiteOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            }
        } else if ("branding".equals(string)) {
            BrandingEditor.open(this.project);
        } else {
            ExecutorTask[] executorTaskArray;
            Object object;
            HarnessVersion harnessVersion;
            NbPlatform nbPlatform = this.project.getPlatform(false);
            if (nbPlatform != null && (harnessVersion = nbPlatform.getHarnessVersion()) != HarnessVersion.UNKNOWN) {
                object = ((SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class)).getSubprojects().iterator();
                while (object.hasNext()) {
                    executorTaskArray = (ExecutorTask[])object.next();
                    if (harnessVersion.compareTo(((NbModuleProject)executorTaskArray).getMinimumHarnessVersion()) >= 0) continue;
                    ModuleActions.promptForNewerHarness();
                    return;
                }
            }
            harnessVersion = null;
            try {
                harnessVersion = this.invokeActionImpl(string, lookup);
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
            }
            if (harnessVersion != null && (object = (ActionEvent)lookup.lookup(ActionEvent.class)) != null && "waitFinished".equals(((ActionEvent)object).getActionCommand())) {
                harnessVersion.waitFinished();
                if (((EventObject)object).getSource() instanceof ExecutorTask[] && (executorTaskArray = (ExecutorTask[])((EventObject)object).getSource()).length > 0) {
                    executorTaskArray[0] = harnessVersion;
                }
            }
        }
    }

    public ExecutorTask invokeActionImpl(String string, Lookup lookup) throws IllegalArgumentException, IOException {
        String[] stringArray;
        Properties properties = null;
        if (string.equals("build")) {
            stringArray = new String[]{"build"};
        } else if (string.equals("clean")) {
            stringArray = new String[]{"clean"};
        } else if (string.equals("rebuild")) {
            stringArray = new String[]{"clean", "build"};
        } else if (string.equals("run")) {
            if (this.project.getTestUserDirLockFile().isFile()) {
                properties = new Properties();
                properties.setProperty("run.args.ide", "--test-userdir-lock-with-invalid-arg");
            }
            stringArray = new String[]{"run"};
        } else if (string.equals("debug")) {
            if (this.project.getTestUserDirLockFile().isFile()) {
                properties = new Properties();
                properties.setProperty("run.args.ide", "--test-userdir-lock-with-invalid-arg");
            }
            stringArray = new String[]{"debug"};
        } else if (string.equals("test")) {
            stringArray = new String[]{"test"};
        } else if (string.equals("build-zip")) {
            if (this.promptForAppName(1)) {
                return null;
            }
            stringArray = new String[]{"build-zip"};
        } else if (string.equals("build-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            stringArray = new String[]{"build-jnlp"};
        } else if (string.equals("run-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            stringArray = new String[]{"run-jnlp"};
        } else if (string.equals("debug-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            stringArray = new String[]{"debug-jnlp"};
        } else {
            stringArray = new String[]{string};
        }
        return ActionUtils.runTarget((FileObject)SuiteActions.findBuildXml(this.project), (String[])stringArray, properties);
    }

    private static FileObject findBuildXml(SuiteProject suiteProject) {
        return suiteProject.getProjectDirectory().getFileObject("build.xml");
    }

    private boolean promptForAppName(int n) {
        String string;
        String string2 = this.project.getEvaluator().getProperty("app.name");
        if (string2 != null) {
            return false;
        }
        switch (n) {
            case 0: {
                string = NbBundle.getMessage(ModuleActions.class, (String)"ERR_app_name_jnlp");
                break;
            }
            case 1: {
                string = NbBundle.getMessage(ModuleActions.class, (String)"ERR_app_name_zip");
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        if (UIUtil.showAcceptCancelDialog(NbBundle.getMessage(ModuleActions.class, (String)"TITLE_app_name"), string, NbBundle.getMessage(ModuleActions.class, (String)"LBL_configure_app_name"), NbBundle.getMessage(ModuleActions.class, (String)"ACSD_configure_app_name"), null, 2)) {
            SuiteCustomizer suiteCustomizer = (SuiteCustomizer)this.project.getLookup().lookup(SuiteCustomizer.class);
            suiteCustomizer.showCustomizer("Application", "standaloneApp");
        }
        return true;
    }

    private static class OSGiSubMenuAction
    extends AbstractAction
    implements Presenter.Popup {
        private OSGiSubMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (false);
        }

        public JMenuItem getPopupPresenter() {
            class Menu
            extends JMenu
            implements DynamicMenuContent {
                Menu() {
                    super(NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_osgi_menu"));
                }

                public JComponent[] getMenuPresenters() {
                    return new JComponent[]{this};
                }

                public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
                    return this.getMenuPresenters();
                }
            }
            Menu menu = new Menu();
            menu.add(ProjectSensitiveActions.projectCommandAction((String)"build-osgi", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build_osgi"), null));
            menu.add(ProjectSensitiveActions.projectCommandAction((String)"build-osgi-obr", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build_osgi_obr"), null));
            menu.add(ProjectSensitiveActions.projectCommandAction((String)"run-osgi", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_run_osgi"), null));
            menu.add(ProjectSensitiveActions.projectCommandAction((String)"debug-osgi", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_debug_osgi"), null));
            menu.add(ProjectSensitiveActions.projectCommandAction((String)"profile-osgi", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_profile_osgi"), null));
            return menu;
        }
    }
}

