/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.SideEffectMethodMarker;

public class SideEffectInstructionChecker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private final boolean includeReturnInstructions;
    private boolean hasSideEffects;

    public SideEffectInstructionChecker(boolean bl) {
        this.includeReturnInstructions = bl;
    }

    public boolean hasSideEffects(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        this.hasSideEffects = false;
        instruction.accept(clazz, method, codeAttribute, n, this);
        return this.hasSideEffects;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        byte by = simpleInstruction.opcode;
        if (by == 79 || by == 80 || by == 81 || by == 82 || by == 83 || by == 84 || by == 85 || by == 86 || by == -65 || by == -62 || by == -61 || this.includeReturnInstructions && (by == -84 || by == -83 || by == -82 || by == -81 || by == -80 || by == -79)) {
            this.hasSideEffects = true;
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        byte by = variableInstruction.opcode;
        if (this.includeReturnInstructions && by == -87) {
            this.hasSideEffects = true;
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        byte by = constantInstruction.opcode;
        if (by == -77 || by == -75 || by == -74 || by == -73 || by == -72 || by == -71) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        byte by = branchInstruction.opcode;
        if (this.includeReturnInstructions && (by == -88 || by == -55)) {
            this.hasSideEffects = true;
        }
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        this.hasSideEffects = true;
        fieldrefConstant.referencedMemberAccept(this);
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        Member member = refConstant.referencedMember;
        if (member == null) {
            this.hasSideEffects = true;
        } else {
            refConstant.referencedMemberAccept(this);
            if (!this.hasSideEffects) {
                Clazz clazz2 = refConstant.referencedClass;
                Method method = (Method)member;
                if ((method.getAccessFlags() & 2) == 0) {
                    clazz.hierarchyAccept(false, false, false, true, new NamedMethodVisitor(method.getName(clazz2), method.getDescriptor(clazz2), this));
                }
            }
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.hasSideEffects = ReadWriteFieldMarker.isRead(programField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.hasSideEffects = this.hasSideEffects || SideEffectMethodMarker.hasSideEffects(programMethod);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.hasSideEffects = true;
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.hasSideEffects = this.hasSideEffects || !NoSideEffectMethodMarker.hasNoSideEffects(libraryMethod);
    }
}

