/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public abstract class AbstractSystemAction
extends NodeAction {
    protected abstract String getBaseName(Node[] var1);

    protected AbstractSystemAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] nodes) {
        LifecycleManager.getDefault().saveAll();
        org.netbeans.modules.versioning.util.Utils.logVCSActionEvent((String)"CVS");
        this.performCvsAction(nodes);
    }

    protected boolean enable(Node[] nodes) {
        File[] rootFiles = this.getCachedContext(nodes).getRootFiles();
        return rootFiles.length > 0 && CvsVersioningSystem.isManaged(rootFiles[0]);
    }

    protected abstract void performCvsAction(Node[] var1);

    public final boolean isEnabled() {
        return super.isEnabled();
    }

    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public final void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
    }

    public final void performAction() {
        super.performAction();
    }

    public String getName() {
        return this.getName("", TopComponent.getRegistry().getActivatedNodes());
    }

    public String getRunningName(Node[] activatedNodes) {
        return this.getName("Running", activatedNodes);
    }

    private String getName(String role, Node[] activatedNodes) {
        String baseName = this.getBaseName(activatedNodes) + role;
        if (!this.isEnabled()) {
            return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName);
        }
        File[] nodes = Utils.getCurrentContext(activatedNodes, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus(), true).getFiles();
        int objectCount = nodes.length;
        boolean projectsOnly = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node activatedNode = activatedNodes[i];
            Project project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (project != null) continue;
            projectsOnly = false;
            break;
        }
        if (projectsOnly) {
            objectCount = activatedNodes.length;
        }
        if (objectCount == 0) {
            return NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName);
        }
        if (objectCount == 1) {
            String name;
            if (projectsOnly) {
                String dispName = ProjectUtils.getInformation((Project)((Project)activatedNodes[0].getLookup().lookup(Project.class))).getDisplayName();
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(baseName + "_Context"), (Object)dispName);
            }
            FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                name = fo.getNameExt();
            } else {
                DataObject dao = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
                if (dao instanceof DataShadow) {
                    dao = ((DataShadow)dao).getOriginal();
                }
                name = dao != null ? dao.getPrimaryFile().getNameExt() : activatedNodes[0].getDisplayName();
            }
            return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName + "_Context"), name);
        }
        if (projectsOnly) {
            try {
                return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName + "_Projects"), new Integer(objectCount));
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString(baseName + "_Context_Multiple"), new Integer(objectCount));
    }

    public String getContextDisplayName(Node[] activatedNodes) {
        File[] nodes = Utils.getCurrentContext(activatedNodes, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus(), true).getFiles();
        int objectCount = nodes.length;
        boolean projectsOnly = true;
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node activatedNode = activatedNodes[i];
            Project project = (Project)activatedNode.getLookup().lookup(Project.class);
            if (project != null) continue;
            projectsOnly = false;
            break;
        }
        if (projectsOnly) {
            objectCount = activatedNodes.length;
        }
        if (objectCount == 0) {
            return null;
        }
        if (objectCount == 1) {
            if (projectsOnly) {
                return ProjectUtils.getInformation((Project)((Project)activatedNodes[0].getLookup().lookup(Project.class))).getDisplayName();
            }
            FileObject fo = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
            if (fo != null) {
                return fo.getNameExt();
            }
            DataObject dao = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
            if (dao instanceof DataShadow) {
                dao = ((DataShadow)dao).getOriginal();
            }
            if (dao != null) {
                return dao.getPrimaryFile().getNameExt();
            }
            return activatedNodes[0].getDisplayName();
        }
        if (projectsOnly) {
            try {
                return MessageFormat.format(NbBundle.getBundle(AbstractSystemAction.class).getString("MSG_ActionContext_MultipleProjects"), new Integer(objectCount));
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(AbstractSystemAction.class).getString("MSG_ActionContext_MultipleFiles"), new Integer(objectCount));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected Context getContext(Node[] nodes) {
        return Utils.getCurrentContext(nodes, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus(), false);
    }

    protected Context getCachedContext(Node[] nodes) {
        return Utils.getCurrentContext(nodes, this.getFileEnabledStatus(), this.getDirectoryEnabledStatus(), true);
    }

    protected int getFileEnabledStatus() {
        return -1;
    }

    protected int getDirectoryEnabledStatus() {
        return -4;
    }
}

