/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public final class PathUiSupport {
    private PathUiSupport() {
    }

    public static DefaultListModel createListModel(Iterator<BasePathSupport.Item> it) {
        DefaultListModel<BasePathSupport.Item> model = new DefaultListModel<BasePathSupport.Item>();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        return model;
    }

    public static Iterator<BasePathSupport.Item> getIterator(DefaultListModel model) {
        return PathUiSupport.getList(model).iterator();
    }

    public static List<BasePathSupport.Item> getList(DefaultListModel model) {
        return Collections.list(NbCollections.checkedEnumerationByFilter(model.elements(), BasePathSupport.Item.class, (boolean)true));
    }

    public static int[] moveUp(DefaultListModel listModel, int[] indices) {
        int i;
        if (indices == null || indices.length == 0) assert (false) : "MoveUp button should be disabled";
        for (i = 0; i < indices.length; ++i) {
            Object item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] - 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] - 1;
        }
        return indices;
    }

    public static boolean canMoveUp(ListSelectionModel selectionModel) {
        return selectionModel.getMinSelectionIndex() > 0;
    }

    public static int[] moveDown(DefaultListModel listModel, int[] indices) {
        int i;
        if (indices == null || indices.length == 0) assert (false) : "MoveDown button should be disabled";
        for (i = indices.length - 1; i >= 0; --i) {
            Object item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] + 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] + 1;
        }
        return indices;
    }

    public static boolean canMoveDown(ListSelectionModel selectionModel, int modelSize) {
        int iMax = selectionModel.getMaxSelectionIndex();
        return iMax != -1 && iMax < modelSize - 1;
    }

    public static int[] remove(DefaultListModel listModel, int[] indices) {
        if (indices == null || indices.length == 0) assert (false) : "Remove button should be disabled";
        for (int i = indices.length - 1; i >= 0; --i) {
            listModel.remove(indices[i]);
        }
        if (!listModel.isEmpty()) {
            int selectedIndex = indices[indices.length - 1] - indices.length + 1;
            if (selectedIndex > listModel.size() - 1) {
                selectedIndex = listModel.size() - 1;
            }
            return new int[]{selectedIndex};
        }
        return new int[0];
    }

    public static int[] addFolders(DefaultListModel listModel, int[] indices, String[] files) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int[] indexes = new int[files.length];
        int i = 0;
        int delta = 0;
        while (i + delta < files.length) {
            int current = lastIndex + 1 + i;
            BasePathSupport.Item item = BasePathSupport.Item.create(files[i + delta], null);
            if (!listModel.contains(item)) {
                listModel.add(current, item);
                indexes[delta + i] = current;
                ++i;
                continue;
            }
            indexes[i + delta] = listModel.indexOf(item);
            ++delta;
        }
        return indexes;
    }

    public static final class EditMediator
    implements ActionListener,
    ListSelectionListener {
        private final PhpProject project;
        private final JList list;
        private final DefaultListModel listModel;
        private final ListSelectionModel selectionModel;
        private final ButtonModel addFolder;
        private final ButtonModel remove;
        private final ButtonModel moveUp;
        private final ButtonModel moveDown;
        private final FileChooserDirectoryHandler directoryHandler;

        private EditMediator(JList list, ButtonModel addFolder, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, FileChooserDirectoryHandler directoryHandler) {
            this(null, list, addFolder, remove, moveUp, moveDown, directoryHandler);
        }

        private EditMediator(PhpProject project, JList list, ButtonModel addFolder, ButtonModel remove, FileChooserDirectoryHandler directoryHandler) {
            this(project, list, addFolder, remove, null, null, directoryHandler);
        }

        private EditMediator(PhpProject project, JList list, ButtonModel addFolder, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, FileChooserDirectoryHandler directoryHandler) {
            assert (directoryHandler != null);
            this.list = list;
            if (!(list.getModel() instanceof DefaultListModel)) {
                throw new IllegalArgumentException("The list's model has to be of class DefaultListModel");
            }
            this.listModel = (DefaultListModel)list.getModel();
            this.selectionModel = list.getSelectionModel();
            this.addFolder = addFolder;
            this.remove = remove;
            this.moveUp = moveUp;
            this.moveDown = moveDown;
            this.project = project;
            this.directoryHandler = directoryHandler;
        }

        public static void register(PhpProject project, JList list, ButtonModel addFolder, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, FileChooserDirectoryHandler directoryHandler) {
            EditMediator em = new EditMediator(project, list, addFolder, remove, moveUp, moveDown, directoryHandler);
            addFolder.addActionListener(em);
            remove.addActionListener(em);
            moveUp.addActionListener(em);
            moveDown.addActionListener(em);
            em.selectionModel.addListSelectionListener(em);
            em.valueChanged(null);
        }

        public static void register(PhpProject project, JList list, ButtonModel addFolder, ButtonModel remove, FileChooserDirectoryHandler directoryHandler) {
            EditMediator em = new EditMediator(project, list, addFolder, remove, directoryHandler);
            addFolder.addActionListener(em);
            remove.addActionListener(em);
            em.selectionModel.addListSelectionListener(em);
            em.valueChanged(null);
        }

        public static void register(JList list, ButtonModel addFolder, ButtonModel remove, ButtonModel moveUp, ButtonModel moveDown, FileChooserDirectoryHandler directoryHandler) {
            EditMediator em = new EditMediator(list, addFolder, remove, moveUp, moveDown, directoryHandler);
            addFolder.addActionListener(em);
            remove.addActionListener(em);
            moveUp.addActionListener(em);
            moveDown.addActionListener(em);
            em.selectionModel.addListSelectionListener(em);
            em.valueChanged(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.addFolder) {
                this.addFolders();
            } else if (source == this.remove) {
                int[] newSelection = PathUiSupport.remove(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            } else if (this.moveUp != null && source == this.moveUp) {
                int[] newSelection = PathUiSupport.moveUp(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            } else if (this.moveDown != null && source == this.moveDown) {
                int[] newSelection = PathUiSupport.moveDown(this.listModel, this.list.getSelectedIndices());
                this.list.setSelectedIndices(newSelection);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.remove.setEnabled(this.selectionModel.getMinSelectionIndex() != -1);
            if (this.moveUp != null) {
                this.moveUp.setEnabled(PathUiSupport.canMoveUp(this.selectionModel));
            }
            if (this.moveDown != null) {
                this.moveDown.setEnabled(PathUiSupport.canMoveDown(this.selectionModel, this.listModel.getSize()));
            }
        }

        private void addFolders() {
            JFileChooser chooser = null;
            chooser = this.project != null ? new FileChooser(this.project.getHelper(), false) : new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(PathUiSupport.class, (String)"LBL_AddFolders_DialogTitle"));
            chooser.setCurrentDirectory(this.directoryHandler.getCurrentDirectory());
            int option = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.list));
            if (option == 0) {
                String[] files;
                try {
                    if (chooser instanceof FileChooser) {
                        files = ((FileChooser)chooser).getSelectedPaths();
                    } else {
                        File[] selectedFiles = chooser.getSelectedFiles();
                        files = new String[selectedFiles.length];
                        for (int i = 0; i < selectedFiles.length; ++i) {
                            files[i] = selectedFiles[i].getAbsolutePath();
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                int[] newSelection = PathUiSupport.addFolders(this.listModel, this.list.getSelectedIndices(), files);
                this.list.setSelectedIndices(newSelection);
                this.directoryHandler.setCurrentDirectory(chooser.getCurrentDirectory());
            }
        }

        public static interface FileChooserDirectoryHandler {
            public File getCurrentDirectory();

            public void setCurrentDirectory(File var1);
        }
    }

    public static class ClassPathListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 619725480128831307L;
        private static final String RESOURCE_ICON_BROKEN_BADGE = "org/netbeans/modules/php/project/ui/resources/brokenProjectBadge.gif";
        private static final String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/php/project/ui/resources/referencedClasspath.gif";
        private static final ImageIcon ICON_BROKEN_BADGE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/brokenProjectBadge.gif", (boolean)false);
        private static final ImageIcon ICON_CLASSPATH = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/referencedClasspath.gif", (boolean)false);
        private static ImageIcon ICON_FOLDER = null;
        private static ImageIcon ICON_BROKEN_FOLDER = null;
        private final PropertyEvaluator evaluator;
        private final FileObject projectFolder;
        private static final Map<String, String> WELL_KNOWN_PATHS_NAMES = new HashMap<String, String>();

        public ClassPathListCellRenderer() {
            this(null, null);
        }

        public ClassPathListCellRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
            this.evaluator = evaluator;
            this.projectFolder = projectFolder;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            BasePathSupport.Item item = (BasePathSupport.Item)value;
            super.getListCellRendererComponent((JList<?>)list, this.getDisplayName(item), index, isSelected, cellHasFocus);
            this.setIcon(ClassPathListCellRenderer.getIcon(item));
            this.setToolTipText(this.getToolTipText(item));
            return this;
        }

        private String getDisplayName(BasePathSupport.Item item) {
            switch (item.getType()) {
                case CLASSPATH: {
                    String name = WELL_KNOWN_PATHS_NAMES.get(BasePathSupport.getAntPropertyName(item.getReference()));
                    return name == null ? item.getReference() : name;
                }
            }
            if (item.isBroken()) {
                return NbBundle.getMessage(PathUiSupport.class, (String)"LBL_MissingFile", (Object)this.getFileRefName(item));
            }
            File f = new File(item.getFilePath());
            if (f.isAbsolute()) {
                return f.getAbsolutePath();
            }
            return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.projectFolder), (String)item.getFilePath()).getAbsolutePath();
        }

        private static Icon getIcon(BasePathSupport.Item item) {
            switch (item.getType()) {
                case CLASSPATH: {
                    return ICON_CLASSPATH;
                }
            }
            if (item.isBroken()) {
                if (ICON_BROKEN_FOLDER == null) {
                    ICON_BROKEN_FOLDER = new ImageIcon(ImageUtilities.mergeImages((Image)ClassPathListCellRenderer.getFolderIcon().getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                }
                return ICON_BROKEN_FOLDER;
            }
            return ClassPathListCellRenderer.getFolderIcon();
        }

        private String getToolTipText(BasePathSupport.Item item) {
            switch (item.getType()) {
                case FOLDER: {
                    if (item.isBroken()) {
                        if (this.evaluator != null) {
                            return this.evaluator.evaluate(item.getReference());
                        }
                        return item.getReference();
                    }
                    String path = item.getFilePath();
                    File f = new File(path);
                    if (f.isAbsolute()) break;
                    assert (this.projectFolder != null) : "project folder cannot be null because not absolute path given [" + f + "]";
                    f = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.projectFolder), (String)path);
                    return f.getAbsolutePath();
                }
            }
            return null;
        }

        private static ImageIcon getFolderIcon() {
            if (ICON_FOLDER == null) {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
                ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
            }
            return ICON_FOLDER;
        }

        private String getFileRefName(BasePathSupport.Item item) {
            switch (item.getType()) {
                case FOLDER: {
                    return item.getFilePath();
                }
            }
            return item.getReference();
        }

        static {
            WELL_KNOWN_PATHS_NAMES.put("php.global.include.path", NbBundle.getMessage(PathUiSupport.class, (String)"LBL_GlobalIncludePath_DisplayName"));
        }
    }
}

