/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import com.sun.source.tree.ClassTree;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.EJBVerificationRule;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.fixes.MakeClassPublic;
import org.netbeans.modules.j2ee.ejbverification.fixes.RemoveModifier;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class LegalModifiers
extends EJBVerificationRule {
    @Override
    public Collection<ErrorDescription> check(EJBProblemContext eJBProblemContext) {
        if (eJBProblemContext.getEjb() != null) {
            ErrorDescription errorDescription;
            Object object;
            LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
            Set<Modifier> set = eJBProblemContext.getClazz().getModifiers();
            if (!set.contains((Object)Modifier.PUBLIC)) {
                object = new MakeClassPublic(eJBProblemContext.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)eJBProblemContext.getClazz()));
                errorDescription = HintsUtils.createProblem((Element)eJBProblemContext.getClazz(), eJBProblemContext.getComplilationInfo(), NbBundle.getMessage(LegalModifiers.class, (String)"MSG_BeanClassMustBePublic"), object);
                linkedList.add(errorDescription);
            }
            if (set.contains((Object)Modifier.FINAL)) {
                object = new RemoveModifier(eJBProblemContext.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)eJBProblemContext.getClazz()), Modifier.FINAL);
                errorDescription = HintsUtils.createProblem((Element)eJBProblemContext.getClazz(), eJBProblemContext.getComplilationInfo(), NbBundle.getMessage(LegalModifiers.class, (String)"MSG_BeanClassMustNotBeFinal"), object);
                linkedList.add(errorDescription);
            }
            if (set.contains((Object)Modifier.ABSTRACT)) {
                if (this.isInterface(eJBProblemContext)) {
                    object = HintsUtils.createProblem(eJBProblemContext.getClazz(), eJBProblemContext.getComplilationInfo(), NbBundle.getMessage(LegalModifiers.class, (String)"MSG_BeanClassMustNotBeAbstract"));
                    linkedList.add((ErrorDescription)object);
                } else {
                    object = new RemoveModifier(eJBProblemContext.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)eJBProblemContext.getClazz()), Modifier.ABSTRACT);
                    errorDescription = HintsUtils.createProblem((Element)eJBProblemContext.getClazz(), eJBProblemContext.getComplilationInfo(), NbBundle.getMessage(LegalModifiers.class, (String)"MSG_BeanClassMustNotBeAbstract"), object);
                    linkedList.add(errorDescription);
                }
            }
            return linkedList;
        }
        return null;
    }

    private boolean isInterface(EJBProblemContext eJBProblemContext) {
        ClassTree classTree = eJBProblemContext.getComplilationInfo().getTrees().getTree(eJBProblemContext.getClazz());
        return eJBProblemContext.getComplilationInfo().getTreeUtilities().isInterface(classTree);
    }
}

