/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class CamelCaseNames
extends RubyAstRule {
    public boolean appliesTo(RuleContext context) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        HashSet<NodeType> integers = new HashSet<NodeType>();
        integers.add(NodeType.LOCALASGNNODE);
        integers.add(NodeType.DEFNNODE);
        integers.add(NodeType.DEFSNODE);
        return integers;
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        org.jrubyparser.ast.Node node = context.node;
        ParserResult info = context.parserResult;
        String name = ((INameNode)node).getName();
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            String key = node.getNodeType() == NodeType.LOCALASGNNODE ? "InvalidLocalName" : "InvalidMethodName";
            String displayName = NbBundle.getMessage(CamelCaseNames.class, (String)key);
            OffsetRange range = AstUtilities.getNameRange((org.jrubyparser.ast.Node)node);
            if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) != OffsetRange.NONE) {
                ArrayList<RenameFix> fixList = new ArrayList<RenameFix>(2);
                org.jrubyparser.ast.Node root = AstUtilities.getRoot((Parser.Result)info);
                AstPath childPath = new AstPath(root, node);
                if (node.getNodeType() == NodeType.LOCALASGNNODE) {
                    fixList.add(new RenameFix(context, childPath, RubyUtils.camelToUnderlinedName((String)name)));
                }
                fixList.add(new RenameFix(context, childPath, null));
                Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixList, 1500);
                result.add(desc);
            }
            return;
        }
    }

    public String getId() {
        return "Camelcase_Names";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CamelCaseNames.class, (String)"CamelCaseNames");
    }

    public String getDescription() {
        return NbBundle.getMessage(CamelCaseNames.class, (String)"CamelCaseNamesDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static class RenameFix
    implements PreviewableFix,
    Runnable {
        private final RubyRuleContext context;
        private final AstPath path;
        private final String newName;

        RenameFix(RubyRuleContext context, AstPath path, String newName) {
            this.context = context;
            this.path = path;
            this.newName = newName;
        }

        public String getDescription() {
            if (this.newName != null) {
                return NbBundle.getMessage(CamelCaseNames.class, (String)"RenameTo", (Object)this.newName);
            }
            return NbBundle.getMessage(CamelCaseNames.class, (String)"RenameVar");
        }

        private Set<OffsetRange> getRanges() {
            org.jrubyparser.ast.Node node = this.path.leaf();
            assert (node.getNodeType() == NodeType.LOCALASGNNODE);
            String oldName = ((INameNode)node).getName();
            org.jrubyparser.ast.Node scope = AstUtilities.findLocalScope((org.jrubyparser.ast.Node)node, (AstPath)this.path);
            HashSet<OffsetRange> ranges = new HashSet<OffsetRange>();
            this.addLocalRegions(scope, oldName, ranges, false);
            return ranges;
        }

        private String getOldName() {
            org.jrubyparser.ast.Node node = this.path.leaf();
            assert (node.getNodeType() == NodeType.LOCALASGNNODE);
            String oldName = ((INameNode)node).getName();
            return oldName;
        }

        @CheckForNull
        private EditList getEditList(String name) {
            int oldLength = this.getOldName().length();
            Set<OffsetRange> ranges = this.getRanges();
            EditList edits = new EditList(this.context.doc);
            for (OffsetRange range : ranges) {
                edits.replace(range.getStart(), oldLength, name, false, 0);
                assert (range.getLength() == oldLength);
            }
            return edits;
        }

        public boolean canPreview() {
            return this.newName != null;
        }

        public EditList getEditList() throws Exception {
            return this.getEditList(this.newName != null ? this.newName : "new_name");
        }

        public void implement() throws Exception {
            if (this.newName != null) {
                EditList edits = this.getEditList(this.newName);
                edits.apply();
            } else if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            try {
                DataObject od = DataObject.find((FileObject)RubyUtils.getFileObject((Parser.Result)this.context.parserResult));
                EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
                Node n = od.getNodeDelegate();
                InstanceContent ic = new InstanceContent();
                ic.add((Object)ec);
                ic.add((Object)n);
                AbstractLookup actionContext = new AbstractLookup((AbstractLookup.Content)ic);
                Action a = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)actionContext);
                a.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
            }
            catch (DataObjectNotFoundException dnf) {
                Exceptions.printStackTrace((Throwable)dnf);
            }
        }

        private void addLocalRegions(org.jrubyparser.ast.Node node, String name, Set<OffsetRange> ranges, boolean isParameter) {
            OffsetRange range;
            if ((node.getNodeType() == NodeType.LOCALASGNNODE || node.getNodeType() == NodeType.LOCALVARNODE) && name.equals(((INameNode)node).getName())) {
                range = AstUtilities.getNameRange((org.jrubyparser.ast.Node)node);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)this.context.parserResult, (OffsetRange)range)) != OffsetRange.NONE) {
                    ranges.add(range);
                }
            } else if (isParameter && node.getNodeType() == NodeType.ARGUMENTNODE && name.equals(((INameNode)node).getName())) {
                range = AstUtilities.getNameRange((org.jrubyparser.ast.Node)node);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)this.context.parserResult, (OffsetRange)range)) != OffsetRange.NONE) {
                    ranges.add(range);
                }
            } else if (node.getNodeType() == NodeType.ARGSNODE) {
                isParameter = true;
            }
            List list = node.childNodes();
            for (org.jrubyparser.ast.Node child : list) {
                if (child.isInvisible() || child instanceof MethodDefNode) continue;
                this.addLocalRegions(child, name, ranges, isParameter);
            }
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }
}

