/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ExpandSameLineDef
extends RubyAstRule {
    public boolean appliesTo(RuleContext context) {
        ParserResult info = context.parserResult;
        return RubyUtils.getFileObject((Parser.Result)info).getMIMEType().equals("text/x-ruby");
    }

    @Override
    public Set<NodeType> getKinds() {
        HashSet<NodeType> types = new HashSet<NodeType>();
        types.add(NodeType.CLASSNODE);
        types.add(NodeType.DEFNNODE);
        types.add(NodeType.DEFSNODE);
        return types;
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        AstPath path = context.path;
        ParserResult info = context.parserResult;
        BaseDocument doc = context.doc;
        if (node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE || node.getNodeType() == NodeType.CLASSNODE) {
            SourcePosition pos = node.getPosition();
            try {
                if (doc == null) {
                    return;
                }
                int start = pos.getStartOffset();
                int end = pos.getEndOffset();
                int length = doc.getLength();
                if (Utilities.getRowEnd((BaseDocument)doc, (int)Math.min(start, length)) == Utilities.getRowEnd((BaseDocument)doc, (int)Math.min(end, length))) {
                    Node root = AstUtilities.getRoot((Parser.Result)info);
                    if (path.leaf() != node) {
                        path = new AstPath(root, node);
                    }
                    List<ExpandLineFix> fixList = Collections.singletonList(new ExpandLineFix(context, path));
                    OffsetRange range = new OffsetRange(pos.getStartOffset(), pos.getEndOffset());
                    Hint desc = new Hint((Rule)this, this.getDisplayName(), RubyUtils.getFileObject((Parser.Result)info), range, fixList, 150);
                    result.add(desc);
                    return;
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void cancel() {
    }

    public String getId() {
        return "Expand_Same_Line_Def";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ExpandSameLineDef.class, (String)"ExpandLine");
    }

    public String getDescription() {
        return NbBundle.getMessage(ExpandSameLineDef.class, (String)"ExpandLineDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    public boolean showInTasklist() {
        return false;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static class ExpandLineFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final AstPath path;

        ExpandLineFix(RubyRuleContext context, AstPath path) {
            this.context = context;
            this.path = path;
        }

        public String getDescription() {
            String code = this.path.leaf().getNodeType() == NodeType.DEFNNODE ? "def" : "class";
            return NbBundle.getMessage(ExpandSameLineDef.class, (String)"ExpandLineFix", (Object)code);
        }

        private void findLineBreaks(Node node, Set<Integer> offsets) {
            if (node.getNodeType() == NodeType.NEWLINENODE) {
                offsets.add(node.getPosition().getStartOffset());
            }
            List list = node.childNodes();
            for (Node child : list) {
                if (child.isInvisible()) continue;
                this.findLineBreaks(child, offsets);
            }
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            BaseDocument doc = this.context.doc;
            SourcePosition pos = this.path.leaf().getPosition();
            int startOffset = pos.getStartOffset();
            int endOffset = pos.getEndOffset();
            if (endOffset > doc.getLength()) {
                if (startOffset > doc.getLength()) {
                    startOffset = doc.getLength();
                }
                endOffset = doc.getLength();
            }
            HashSet<Integer> offsetSet = new HashSet<Integer>();
            this.findLineBreaks(this.path.leaf(), offsetSet);
            TokenSequence ts = LexUtilities.getRubyTokenSequence((BaseDocument)doc, (int)endOffset);
            if (ts != null) {
                ts.move(endOffset);
                while (ts.movePrevious() && ts.offset() > startOffset) {
                    Token token = ts.token();
                    TokenId id = token.id();
                    if (id == RubyTokenId.IDENTIFIER && ";".equals(((Object)token.text()).toString())) {
                        offsetSet.add(ts.offset());
                        continue;
                    }
                    if (id != RubyTokenId.CLASS && id != RubyTokenId.DEF && id != RubyTokenId.END) continue;
                    offsetSet.add(ts.offset());
                }
            }
            ArrayList<Integer> offsets = new ArrayList<Integer>(offsetSet);
            Collections.sort(offsets);
            Collections.reverse(offsets);
            EditList edits = new EditList(doc);
            if (offsets.size() > 0) {
                ArrayList<Integer> newlines = new ArrayList<Integer>();
                try {
                    int prev = -1;
                    Iterator i$ = offsets.iterator();
                    while (i$.hasNext()) {
                        int offset = (Integer)i$.next();
                        if (offset == prev) continue;
                        prev = offset;
                        if (";".equals(doc.getText(offset, 1))) {
                            edits.replace(offset, 1, null, false, 1);
                            if (newlines.contains(offset + 2)) continue;
                        }
                        if (newlines.contains(offset + 1) || newlines.contains(offset)) continue;
                        edits.replace(offset, 0, "\n", false, 2);
                        newlines.add(offset);
                    }
                    edits.setFormatAll(true);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
            return edits;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

