/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.ruby.ParseTreeVisitor;
import org.netbeans.modules.ruby.ParseTreeWalker;

class InputOutputVarFinder
implements ParseTreeVisitor {
    private static final int WHEN_BEFORE = 0;
    private static final int WHEN_DURING = 1;
    private static final int WHEN_AFTER = 2;
    private final Node startNode;
    private final Node endNode;
    private final List<Node> applicableBlocks;
    private int when = 0;
    private int ifs;
    private Node currentBlock;
    private final List<Node> blockStack = new ArrayList<Node>();
    private Map<Node, UsageScope> blockScopes = new HashMap<Node, UsageScope>();
    private UsageScope methodScope = new UsageScope(null);
    private UsageScope blockScope;

    InputOutputVarFinder(Node startNode, Node endNode, List<Node> applicableBlocks) {
        this.startNode = startNode;
        this.endNode = endNode;
        this.applicableBlocks = applicableBlocks;
    }

    public Set<String> getInputVars() {
        UsageScope scope = this.methodScope;
        for (UsageScope s : this.blockScopes.values()) {
            if (s.block != null && !this.applicableBlocks.contains(s.block)) continue;
            scope.merge(s);
        }
        HashSet<String> inputs = new HashSet<String>(scope.readDuring);
        inputs.removeAll(scope.writtenBeforeReadDuring);
        HashSet outputs = new HashSet(scope.writtenDuring);
        outputs.retainAll(scope.readAfter);
        HashSet extraOutputs = new HashSet(scope.writtenBefore);
        extraOutputs.retainAll(outputs);
        extraOutputs.removeAll(scope.writtenBeforeReadDuring);
        inputs.addAll(extraOutputs);
        return inputs;
    }

    public Set<String> getOutputVars() {
        UsageScope scope = this.methodScope;
        for (UsageScope s : this.blockScopes.values()) {
            if (s.block != null && !this.applicableBlocks.contains(s.block)) continue;
            scope.merge(s);
        }
        HashSet<String> outputs = new HashSet<String>(scope.writtenDuring);
        outputs.retainAll(scope.readAfter);
        return outputs;
    }

    public boolean visit(Node node) {
        if (node == this.startNode) {
            this.when = 1;
        }
        switch (node.getNodeType()) {
            case ARGSNODE: {
                String name;
                assert (this.when == 0);
                ArgsNode an = (ArgsNode)node;
                if (an.getRequiredCount() > 0) {
                    List args = an.childNodes();
                    for (Node arg : args) {
                        if (!(arg instanceof ListNode)) continue;
                        List args2 = arg.childNodes();
                        for (Node arg2 : args2) {
                            if (arg2.getNodeType() == NodeType.ARGUMENTNODE) {
                                this.methodScope.write(((INameNode)arg2).getName());
                                continue;
                            }
                            if (arg2.getNodeType() != NodeType.LOCALASGNNODE) continue;
                            this.methodScope.write(((INameNode)arg2).getName());
                        }
                    }
                }
                if (an.getRest() != null) {
                    name = an.getRest().getName();
                    this.methodScope.write(name);
                }
                if (an.getBlock() != null) {
                    name = an.getBlock().getName();
                    this.methodScope.write(name);
                }
                return true;
            }
            case ITERNODE: {
                this.blockStack.add(node);
                this.currentBlock = node;
                this.blockScope = new UsageScope(this.currentBlock);
                this.blockScopes.put(this.currentBlock, this.blockScope);
                if (this.when != 1) break;
                this.applicableBlocks.add(node);
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: 
            case CLASSNODE: 
            case SCLASSNODE: 
            case MODULENODE: {
                return this.when != 0;
            }
            case DVARNODE: {
                String name = ((INameNode)node).getName();
                this.blockScope.read(name);
                break;
            }
            case LOCALVARNODE: {
                String name = ((INameNode)node).getName();
                this.methodScope.read(name);
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode multiple = (MultipleAsgnNode)node;
                if (multiple.getValueNode() == null) break;
                new ParseTreeWalker((ParseTreeVisitor)this).walk(multiple.getValueNode());
                break;
            }
            case WHENNODE: 
            case IFNODE: {
                ++this.ifs;
            }
        }
        return false;
    }

    public boolean unvisit(Node node) {
        switch (node.getNodeType()) {
            case ITERNODE: {
                this.blockStack.remove(this.blockStack.size() - 1);
                Node node2 = this.currentBlock = this.blockStack.size() > 0 ? this.blockStack.get(this.blockStack.size() - 1) : null;
                if (this.currentBlock == null) break;
                this.blockScope = this.blockScopes.get(this.currentBlock);
                assert (this.blockScope != null);
                break;
            }
            case LOCALASGNNODE: {
                String name = ((INameNode)node).getName();
                this.methodScope.write(name);
                break;
            }
            case DASGNNODE: {
                String name = ((INameNode)node).getName();
                this.blockScope.write(name);
                break;
            }
            case WHENNODE: 
            case IFNODE: {
                --this.ifs;
            }
        }
        if (node == this.endNode) {
            this.when = 2;
        }
        return false;
    }

    private class UsageScope {
        private Node block;
        private final Set<String> writtenBefore = new HashSet<String>();
        private final Set<String> readDuring = new HashSet<String>();
        private final Set<String> writtenDuring = new HashSet<String>();
        private final Set<String> writtenBeforeReadDuring = new HashSet<String>();
        private final Set<String> writtenAfter = new HashSet<String>();
        private final Set<String> readAfter = new HashSet<String>();

        UsageScope(Node block) {
            this.block = block;
        }

        private void read(String name) {
            if (InputOutputVarFinder.this.when == 1) {
                if (!this.writtenBeforeReadDuring.contains(name)) {
                    this.readDuring.add(name);
                }
            } else if (InputOutputVarFinder.this.when == 2 && !this.writtenAfter.contains(name)) {
                this.readAfter.add(name);
            }
        }

        private void write(String name) {
            if (InputOutputVarFinder.this.when == 0) {
                this.writtenBefore.add(name);
            } else if (InputOutputVarFinder.this.when == 1) {
                this.writtenDuring.add(name);
                if (InputOutputVarFinder.this.ifs == 0 && !this.readDuring.contains(name)) {
                    this.writtenBeforeReadDuring.add(name);
                }
            } else if (InputOutputVarFinder.this.when == 2 && InputOutputVarFinder.this.ifs == 0 && !this.readAfter.contains(name)) {
                this.writtenAfter.add(name);
            }
        }

        private void merge(UsageScope other) {
            this.writtenBefore.addAll(other.writtenBefore);
            this.readDuring.addAll(other.readDuring);
            this.writtenDuring.addAll(other.writtenDuring);
            this.writtenBeforeReadDuring.addAll(other.writtenBeforeReadDuring);
            this.writtenAfter.addAll(other.writtenAfter);
            this.readAfter.addAll(other.readAfter);
        }
    }
}

