/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.notification;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.ui.notification.ProblemNotification;

public class ProblemNotificationController {
    private static final Logger LOG = Logger.getLogger(ProblemNotificationController.class.getName());
    private final HudsonInstanceImpl instance;
    private final Set<ProblemNotification> notifications = new HashSet<ProblemNotification>();

    public ProblemNotificationController(HudsonInstanceImpl instance) {
        this.instance = instance;
    }

    public synchronized void updateNotifications() {
        LOG.log(Level.FINE, "Updating notifications for {0}", this.instance);
        Preferences prefs = this.instance.prefs().node("notifications");
        for (HudsonJob job : this.instance.getJobs()) {
            ProblemNotification n;
            if (!job.isSalient()) {
                LOG.log(Level.FINER, "{0} is not being watched", job);
                continue;
            }
            int build = job.getLastCompletedBuild();
            if (prefs.getInt(job.getName(), 0) >= build) {
                LOG.log(Level.FINER, "{0} was already notified", job);
                continue;
            }
            HudsonJob.Color color = job.getColor();
            LOG.log(Level.FINER, "{0} has status {1}", new Object[]{job, color});
            switch (color) {
                case red: 
                case red_anime: {
                    n = new ProblemNotification(job, build, true);
                    break;
                }
                case yellow: 
                case yellow_anime: {
                    n = new ProblemNotification(job, build, false);
                    break;
                }
                case blue: 
                case blue_anime: {
                    this.removeFormerNotifications(job, null);
                    n = null;
                    break;
                }
                default: {
                    n = null;
                }
            }
            if (n == null || !this.notifications.add(n)) continue;
            prefs.putInt(job.getName(), build);
            n.add();
            this.removeFormerNotifications(job, n);
        }
    }

    private void removeFormerNotifications(HudsonJob job, ProblemNotification except) {
        Iterator<ProblemNotification> i = this.notifications.iterator();
        while (i.hasNext()) {
            ProblemNotification former = i.next();
            if (!former.job.getName().equals(job.getName()) || former.equals(except)) continue;
            former.remove();
            i.remove();
        }
    }
}

