/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;

public class ConversionUtils {
    private ConversionUtils() {
    }

    private static SessionId toSessionId(Session session) {
        return session != null ? (SessionId)session.lookupFirst(null, SessionId.class) : null;
    }

    private static SessionId toSessionId(DebuggerEngine debuggerEngine) {
        return debuggerEngine != null ? (SessionId)debuggerEngine.lookupFirst(null, SessionId.class) : null;
    }

    private static DebugSession toDebugSession(DebuggerEngine debuggerEngine) {
        return debuggerEngine != null ? (DebugSession)debuggerEngine.lookupFirst(null, DebugSession.class) : null;
    }

    public static DebugSession toDebugSession(SessionId id) {
        DebuggerEngine[] engines;
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        DebugSession currentSession = ConversionUtils.toDebugSession(currentEngine);
        if (currentSession != null && id.equals(currentSession.getSessionId())) {
            return currentSession;
        }
        for (DebuggerEngine debuggerEngine : engines = DebuggerManager.getDebuggerManager().getDebuggerEngines()) {
            DebugSession debugSession = ConversionUtils.toDebugSession(debuggerEngine);
            if (debugSession == null || !id.equals(debugSession.getSessionId())) continue;
            return debugSession;
        }
        return null;
    }

    public static DebugSession toDebugSession(Session session) {
        return ConversionUtils.toDebugSession(session.getCurrentEngine());
    }

    private static Session toSession(DebuggerEngine debuggerEngine) {
        SessionId id = ConversionUtils.toSessionId(debuggerEngine);
        return ConversionUtils.toSession(id);
    }

    public static Session toSession(DebugSession debugSession) {
        return ConversionUtils.toSession(debugSession.getSessionId());
    }

    public static Session toSession(SessionId sessionId) {
        Session[] sessions;
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        DebugSession currentDebugSession = ConversionUtils.toDebugSession(currentSession);
        if (currentDebugSession != null && sessionId.equals(currentDebugSession.getSessionId())) {
            return currentSession;
        }
        for (Session session : sessions = DebuggerManager.getDebuggerManager().getSessions()) {
            DebugSession debugSession = ConversionUtils.toDebugSession(session);
            if (debugSession == null || !sessionId.equals(debugSession.getSessionId())) continue;
            return session;
        }
        return null;
    }
}

