/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.dd.common.Properties;
import org.netbeans.modules.j2ee.persistence.dd.common.Property;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.unit.AddEntityDialog;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceValidator;
import org.netbeans.modules.j2ee.persistence.util.PersistenceProviderComboboxHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.JdbcListCellRenderer;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PersistenceUnitPanel
extends SectionInnerPanel {
    private final org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit;
    private PUDataObject dObj;
    private Project project;
    private boolean isContainerManaged;
    private boolean jpa20 = false;
    private final String[] validationModes = new String[]{"AUTO", "CALLBACK", "NONE"};
    private final String[] cachingTypes = new String[]{"ALL", "NONE", "ENABLE_SELECTIVE", "DISABLE_SELECTIVE", "UNSPECIFIED"};
    private JButton addClassButton;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JLabel cachingStrategyLabel;
    private JPanel cachingStrategyPanel;
    private JLabel datasourceLabel;
    private JRadioButton ddAll;
    private JRadioButton ddAuto;
    private JRadioButton ddCallBack;
    private JRadioButton ddCreate;
    private JRadioButton ddDefault;
    private JRadioButton ddDisableSelective;
    private JRadioButton ddDropCreate;
    private JRadioButton ddEnableSelective;
    private JRadioButton ddNoValidation;
    private JRadioButton ddNone;
    private JRadioButton ddUnknown;
    private JComboBox dsCombo;
    private JPanel entityClassesPanel;
    private JList entityList;
    private JScrollPane entityScrollPane;
    private JCheckBox includeAllEntities;
    private JLabel includeEntitiesLabel;
    private JComboBox jdbcComboBox;
    private JLabel jdbcLabel;
    private JCheckBox jtaCheckBox;
    private JComboBox libraryComboBox;
    private JLabel libraryLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JComboBox providerCombo;
    private JLabel providerLabel;
    private JButton removeClassButton;
    private JLabel tableGenerationLabel;
    private JPanel tableGenerationPanel;
    private JLabel validationStrategyLabel;
    private JPanel validationStrategyPanel;

    public PersistenceUnitPanel(SectionView sectionView, PUDataObject pUDataObject, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        super(sectionView);
        this.dObj = pUDataObject;
        this.jpa20 = "2.0".equals(pUDataObject.getPersistence().getVersion());
        this.persistenceUnit = persistenceUnit;
        this.project = FileOwnerQuery.getOwner((FileObject)this.dObj.getPrimaryFile());
        assert (this.project != null) : "Could not resolve project for " + pUDataObject.getPrimaryFile();
        this.isContainerManaged = PersistenceLibrarySupport.getLibrary(persistenceUnit) != null && ProviderUtil.getConnection(persistenceUnit) != null ? false : (persistenceUnit.getJtaDataSource() != null || persistenceUnit.getNonJtaDataSource() != null ? true : Util.isSupportedJavaEEVersion(this.project));
        this.initComponents();
        PersistenceProviderComboboxHelper persistenceProviderComboboxHelper = new PersistenceProviderComboboxHelper(this.project);
        if (this.isContainerManaged) {
            persistenceProviderComboboxHelper.connect(this.providerCombo);
            ArrayList<Provider> arrayList = new ArrayList<Provider>();
            for (int i = 0; i < this.providerCombo.getItemCount(); ++i) {
                Object e = this.providerCombo.getItemAt(i);
                if (!(e instanceof Provider)) continue;
                arrayList.add((Provider)e);
            }
            Provider provider = ProviderUtil.getProvider(persistenceUnit, arrayList.toArray(new Provider[0]));
            this.providerCombo.setSelectedItem(provider);
        } else {
            persistenceProviderComboboxHelper.connect(this.libraryComboBox);
            this.setSelectedLibrary();
        }
        this.setVisiblePanel();
        this.initIncludeAllEntities();
        this.initEntityList();
        this.initDataSource();
        if (this.jpa20) {
            this.initCache();
            this.initValidation();
        }
        this.nameTextField.setText(persistenceUnit.getName());
        this.setTableGeneration();
        this.handleCmAmSelection();
        this.registerModifiers();
    }

    private void registerModifiers() {
        if (this.isContainerManaged) {
            this.addImmediateModifier(this.dsCombo);
            if (this.dsCombo.isEditable()) {
                this.addImmediateModifier((JTextComponent)this.dsCombo.getEditor().getEditorComponent());
            }
            this.addImmediateModifier(this.providerCombo);
            this.addImmediateModifier(this.jtaCheckBox);
        } else {
            this.addImmediateModifier(this.jdbcComboBox);
            this.addImmediateModifier(this.libraryComboBox);
        }
        this.addImmediateModifier(this.nameTextField);
        this.addImmediateModifier(this.ddDropCreate);
        this.addImmediateModifier(this.ddCreate);
        this.addImmediateModifier(this.ddUnknown);
        this.addImmediateModifier(this.includeAllEntities);
        if (this.jpa20) {
            this.addImmediateModifier(this.ddAll);
            this.addImmediateModifier(this.ddNone);
            this.addImmediateModifier(this.ddEnableSelective);
            this.addImmediateModifier(this.ddDisableSelective);
            this.addImmediateModifier(this.ddDefault);
            this.addImmediateModifier(this.ddAuto);
            this.addImmediateModifier(this.ddNoValidation);
            this.addImmediateModifier(this.ddCallBack);
        }
    }

    private void setVisiblePanel() {
        this.providerLabel.setVisible(this.isContainerManaged);
        this.providerCombo.setVisible(this.isContainerManaged);
        this.dsCombo.setVisible(this.isContainerManaged);
        this.datasourceLabel.setVisible(this.isContainerManaged);
        this.libraryLabel.setVisible(!this.isContainerManaged);
        this.libraryComboBox.setVisible(!this.isContainerManaged);
        this.jdbcComboBox.setVisible(!this.isContainerManaged);
        this.jdbcLabel.setVisible(!this.isContainerManaged);
        this.validationStrategyPanel.setVisible(this.jpa20);
        this.validationStrategyLabel.setVisible(this.jpa20);
        this.cachingStrategyPanel.setVisible(this.jpa20);
        this.cachingStrategyLabel.setVisible(this.jpa20);
    }

    private void initCache() {
        PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
        String string = persistenceUnit.getSharedCacheMode();
        if (this.cachingTypes[0].equals(string)) {
            this.ddAll.setSelected(true);
        } else if (this.cachingTypes[1].equals(string)) {
            this.ddNone.setSelected(true);
        } else if (this.cachingTypes[2].equals(string)) {
            this.ddEnableSelective.setSelected(true);
        } else if (this.cachingTypes[3].equals(string)) {
            this.ddDisableSelective.setSelected(true);
        } else {
            this.ddDefault.setSelected(true);
        }
    }

    private void initValidation() {
        PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
        String string = persistenceUnit.getValidationMode();
        if (this.validationModes[1].equals(string)) {
            this.ddCallBack.setSelected(true);
        } else if (this.validationModes[2].equals(string)) {
            this.ddNoValidation.setSelected(true);
        } else {
            this.ddAuto.setSelected(true);
        }
    }

    private void initDataSource() {
        this.jtaCheckBox.setEnabled(this.isContainerManaged);
        if (this.isContainerManaged && ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            String string = this.persistenceUnit.getJtaDataSource();
            String string2 = this.persistenceUnit.getNonJtaDataSource();
            JPADataSourcePopulator jPADataSourcePopulator = (JPADataSourcePopulator)this.project.getLookup().lookup(JPADataSourcePopulator.class);
            if (jPADataSourcePopulator != null) {
                jPADataSourcePopulator.connect(this.dsCombo);
                this.addModifier((JTextComponent)this.dsCombo.getEditor().getEditorComponent(), false);
            }
            String string3 = string != null ? string : string2;
            this.selectDatasource(string3);
            this.jtaCheckBox.setSelected(string != null);
            ArrayList<Provider> arrayList = new ArrayList<Provider>();
            for (int i = 0; i < this.providerCombo.getItemCount(); ++i) {
                Object e = this.providerCombo.getItemAt(i);
                if (!(e instanceof Provider)) continue;
                arrayList.add((Provider)e);
            }
            Provider provider = ProviderUtil.getProvider(this.persistenceUnit, arrayList.toArray(new Provider[0]));
            this.providerCombo.setSelectedItem(provider);
        } else if (!this.isContainerManaged) {
            this.initJdbcComboBox();
            this.setSelectedLibrary();
            this.jtaCheckBox.setSelected(false);
        }
    }

    private void initJdbcComboBox() {
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            this.jdbcComboBox.addItem(databaseConnectionArray[i]);
        }
        this.setSelectedConnection();
    }

    private void initIncludeAllEntities() {
        boolean bl = Util.isJavaSE(this.project);
        this.includeAllEntities.setEnabled(!bl);
        this.includeAllEntities.setSelected(!bl && !this.persistenceUnit.isExcludeUnlistedClasses());
        this.includeAllEntities.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_IncludeAllEntities", (Object[])new Object[]{ProjectUtils.getInformation((Project)this.project).getDisplayName()}));
    }

    void initEntityList() {
        this.initEntityListControls();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : this.persistenceUnit.getClass2()) {
            defaultListModel.addElement(string);
        }
        this.entityList.setModel(defaultListModel);
    }

    private void initEntityListControls() {
        boolean bl = !this.includeAllEntities.isSelected();
        this.entityList.setEnabled(bl);
        this.addClassButton.setEnabled(bl);
        this.removeClassButton.setEnabled(bl);
    }

    private void setSelectedLibrary() {
        ArrayList<Provider> arrayList = new ArrayList<Provider>();
        for (int i = 0; i < this.libraryComboBox.getItemCount(); ++i) {
            Object e = this.libraryComboBox.getItemAt(i);
            if (!(e instanceof Provider)) continue;
            arrayList.add((Provider)e);
        }
        Provider provider = ProviderUtil.getProvider(this.persistenceUnit, arrayList.toArray(new Provider[0]));
        if (provider == null) {
            return;
        }
        for (int i = 0; i < this.libraryComboBox.getItemCount(); ++i) {
            Object e = this.libraryComboBox.getItemAt(i);
            Provider provider2 = (Provider)(e instanceof Provider ? e : null);
            if (provider2 == null || !provider2.equals(provider)) continue;
            this.libraryComboBox.setSelectedIndex(i);
            break;
        }
    }

    private Provider getSelectedProvider() {
        if (this.isContainerManaged) {
            return (Provider)this.providerCombo.getSelectedItem();
        }
        Object object = this.libraryComboBox.getSelectedItem();
        Provider provider = (Provider)(object instanceof Provider ? object : null);
        if (provider != null) {
            return provider;
        }
        return ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project);
    }

    private void setTableGeneration() {
        Property property;
        Provider provider = this.getSelectedProvider();
        Property property2 = property = provider == null ? null : ProviderUtil.getProperty(this.persistenceUnit, provider.getTableGenerationPropertyName());
        if (property != null) {
            if (provider.getTableGenerationCreateValue().equals(property.getValue())) {
                this.ddCreate.setSelected(true);
            } else if (provider.getTableGenerationDropCreateValue().equals(property.getValue())) {
                this.ddDropCreate.setSelected(true);
            }
        } else {
            this.ddUnknown.setSelected(true);
        }
        boolean bl = provider == null ? false : provider.supportsTableGeneration();
        this.ddCreate.setEnabled(bl);
        this.ddDropCreate.setEnabled(bl);
        this.ddUnknown.setEnabled(bl);
    }

    private void setSelectedConnection() {
        DatabaseConnection databaseConnection = ProviderUtil.getConnection(this.persistenceUnit);
        if (databaseConnection != null) {
            this.jdbcComboBox.setSelectedItem(databaseConnection);
        } else {
            Properties properties = this.persistenceUnit.getProperties();
            if (properties != null) {
                Property[] propertyArray = properties.getProperty2();
                String string = null;
                ArrayList<Provider> arrayList = new ArrayList<Provider>();
                JComboBox jComboBox = this.providerCombo.isVisible() ? this.providerCombo : this.libraryComboBox;
                for (int i = 0; i < jComboBox.getItemCount(); ++i) {
                    Object e = jComboBox.getItemAt(i);
                    if (!(e instanceof Provider)) continue;
                    arrayList.add((Provider)e);
                }
                Provider provider = ProviderUtil.getProvider(this.persistenceUnit, arrayList.toArray(new Provider[0]));
                for (int i = 0; i < propertyArray.length; ++i) {
                    String string2 = propertyArray[i].getName();
                    if (!provider.getJdbcUrl().equals(string2)) continue;
                    string = propertyArray[i].getValue();
                    break;
                }
                if (string == null) {
                    string = NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_CustomConnection");
                }
                this.jdbcComboBox.addItem(string);
                this.jdbcComboBox.setSelectedItem(string);
            }
        }
    }

    public void setValue(JComponent jComponent, Object object) {
        if (jComponent == this.nameTextField) {
            this.persistenceUnit.setName((String)object);
        } else if (jComponent == this.dsCombo) {
            this.setDataSource();
        } else if (jComponent == this.dsCombo.getEditor().getEditorComponent()) {
            this.setDataSource((String)object);
        } else if (jComponent == this.jdbcComboBox) {
            if (object instanceof DatabaseConnection) {
                ProviderUtil.setDatabaseConnection(this.persistenceUnit, (DatabaseConnection)object);
            }
        } else if (jComponent == this.libraryComboBox) {
            this.setProvider();
            this.setTableGeneration();
        } else if (this.providerCombo == jComponent) {
            String string = this.persistenceUnit.getProvider();
            this.setProvider();
            this.setDataSource();
            String string2 = this.persistenceUnit.getProvider();
            if (string != null && string2 != null) {
                ProviderUtil.migrateProperties(string, string2, this.persistenceUnit);
            }
        } else if (jComponent == this.ddCreate || jComponent == this.ddDropCreate || jComponent == this.ddUnknown) {
            ProviderUtil.setTableGeneration(this.persistenceUnit, this.getTableGeneration(), ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project));
        } else if (jComponent == this.includeAllEntities) {
            this.persistenceUnit.setExcludeUnlistedClasses(!this.includeAllEntities.isSelected());
        } else if (jComponent == this.jtaCheckBox) {
            this.setDataSource();
        } else if (this.jpa20) {
            if (jComponent == this.ddAll) {
                PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
                persistenceUnit.setSharedCacheMode(this.cachingTypes[0]);
            } else if (jComponent == this.ddNone) {
                PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
                persistenceUnit.setSharedCacheMode(this.cachingTypes[1]);
            } else if (jComponent == this.ddEnableSelective) {
                PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
                persistenceUnit.setSharedCacheMode(this.cachingTypes[2]);
            } else if (jComponent == this.ddDisableSelective) {
                PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
                persistenceUnit.setSharedCacheMode(this.cachingTypes[3]);
            } else if (jComponent == this.ddDefault) {
                PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
                persistenceUnit.setSharedCacheMode(null);
            } else if (jComponent == this.ddAuto) {
                PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
                persistenceUnit.setValidationMode(null);
            } else if (jComponent == this.ddCallBack) {
                PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
                persistenceUnit.setValidationMode(this.validationModes[1]);
            } else if (jComponent == this.ddNoValidation) {
                PersistenceUnit persistenceUnit = (PersistenceUnit)this.persistenceUnit;
                persistenceUnit.setValidationMode(this.validationModes[2]);
            }
        }
        this.performValidation();
    }

    private void performValidation() {
        PersistenceValidator persistenceValidator = new PersistenceValidator(this.dObj);
        List<Error> list = persistenceValidator.validate();
        if (!list.isEmpty()) {
            this.getSectionView().getErrorPanel().setError(list.get(0));
        } else {
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    private void setDataSource() {
        this.setDataSource(null);
    }

    private void setProvider() {
        if (this.isContainerManaged && this.providerCombo.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.providerCombo.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                this.persistenceUnit.setProvider(provider.getProviderClass());
                this.setTableGeneration();
            }
            ProviderUtil.makePortableIfPossible(this.project, this.persistenceUnit);
        } else if (this.libraryComboBox.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.libraryComboBox.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                ProviderUtil.setProvider(this.persistenceUnit, provider, this.getSelectedConnection(), this.getTableGeneration());
            }
        }
    }

    private void setDataSource(String string) {
        String string2 = string;
        if (string2 == null) {
            JPADataSource jPADataSource;
            int n = this.dsCombo.getSelectedIndex();
            Object object = this.dsCombo.getSelectedItem();
            JPADataSourceProvider jPADataSourceProvider = (JPADataSourceProvider)this.project.getLookup().lookup(JPADataSourceProvider.class);
            JPADataSource jPADataSource2 = jPADataSource = jPADataSourceProvider != null ? jPADataSourceProvider.toJPADataSource(object) : null;
            if (jPADataSource != null) {
                string2 = jPADataSource.getJndiName();
            } else if (n == -1 && object != null) {
                string2 = object.toString();
            }
        }
        if (string2 == null) {
            return;
        }
        if (this.isJta()) {
            this.persistenceUnit.setJtaDataSource(string2);
            this.persistenceUnit.setNonJtaDataSource(null);
            this.persistenceUnit.setTransactionType("JTA");
        } else {
            this.persistenceUnit.setJtaDataSource(null);
            this.persistenceUnit.setNonJtaDataSource(string2);
            this.persistenceUnit.setTransactionType("RESOURCE_LOCAL");
        }
    }

    private boolean isJta() {
        return this.jtaCheckBox.isEnabled() && this.jtaCheckBox.isSelected();
    }

    private String getTableGeneration() {
        if (this.ddCreate.isSelected()) {
            return "tableGenerationCreate";
        }
        if (this.ddDropCreate.isSelected()) {
            return "tableGenerationDropCreate";
        }
        return "tableGenerationUnknown";
    }

    private DatabaseConnection getSelectedConnection() {
        DatabaseConnection databaseConnection = null;
        if (this.jdbcComboBox.getSelectedItem() instanceof DatabaseConnection) {
            databaseConnection = (DatabaseConnection)this.jdbcComboBox.getSelectedItem();
        }
        return databaseConnection;
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (this.nameTextField == jTextComponent) {
            this.nameTextField.setText(this.persistenceUnit.getName());
        } else if (this.dsCombo.getEditor().getEditorComponent() == jTextComponent) {
            String string = this.isJta() ? this.persistenceUnit.getJtaDataSource() : this.persistenceUnit.getNonJtaDataSource();
            this.selectDatasource(string);
        }
    }

    private void selectDatasource(String string) {
        Object object = this.findDatasource(string);
        this.dsCombo.setSelectedItem(object);
        if (this.dsCombo.getEditor() != null) {
            this.dsCombo.configureEditor(this.dsCombo.getEditor(), object);
        }
    }

    private Object findDatasource(String string) {
        if (string != null) {
            int n = this.dsCombo.getItemCount();
            for (int i = 0; i < n; ++i) {
                Object e = this.dsCombo.getItemAt(i);
                if (!(e instanceof JPADataSource) || !string.equals(((JPADataSource)e).getJndiName())) continue;
                return (JPADataSource)e;
            }
        }
        return string;
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        if ("name".equals(string)) {
            return this.nameTextField;
        }
        return null;
    }

    private void handleCmAmSelection() {
        boolean bl = this.isContainerManaged;
        this.datasourceLabel.setEnabled(bl);
        this.dsCombo.setEnabled(bl);
        this.jtaCheckBox.setEnabled(bl);
        this.libraryLabel.setEnabled(!bl);
        this.libraryComboBox.setEnabled(!bl);
        this.jdbcLabel.setEnabled(!bl);
        this.jdbcComboBox.setEnabled(!bl);
        this.setTableGeneration();
    }

    private void initComponents() {
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.nameLabel = new JLabel();
        this.libraryLabel = new JLabel();
        this.jdbcLabel = new JLabel();
        this.datasourceLabel = new JLabel();
        this.jtaCheckBox = new JCheckBox();
        this.dsCombo = new JComboBox();
        this.providerCombo = new JComboBox();
        this.providerLabel = new JLabel();
        this.libraryComboBox = new JComboBox();
        this.jdbcComboBox = new JComboBox();
        this.nameTextField = new JTextField();
        this.tableGenerationLabel = new JLabel();
        this.tableGenerationPanel = new JPanel();
        this.ddCreate = new JRadioButton();
        this.ddDropCreate = new JRadioButton();
        this.ddUnknown = new JRadioButton();
        this.includeAllEntities = new JCheckBox();
        this.entityClassesPanel = new JPanel();
        this.entityScrollPane = new JScrollPane();
        this.entityList = new JList();
        this.addClassButton = new JButton();
        this.removeClassButton = new JButton();
        this.includeEntitiesLabel = new JLabel();
        this.cachingStrategyLabel = new JLabel();
        this.cachingStrategyPanel = new JPanel();
        this.ddAll = new JRadioButton();
        this.ddNone = new JRadioButton();
        this.ddEnableSelective = new JRadioButton();
        this.ddDisableSelective = new JRadioButton();
        this.ddDefault = new JRadioButton();
        this.validationStrategyLabel = new JLabel();
        this.validationStrategyPanel = new JPanel();
        this.ddAuto = new JRadioButton();
        this.ddCallBack = new JRadioButton();
        this.ddNoValidation = new JRadioButton();
        this.setMinimumSize(new Dimension(400, 360));
        this.setPreferredSize(new Dimension(654, 471));
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_UnitName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.nameLabel, gridBagConstraints);
        this.libraryLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_PersistenceLibrary"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.libraryLabel, gridBagConstraints);
        this.jdbcLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JdbcConnection"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.jdbcLabel, gridBagConstraints);
        this.datasourceLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_DatasourceName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.datasourceLabel, gridBagConstraints);
        this.jtaCheckBox.setSelected(true);
        this.jtaCheckBox.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JTA"));
        this.jtaCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jtaCheckBox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.jtaCheckBox, gridBagConstraints);
        this.dsCombo.setEditable(true);
        this.dsCombo.setMinimumSize(new Dimension(23, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.dsCombo, gridBagConstraints);
        this.providerCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.providerCombo.setMinimumSize(new Dimension(23, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.providerCombo, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle");
        this.providerLabel.setText(resourceBundle.getString("LBL_Provider"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.providerLabel, gridBagConstraints);
        this.libraryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.libraryComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.libraryComboBox, gridBagConstraints);
        this.jdbcComboBox.setRenderer(new JdbcListCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.jdbcComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.nameTextField, gridBagConstraints);
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle");
        this.tableGenerationLabel.setText(resourceBundle2.getString("LBL_TableGeneration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.tableGenerationLabel, gridBagConstraints);
        this.tableGenerationPanel.setMinimumSize(new Dimension(100, 25));
        this.tableGenerationPanel.setOpaque(false);
        this.tableGenerationPanel.setLayout(new FlowLayout(0));
        this.buttonGroup2.add(this.ddCreate);
        this.ddCreate.setText(resourceBundle2.getString("LBL_Create"));
        this.ddCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddCreate.setOpaque(false);
        this.tableGenerationPanel.add(this.ddCreate);
        this.buttonGroup2.add(this.ddDropCreate);
        this.ddDropCreate.setText(resourceBundle2.getString("LBL_DropCreate"));
        this.ddDropCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddDropCreate.setOpaque(false);
        this.tableGenerationPanel.add(this.ddDropCreate);
        this.buttonGroup2.add(this.ddUnknown);
        this.ddUnknown.setText(resourceBundle2.getString("LBL_None"));
        this.ddUnknown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddUnknown.setOpaque(false);
        this.tableGenerationPanel.add(this.ddUnknown);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.tableGenerationPanel, gridBagConstraints);
        this.includeAllEntities.setText(resourceBundle2.getString("LBL_IncludeAllEntities"));
        this.includeAllEntities.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.includeAllEntities.setContentAreaFilled(false);
        this.includeAllEntities.setMinimumSize(new Dimension(100, 15));
        this.includeAllEntities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.includeAllEntitiesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.includeAllEntities, gridBagConstraints);
        this.entityClassesPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.entityClassesPanel.setOpaque(false);
        this.entityClassesPanel.setLayout(new GridBagLayout());
        this.entityScrollPane.setMinimumSize(new Dimension(50, 25));
        this.entityScrollPane.setViewportView(this.entityList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.entityClassesPanel.add((Component)this.entityScrollPane, gridBagConstraints);
        this.addClassButton.setText(resourceBundle2.getString("LBL_AddClasses"));
        this.addClassButton.setMargin(new Insets(0, 10, 0, 10));
        this.addClassButton.setMaximumSize(new Dimension(287, 29));
        this.addClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.addClassButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.entityClassesPanel.add((Component)this.addClassButton, gridBagConstraints);
        this.removeClassButton.setText(resourceBundle2.getString("LBL_RemoveClass"));
        this.removeClassButton.setMargin(new Insets(0, 10, 0, 10));
        this.removeClassButton.setMaximumSize(new Dimension(284, 29));
        this.removeClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceUnitPanel.this.removeClassButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.entityClassesPanel.add((Component)this.removeClassButton, gridBagConstraints);
        this.includeEntitiesLabel.setText(resourceBundle2.getString("LBL_IncludeEntityClasses"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.entityClassesPanel.add((Component)this.includeEntitiesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 11, 11);
        this.add(this.entityClassesPanel, gridBagConstraints);
        this.cachingStrategyLabel.setText(resourceBundle2.getString("LBL_CachingStrategy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.cachingStrategyLabel, gridBagConstraints);
        this.cachingStrategyPanel.setMinimumSize(new Dimension(100, 25));
        this.cachingStrategyPanel.setOpaque(false);
        this.cachingStrategyPanel.setLayout(new FlowLayout(0));
        this.buttonGroup1.add(this.ddAll);
        this.ddAll.setText(resourceBundle2.getString("LBL_All"));
        this.ddAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddAll.setOpaque(false);
        this.cachingStrategyPanel.add(this.ddAll);
        this.buttonGroup1.add(this.ddNone);
        this.ddNone.setText(resourceBundle2.getString("LBL_None"));
        this.ddNone.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddNone.setOpaque(false);
        this.cachingStrategyPanel.add(this.ddNone);
        this.buttonGroup1.add(this.ddEnableSelective);
        this.ddEnableSelective.setText(resourceBundle2.getString("LBL_EnableSelective"));
        this.ddEnableSelective.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddEnableSelective.setOpaque(false);
        this.cachingStrategyPanel.add(this.ddEnableSelective);
        this.buttonGroup1.add(this.ddDisableSelective);
        this.ddDisableSelective.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_DisableSelective"));
        this.ddDisableSelective.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddDisableSelective.setOpaque(false);
        this.cachingStrategyPanel.add(this.ddDisableSelective);
        this.buttonGroup1.add(this.ddDefault);
        this.ddDefault.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_Default"));
        this.ddDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddDefault.setOpaque(false);
        this.cachingStrategyPanel.add(this.ddDefault);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.cachingStrategyPanel, gridBagConstraints);
        this.validationStrategyLabel.setText(resourceBundle2.getString("LBL_ValidationStrategy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.validationStrategyLabel, gridBagConstraints);
        this.validationStrategyPanel.setMinimumSize(new Dimension(100, 25));
        this.validationStrategyPanel.setOpaque(false);
        this.validationStrategyPanel.setLayout(new FlowLayout(0));
        this.buttonGroup3.add(this.ddAuto);
        this.ddAuto.setSelected(true);
        this.ddAuto.setText(resourceBundle2.getString("LBL_Auto"));
        this.ddAuto.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddAuto.setOpaque(false);
        this.validationStrategyPanel.add(this.ddAuto);
        this.buttonGroup3.add(this.ddCallBack);
        this.ddCallBack.setText(resourceBundle2.getString("LBL_CallBack"));
        this.ddCallBack.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddCallBack.setOpaque(false);
        this.validationStrategyPanel.add(this.ddCallBack);
        this.buttonGroup3.add(this.ddNoValidation);
        this.ddNoValidation.setText(resourceBundle2.getString("LBL_None"));
        this.ddNoValidation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddNoValidation.setOpaque(false);
        this.validationStrategyPanel.add(this.ddNoValidation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add(this.validationStrategyPanel, gridBagConstraints);
    }

    private void removeClassButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        for (Object object : objectArray = this.entityList.getSelectedValues()) {
            this.dObj.removeClass(this.persistenceUnit, (String)object, true);
            ((DefaultListModel)this.entityList.getModel()).removeElement(object);
        }
    }

    private void addClassButtonActionPerformed(ActionEvent actionEvent) {
        EntityClassScope entityClassScope = EntityClassScope.getEntityClassScope((FileObject)this.dObj.getPrimaryFile());
        if (entityClassScope == null) {
            return;
        }
        String[] stringArray = this.persistenceUnit.getClass2();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        List<String> list = AddEntityDialog.open(entityClassScope, hashSet);
        for (String string : list) {
            if (!this.dObj.addClass(this.persistenceUnit, string, true)) continue;
            ((DefaultListModel)this.entityList.getModel()).addElement(string);
        }
    }

    private void libraryComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void includeAllEntitiesActionPerformed(ActionEvent actionEvent) {
        this.initEntityListControls();
    }
}

