/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.NewRubyProjectWizardIterator;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class PanelOptionsVisual
extends SettingsPanel
implements ActionListener,
PropertyChangeListener {
    private static boolean lastMainClassCheck = true;
    private final PanelConfigureProject panel;
    private boolean valid;
    private JCheckBox createMainCheckBox;
    private JTextField mainClassTextField;
    private JButton manageButton;
    private JComboBox platforms;
    private JLabel rubyPlatformLabel;

    PanelOptionsVisual(PanelConfigureProject panel, NewRubyProjectWizardIterator.Type type) {
        this.initComponents();
        Util.preselectWizardPlatform(this.platforms);
        this.panel = panel;
        this.fireChangeEvent();
        PlatformComponentFactory.addPlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                PanelOptionsVisual.this.fireChangeEvent();
            }
        });
        switch (type) {
            case APPLICATION: {
                this.createMainCheckBox.addActionListener(this);
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                break;
            }
            case EXISTING: {
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                break;
            }
            default: {
                throw new IllegalStateException("unknown type: " + (Object)((Object)type));
            }
        }
        this.mainClassTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanelOptionsVisual.this.mainClassChanged();
            }
        });
    }

    @Override
    public void removeNotify() {
        Util.storeWizardPlatform(this.platforms);
        super.removeNotify();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.createMainCheckBox) {
            lastMainClassCheck = this.createMainCheckBox.isSelected();
            this.mainClassTextField.setEnabled(lastMainClassCheck);
            this.fireChangeEvent();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("roots".equals(event.getPropertyName())) {
            this.fireChangeEvent();
        }
        if ("projectName".equals(event.getPropertyName())) {
            String newProjectName = NewRubyProjectWizardIterator.getPackageName((String)event.getNewValue());
            if (!Utilities.isJavaIdentifier((String)newProjectName)) {
                newProjectName = NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNameSuffix", (Object)newProjectName);
            }
            this.mainClassTextField.setText(MessageFormat.format(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_ClassName"), newProjectName));
        }
    }

    private void fireChangeEvent() {
        this.panel.fireChangeEvent();
    }

    private void initComponents() {
        this.createMainCheckBox = new JCheckBox();
        this.mainClassTextField = new JTextField();
        this.rubyPlatformLabel = new JLabel();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.manageButton = new JButton();
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_createMainCheckBox"));
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"RubyPlatformLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"RubyHomeBrowse"));
        this.manageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.manageButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.createMainCheckBox).add((Component)this.rubyPlatformLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.platforms, 0, 319, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.manageButton)).add((Component)this.mainClassTextField, -1, 416, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createMainCheckBox).add((Component)this.mainClassTextField, -2, 21, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rubyPlatformLabel).add((Component)this.manageButton).add((Component)this.platforms, -2, -1, -2))));
        this.createMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_createMainCheckBox"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_createMainCheckBox"));
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        this.rubyPlatformLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"PanelOptionsVisual.rubyPlatformLabel.AccessibleContext.accessibleDescription"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"PanelOptionsVisual.manageButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void manageButtonActionPerformed(ActionEvent evt) {
        RubyPlatformCustomizer.manage((JComboBox)this.platforms);
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        if (PlatformComponentFactory.getPlatform((JComboBox)this.platforms) == null) {
            return false;
        }
        if (this.mainClassTextField.isVisible() && this.mainClassTextField.isEnabled()) {
            if (!this.valid) {
                settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalMainClassName"));
            }
            return this.valid;
        }
        return true;
    }

    @Override
    void read(WizardDescriptor d) {
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    void store(WizardDescriptor d) {
        d.putProperty("setAsMain", (Object)Boolean.FALSE);
        d.putProperty("mainClass", this.createMainCheckBox.isSelected() && this.createMainCheckBox.isVisible() ? this.mainClassTextField.getText() : null);
        d.putProperty("platform", (Object)PlatformComponentFactory.getPlatform((JComboBox)this.platforms));
    }

    private void mainClassChanged() {
        String mainClassName = this.mainClassTextField.getText();
        StringTokenizer tk = new StringTokenizer(mainClassName, ".");
        this.valid = true;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() != 0 && !token.equals(" ")) continue;
            this.valid = false;
            break;
        }
        this.fireChangeEvent();
    }
}

