/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.SpringConfigModelAccessor;
import org.netbeans.modules.spring.beans.model.ConfigModelSpringBeans;
import org.netbeans.modules.spring.beans.model.ExclusiveAccess;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelController;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelManager;

public class SpringConfigModelController {
    private final ConfigFileGroup configFileGroup;
    private final Map<File, SpringConfigFileModelController> file2Controller = new HashMap<File, SpringConfigFileModelController>();
    private ConfigModelSpringBeans readAccess;
    private boolean writeAccess;

    public SpringConfigModelController(SpringConfigFileModelManager fileModelManager, ConfigFileGroup configFileGroup) {
        this.configFileGroup = configFileGroup;
        for (File file : configFileGroup.getFiles()) {
            SpringConfigFileModelController controller = fileModelManager.getFileModelController(file);
            if (controller == null) continue;
            this.file2Controller.put(file, controller);
        }
    }

    public ConfigFileGroup getConfigFileGroup() {
        return this.configFileGroup;
    }

    public void runReadAction(final Action<SpringBeans> action) throws IOException {
        try {
            ExclusiveAccess.getInstance().runSyncTask(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    SpringConfigModelController.this.runReadActionExclusively(action);
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException ioe = new IOException(e.getMessage());
            throw (IOException)ioe.initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReadActionExclusively(Action<SpringBeans> action) throws IOException {
        if (this.writeAccess) {
            throw new IllegalStateException("Already in write access.");
        }
        boolean firstEntry = this.readAccess == null;
        try {
            if (firstEntry) {
                this.readAccess = new ConfigModelSpringBeans(this.computeSpringBeanSources(null));
            }
            action.run(this.readAccess);
        }
        finally {
            if (firstEntry) {
                this.readAccess = null;
            }
        }
    }

    public void runDocumentAction(final Action<SpringConfigModel.DocumentAccess> action) throws IOException {
        try {
            ExclusiveAccess.getInstance().runSyncTask(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    SpringConfigModelController.this.runDocumentActionExclusively(action);
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException ioe = new IOException(e.getMessage());
            throw (IOException)ioe.initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDocumentActionExclusively(Action<SpringConfigModel.DocumentAccess> action) throws IOException {
        if (this.readAccess != null) {
            throw new IllegalStateException("Already in read access.");
        }
        if (this.writeAccess) {
            throw new IllegalStateException("Reentrant write access not supported");
        }
        this.writeAccess = true;
        try {
            for (File currentFile : this.file2Controller.keySet()) {
                Map<File, SpringBeanSource> beanSources = this.computeSpringBeanSources(currentFile);
                SpringConfigFileModelController controller = this.file2Controller.get(currentFile);
                SpringConfigFileModelController.LockedDocument lockedDoc = controller.getLockedDocument();
                if (lockedDoc == null) continue;
                lockedDoc.lock();
                try {
                    beanSources.put(currentFile, lockedDoc.getBeanSource());
                    ConfigModelSpringBeans springBeans = new ConfigModelSpringBeans(beanSources);
                    SpringConfigModel.DocumentAccess docAccess = SpringConfigModelAccessor.getDefault().createDocumentAccess(springBeans, currentFile, lockedDoc);
                    action.run(docAccess);
                }
                finally {
                    lockedDoc.unlock();
                }
            }
        }
        finally {
            this.writeAccess = false;
        }
    }

    private Map<File, SpringBeanSource> computeSpringBeanSources(File skip) throws IOException {
        HashMap<File, SpringBeanSource> result = new HashMap<File, SpringBeanSource>();
        for (Map.Entry<File, SpringConfigFileModelController> entry : this.file2Controller.entrySet()) {
            File currentFile = entry.getKey();
            if (currentFile.equals(skip)) continue;
            result.put(entry.getKey(), entry.getValue().getUpToDateBeanSource());
        }
        return result;
    }
}

