/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.spring;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileLocationProvider;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbCollections;

public class MavenSpringConfigProviderImpl
implements SpringConfigFileLocationProvider,
SpringConfigFileProvider {
    private Project prj;

    public MavenSpringConfigProviderImpl(Project project) {
        this.prj = project;
    }

    public FileObject getLocation() {
        URI[] uRIArray;
        NbMavenProject nbMavenProject = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
        if ("war".equals(nbMavenProject.getPackagingType()) && (uRIArray = FileUtilities.convertURItoFileObject((URI)nbMavenProject.getWebAppDirectory())) != null) {
            return uRIArray;
        }
        for (URI uRI : uRIArray = nbMavenProject.getResources(false)) {
            FileObject fileObject = FileUtilities.convertURItoFileObject((URI)uRI);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    public Set<File> getConfigFiles() {
        URI[] uRIArray;
        HashSet<File> hashSet = new HashSet<File>();
        NbMavenProject nbMavenProject = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
        if ("war".equals(nbMavenProject.getPackagingType()) && (uRIArray = FileUtilities.convertURItoFileObject((URI)nbMavenProject.getWebAppDirectory())) != null) {
            MavenSpringConfigProviderImpl.addFilesInRoot((FileObject)uRIArray, hashSet);
        }
        for (URI uRI : uRIArray = nbMavenProject.getResources(false)) {
            FileObject fileObject = FileUtilities.convertURItoFileObject((URI)uRI);
            if (fileObject == null) continue;
            MavenSpringConfigProviderImpl.addFilesInRoot(fileObject, hashSet);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static void addFilesInRoot(FileObject fileObject, Set<File> set) {
        for (FileObject fileObject2 : NbCollections.iterable((Enumeration)fileObject.getChildren(true))) {
            File file;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!"text/x-springconfig+xml".equals(fileObject2.getMIMEType()) || (file = FileUtil.toFile((FileObject)fileObject2)) == null) continue;
            set.add(file);
        }
    }
}

