/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.patterns;

import java.util.HashMap;
import java.util.LinkedHashSet;
import org.codeviation.commons.patterns.Cache;
import org.codeviation.commons.patterns.Factory;

public class Caches {
    public static final Factory<Statistics, Cache> STATISTICS_FACTORY = new StatsFactory();

    public static <T, P> Cache<T, P> permanent(Factory<T, P> producer) {
        return new PermanentCache<T, P>(producer);
    }

    private static class LruCache<T, P>
    implements Cache<T, P>,
    StatsProvider {
        private Factory<T, P> producer;
        private int maxCount;
        private HashMap<P, T> cache;
        private LinkedHashSet<P> usages;
        private Statistics stats;

        public LruCache(Factory<T, P> producer, int maxCount) {
            this.producer = producer;
            this.maxCount = maxCount;
            this.clear();
        }

        @Override
        public T create(P param) {
            ++this.stats.queries;
            T r = this.cache.get(param);
            if (r == null) {
                r = this.producer.create(param);
                this.cache.put(param, r);
                ++this.stats.misses;
            }
            return r;
        }

        @Override
        public void clear() {
            this.stats = new Statistics();
        }

        @Override
        public Statistics getStats() {
            return this.stats;
        }
    }

    private static class PermanentCache<T, P>
    implements Cache<T, P>,
    StatsProvider {
        private Factory<T, P> producer;
        private HashMap<P, T> cache;
        private Statistics stats;

        public PermanentCache(Factory<T, P> producer) {
            this.producer = producer;
            this.clear();
        }

        @Override
        public synchronized T create(P param) {
            ++this.stats.queries;
            T r = this.cache.get(param);
            if (r == null) {
                r = this.producer.create(param);
                this.cache.put(param, r);
                ++this.stats.misses;
            }
            return r;
        }

        @Override
        public synchronized void clear() {
            this.stats = new Statistics();
            this.cache = new HashMap();
        }

        @Override
        public Statistics getStats() {
            return this.stats;
        }
    }

    private static interface StatsProvider {
        public Statistics getStats();
    }

    private static class StatsFactory
    implements Factory<Statistics, Cache> {
        private StatsFactory() {
        }

        @Override
        public Statistics create(Cache cache) {
            if (!(cache instanceof StatsProvider)) {
                throw new IllegalArgumentException("Unknown cache " + cache);
            }
            return Statistics.create(((StatsProvider)((Object)cache)).getStats());
        }
    }

    public static final class Statistics {
        public long queries;
        public long misses;

        private static Statistics create(Statistics stats) {
            Statistics s = new Statistics();
            s.queries = stats.queries;
            s.misses = stats.misses;
            return s;
        }
    }
}

