/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class Statistics {
    public static double average(Collection<? extends Number> values) {
        return Statistics.average(values, false);
    }

    public static double average(Collection<? extends Number> values, boolean includeNullAndNaN) {
        if (values == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        int count = 0;
        double total = 0.0;
        for (Number number : values) {
            if (number == null) {
                if (!includeNullAndNaN) continue;
                return Double.NaN;
            }
            double value = number.doubleValue();
            if (Double.isNaN(value)) {
                if (!includeNullAndNaN) continue;
                return Double.NaN;
            }
            total += number.doubleValue();
            ++count;
        }
        return total / (double)count;
    }

    public static double median(Collection<? extends Number> values) {
        double result = Double.NaN;
        if (values != null) {
            int itemCount = values.size();
            ArrayList<Double> copy = new ArrayList<Double>(itemCount);
            for (Number number : values) {
                copy.add(number.doubleValue());
            }
            Collections.sort(copy);
            int count = copy.size();
            if (count > 0) {
                if (count % 2 == 1) {
                    if (count > 1) {
                        Number number = (Number)copy.get((count - 1) / 2);
                        result = number.doubleValue();
                    } else {
                        Number number = (Number)copy.get(0);
                        result = number.doubleValue();
                    }
                } else {
                    Number number = (Number)copy.get(count / 2 - 1);
                    Number value2 = (Number)copy.get(count / 2);
                    result = (number.doubleValue() + value2.doubleValue()) / 2.0;
                }
            }
        }
        return result;
    }

    public static double stdDev(Collection<? extends Number> data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' array.");
        }
        if (data.size() == 0) {
            throw new IllegalArgumentException("Zero length 'data' array.");
        }
        double avg = Statistics.average(data);
        double sum = 0.0;
        for (Number number : data) {
            double diff = number.doubleValue() - avg;
            sum += diff * diff;
        }
        return Math.sqrt(sum / (double)(data.size() - 1));
    }
}

