/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.codeviation.commons.reflect.ClassUtils;

class JsonUtils {
    private JsonUtils() {
    }

    public static String toJsonString(Object object) {
        if (object == null || object instanceof Void) {
            return "null";
        }
        if (object instanceof Enum) {
            return JsonUtils.quote(object.toString());
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Character) {
            return JsonUtils.quote(object.toString());
        }
        if (object instanceof String) {
            return JsonUtils.quote((String)object);
        }
        if (object instanceof Date) {
            return JsonUtils.numberToString(((Date)object).getTime());
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
            return JsonUtils.numberToString(object);
        }
        throw new IllegalArgumentException("Cant store object " + object + " in field ");
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String numberToString(Object n) {
        if (n == null) {
            throw new IllegalArgumentException("Number must not be null");
        }
        JsonUtils.testValidity(n);
        return JsonUtils.trimNumber(n.toString());
    }

    public static String trimNumber(String s) {
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    static void testValidity(Object o) {
        if (o != null) {
            if (o instanceof Double) {
                if (((Double)o).isInfinite() || ((Double)o).isNaN()) {
                    throw new IllegalArgumentException("JSON does not allow non-finite numbers");
                }
            } else if (o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN())) {
                throw new IllegalArgumentException("JSON does not allow non-finite numbers.");
            }
        }
    }

    static Iterator getIterator(Object object) {
        if (object.getClass().isArray()) {
            return new ReflectiveArrayIterator(object);
        }
        if (object instanceof Iterable) {
            return ((Iterable)object).iterator();
        }
        return null;
    }

    public static Object fromJSON(Class type, Object object) {
        if (object == null) {
            return null;
        }
        if (ClassUtils.isSuperclass(object.getClass(), type)) {
            return object;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, (String)object);
        }
        if (type.isArray()) {
            List l = (List)object;
            Object a = Array.newInstance(type.getComponentType(), l.size());
            int i = 0;
            for (Object o : l) {
                Array.set(a, i++, JsonUtils.fromJSON(type.getComponentType(), o));
            }
            return a;
        }
        if (type.isPrimitive()) {
            type = ClassUtils.primitive2Object(type);
        }
        if (type.isInstance(object)) {
            return object;
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            if (Byte.class.equals((Object)type)) {
                return new Byte(n.byteValue());
            }
            if (Short.class.equals((Object)type)) {
                return new Short(n.shortValue());
            }
            if (Integer.class.equals((Object)type)) {
                return new Integer(n.intValue());
            }
            if (Long.class.equals((Object)type)) {
                return new Long(n.longValue());
            }
            if (Float.class.equals((Object)type)) {
                return new Float(n.floatValue());
            }
            if (Date.class.equals((Object)type) || ClassUtils.isSuperclass(type, Date.class)) {
                return new Date(n.longValue());
            }
            return new Double(n.doubleValue());
        }
        if (Character.class.equals((Object)type)) {
            return Character.valueOf(((String)object).charAt(0));
        }
        throw new ClassCastException(object.getClass() + " into " + type);
    }

    private static class ReflectiveArrayIterator
    implements Iterator {
        private Object a;
        private int len;
        private int ci = 0;

        ReflectiveArrayIterator(Object a) {
            this.a = a;
            this.len = Array.getLength(a);
        }

        @Override
        public boolean hasNext() {
            return this.ci < this.len;
        }

        public Object next() {
            ++this.ci;
            return Array.get(this.a, this.ci - 1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

