/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Stack;

class Parser {
    private static final int OBJECT_START = 123;
    private static final int OBJECT_END = 125;
    private static final int ARRAY_START = 91;
    private static final int ARRAY_END = 93;
    private static final int COLON = 58;
    private static final int COMMA = 44;
    private static final int PLUS = 43;
    private static final int MINUS = 45;
    private static final int DOUBLE_QUOTE = 34;
    private static final int COMMENT_START = 47;
    private static final int LINE_COMMENT = 47;
    private static final int BLOCK_COMMENT = 42;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private static final int TRUE_START = "true".charAt(0);
    private static final int FALSE_START = "false".charAt(0);
    private static final int NULL_START = "null".charAt(0);
    private Stack<Where> where = new Stack();
    private Error error;
    private Handler handler;
    private PushbackReader reader;

    public static void parse(InputStream stream, Handler handler) throws IOException {
        Parser.parse(new InputStreamReader(stream), handler);
    }

    public static void parse(Reader reader, Handler handler) throws IOException {
        Parser jp = new Parser(reader, handler);
        jp.parse(false);
    }

    public static Iterator<Void> parseArray(InputStream stream, Handler handler) throws IOException {
        return Parser.parseArray(new InputStreamReader(stream), handler);
    }

    public static Iterator<Void> parseArray(Reader reader, Handler handler) throws IOException {
        Parser jp = new Parser(reader, handler);
        return null;
    }

    private Parser(Reader reader, Handler handler) {
        this.where.push(Where.OUT);
        this.handler = handler;
        this.reader = new PushbackReader(reader, 1);
    }

    private void parse(boolean incremental) throws IOException {
        int cc = 0;
        while ((cc = this.reader.read()) != -1) {
            if (Character.isWhitespace(cc)) continue;
            switch (this.where.peek()) {
                case OUT: {
                    if (cc == 123) {
                        this.handler.objectStart();
                        this.where.push(Where.OBJECT);
                        break;
                    }
                    if (cc == 91) {
                        this.handler.arrayStart();
                        this.where.push(Where.ARRAY);
                        break;
                    }
                    if (cc == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.OBJECT_OR_ARRAY_EXPECTED;
                    break;
                }
                case COMMENT: {
                    if (cc == 47) {
                        this.handleComment(true);
                        this.where.pop();
                        break;
                    }
                    if (cc == 42) {
                        this.handleComment(false);
                        this.where.pop();
                        break;
                    }
                    this.error = Error.WRONG_COMMENT;
                    break;
                }
                case OBJECT: {
                    if (cc == 34) {
                        String s = this.handleStringValue();
                        if (s == null) break;
                        this.handler.field(s);
                        this.where.push(Where.OBJECT_COLON);
                        break;
                    }
                    if (cc == 125) {
                        this.handler.objectEnd();
                        this.where.pop();
                        break;
                    }
                    if (cc == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.FIELD_NAME_EXPECTED;
                    break;
                }
                case OBJECT_COLON: {
                    if (cc == 58) {
                        this.where.pop();
                        this.where.push(Where.OBJECT_VALUE);
                        break;
                    }
                    if (cc == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.COLON_EXPECTED;
                    break;
                }
                case OBJECT_VALUE: {
                    if (cc == 123) {
                        this.handler.objectStart();
                        this.where.pop();
                        this.where.push(Where.OBJECT_COMMA_OR_END);
                        this.where.push(Where.OBJECT);
                        break;
                    }
                    if (cc == 91) {
                        this.handler.arrayStart();
                        this.where.pop();
                        this.where.push(Where.OBJECT_COMMA_OR_END);
                        this.where.push(Where.ARRAY);
                        break;
                    }
                    if (cc == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.handleSimpleValue(cc);
                    this.where.pop();
                    this.where.push(Where.OBJECT_COMMA_OR_END);
                    break;
                }
                case OBJECT_COMMA_OR_END: {
                    if (cc == 44) {
                        this.where.pop();
                        break;
                    }
                    if (cc == 125) {
                        this.where.pop();
                        this.where.pop();
                        this.handler.objectEnd();
                        break;
                    }
                    if (cc == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.COMMA_OR_END_OF_OBJECT_EXPECTED;
                    break;
                }
                case ARRAY: {
                    if (cc == 123) {
                        this.handler.objectStart();
                        this.where.push(Where.ARRAY_COMMA_OR_END);
                        this.where.push(Where.OBJECT);
                        break;
                    }
                    if (cc == 91) {
                        this.handler.arrayStart();
                        this.where.push(Where.ARRAY_COMMA_OR_END);
                        this.where.push(Where.ARRAY);
                        break;
                    }
                    if (cc == 93) {
                        this.handler.arrayEnd();
                        this.where.pop();
                        break;
                    }
                    if (cc == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.handleSimpleValue(cc);
                    this.where.push(Where.ARRAY_COMMA_OR_END);
                    break;
                }
                case ARRAY_COMMA_OR_END: {
                    if (cc == 44) {
                        this.where.pop();
                        break;
                    }
                    if (cc == 93) {
                        this.where.pop();
                        this.where.pop();
                        this.handler.arrayEnd();
                        break;
                    }
                    if (cc == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.COMMA_OR_END_OF_ARRAY_EXPECTED;
                }
            }
            if (this.error == null) continue;
            this.handler.error(this.error);
            break;
        }
        if (cc == -1 && this.where.size() != 1) {
            this.handler.error(Error.UNCLOSED_OBJECT_OR_ARRAY);
        }
    }

    private void handleSimpleValue(int cc) throws IOException {
        if (cc == TRUE_START && Parser.finishString(this.reader, TRUE)) {
            this.handler.bool(true);
        } else if (cc == FALSE_START && Parser.finishString(this.reader, FALSE)) {
            this.handler.bool(false);
        } else if (cc == NULL_START && Parser.finishString(this.reader, NULL)) {
            this.handler.nul();
        } else if (cc == 34) {
            String s = this.handleStringValue();
            if (s != null) {
                this.handler.string(s);
            }
        } else if (cc == 43 || cc == 45 || Parser.isDecNumber((char)cc)) {
            this.reader.unread(cc);
            this.handleNumberValue();
        } else {
            this.error = Error.UNKNOWN_VALUE_TYPE;
        }
    }

    private void handleNumberValue() throws IOException {
        StringBuilder sb = new StringBuilder();
        int cc = -1;
        boolean isFloatingPoint = false;
        while ((cc = this.reader.read()) != -1) {
            char c = (char)cc;
            if (!(isFloatingPoint || c != '.' && c != 'e' && c != 'E')) {
                isFloatingPoint = true;
            }
            if (Parser.isFloatChar(c)) {
                sb.append(c);
                continue;
            }
            if (c == ',' || c == ']' || c == '}' || c == '/') {
                this.reader.unread(cc);
                break;
            }
            if (Character.isWhitespace(c)) break;
            this.error = Error.INVALID_NUMBER;
            return;
        }
        try {
            if (isFloatingPoint) {
                this.handler.number(Double.parseDouble(sb.toString()));
            } else {
                this.handler.number(Long.parseLong(sb.toString()));
            }
        }
        catch (NumberFormatException ex) {
            this.error = Error.INVALID_NUMBER;
        }
    }

    private String handleStringValue() throws IOException {
        int cc = -1;
        StringBuilder sb = new StringBuilder();
        block15: while ((cc = this.reader.read()) != -1) {
            switch (cc) {
                case 34: {
                    return sb.toString();
                }
                case 92: {
                    cc = this.reader.read();
                    switch (cc) {
                        case 92: {
                            sb.append('\\');
                            continue block15;
                        }
                        case 34: {
                            sb.append('\"');
                            continue block15;
                        }
                        case 47: {
                            sb.append('/');
                            continue block15;
                        }
                        case 98: {
                            sb.append('\b');
                            continue block15;
                        }
                        case 116: {
                            sb.append('\t');
                            continue block15;
                        }
                        case 110: {
                            sb.append('\n');
                            continue block15;
                        }
                        case 102: {
                            sb.append('\f');
                            continue block15;
                        }
                        case 114: {
                            sb.append('\r');
                            continue block15;
                        }
                        case 117: {
                            int c = this.handleUnicodeChar(this.reader);
                            if (c == -1) {
                                this.error = Error.INVALID_HEX_ENCODED_CHAR;
                                return null;
                            }
                            sb.append((char)c);
                            continue block15;
                        }
                    }
                    this.error = Error.INVALID_ESCAPE_CHAR;
                    return null;
                }
            }
            if (!Parser.isJsonStringChar(cc)) {
                this.error = Error.INVALID_CHARACTER_IN_STRING_LITERAL;
            }
            sb.append((char)cc);
        }
        this.error = Error.UNCLOSED_STRING_VALUE;
        return null;
    }

    private int handleUnicodeChar(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[4];
        for (int i = 0; i < 4; ++i) {
            int rc = reader.read();
            if (rc == -1) {
                return -1;
            }
            chars[i] = (char)rc;
            if (Parser.isHexaChar(chars[i])) continue;
            return -1;
        }
        String nr = new String(chars);
        try {
            int r = Integer.parseInt(nr, 16);
            return r;
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private void handleComment(boolean line) throws IOException {
        int cc = -1;
        StringBuilder sb = new StringBuilder();
        while ((cc = this.reader.read()) != -1) {
            if (line && (cc == 10 || cc == 13)) {
                this.handler.lineComment(sb.toString());
                return;
            }
            if (!line && cc == 42) {
                int cc1 = this.reader.read();
                if (cc1 == -1) break;
                if (cc1 == 47) {
                    this.handler.comment(sb.toString());
                    return;
                }
                sb.append((char)cc);
                sb.append((char)cc1);
                continue;
            }
            sb.append((char)cc);
        }
        this.error = Error.UNCLOSED_COMMENT;
    }

    private static boolean isFloatChar(char c) {
        return Parser.isDecNumber(c) || c == '.' || c == '+' || c == '-' || c == 'e' || c == 'E';
    }

    private static boolean isDecNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexaChar(char c) {
        char uc = Character.toUpperCase(c);
        return Parser.isDecNumber(c) || uc >= 'A' && uc <= 'F';
    }

    private static boolean isJsonStringChar(int c) {
        return c == 32 || c == 33 || c >= 35 && c <= 91 || c >= 93 && c <= 0x10FFFF;
    }

    private static boolean finishString(Reader r, String s) throws IOException {
        for (int i = 1; i < s.length(); ++i) {
            if (r.read() == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static class ParsingIterator
    implements Iterator<Void> {
        private ParsingIterator() {
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Void next() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static enum Error {
        OBJECT_OR_ARRAY_EXPECTED,
        UNKNOWN_VALUE_TYPE,
        COMMA_OR_END_OF_ARRAY_EXPECTED,
        COMMA_OR_END_OF_OBJECT_EXPECTED,
        INVALID_ESCAPE_CHAR,
        INVALID_HEX_ENCODED_CHAR,
        INVALID_CHARACTER_IN_STRING_LITERAL,
        UNCLOSED_STRING_VALUE,
        INVALID_NUMBER,
        FIELD_NAME_EXPECTED,
        COLON_EXPECTED,
        WRONG_COMMENT,
        UNCLOSED_COMMENT,
        UNCLOSED_OBJECT_OR_ARRAY;

    }

    private static enum Where {
        OUT,
        OBJECT,
        OBJECT_COLON,
        OBJECT_VALUE,
        OBJECT_COMMA_OR_END,
        ARRAY,
        ARRAY_COMMA_OR_END,
        COMMENT,
        NAME;

    }

    public static interface Handler {
        public void objectStart();

        public void objectEnd();

        public void arrayStart();

        public void arrayEnd();

        public void field(String var1);

        public void bool(boolean var1);

        public void string(String var1);

        public void nul();

        public void number(long var1);

        public void number(double var1);

        public void error(Error var1);

        public void comment(String var1);

        public void lineComment(String var1);
    }
}

