/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.IOException;
import java.util.HashMap;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class ApplicationDescriptorHandler {
    private static ApplicationDescriptorHandler handler;

    public static synchronized ApplicationDescriptorHandler getDefault() {
        if (handler == null) {
            handler = new ApplicationDescriptorHandler();
        }
        return handler;
    }

    private ApplicationDescriptorHandler() {
    }

    public void handleRename(FileObject file, String newName) {
        if (!this.isJava(file)) {
            return;
        }
        Project p = this.findProject(file);
        String className = this.calculateClassName(this.getSrcRoot(p), file);
        if (className != null) {
            this.postChangeRequest(p, className, className.substring(0, className.length() - file.getName().length()) + newName);
        }
    }

    public void handleMove(FileObject file, FileObject newFolder) {
        String newClassName;
        if (!this.isJava(file)) {
            return;
        }
        Project p = this.findProject(file);
        FileObject srcRoot = this.getSrcRoot(p);
        String className = this.calculateClassName(this.getSrcRoot(p), file);
        if (className == null) {
            return;
        }
        String string = newClassName = newFolder == null ? null : FileUtil.getRelativePath((FileObject)srcRoot, (FileObject)newFolder);
        if (newClassName != null) {
            if (newClassName.length() > 0) {
                newClassName = newClassName.replace('/', '.') + '.';
            }
            newClassName = newClassName + file.getName();
        }
        this.postChangeRequest(p, className, newClassName);
    }

    public void handleDelete(FileObject file) {
        if (!this.isJava(file)) {
            return;
        }
        Project p = this.findProject(file);
        String className = this.calculateClassName(this.getSrcRoot(p), file);
        if (className != null) {
            this.postChangeRequest(p, className, null);
        }
    }

    private boolean isJava(FileObject file) {
        return file != null && file.getExt().equals("java");
    }

    private Project findProject(FileObject file) {
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        return p instanceof J2MEProject ? p : null;
    }

    private FileObject getSrcRoot(Project p) {
        if (p == null) {
            return null;
        }
        AntProjectHelper helper = (AntProjectHelper)p.getLookup().lookup(AntProjectHelper.class);
        if (helper == null) {
            return null;
        }
        String srcDir = helper.getStandardPropertyEvaluator().getProperty("src.dir");
        return srcDir == null ? null : helper.resolveFileObject(srcDir);
    }

    private String calculateClassName(FileObject root, FileObject file) {
        String path;
        return root == null || file == null || (path = FileUtil.getRelativePath((FileObject)root, (FileObject)file)) == null ? null : path.substring(0, path.length() - 5).replace('/', '.');
    }

    private void postChangeRequest(final Project project, final String oldClassName, final String newClassName) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ApplicationDescriptorHandler.this.handleChangeRequest(project, oldClassName, newClassName);
            }
        });
    }

    protected void handleChangeRequest(Project project, String oldClassName, String newClassName) {
        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        ProjectConfigurationsHelper pch = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        if (helper == null || pch == null) {
            return;
        }
        EditableProperties props = helper.getProperties("nbproject/project.properties");
        ProjectConfiguration[] cfg = pch.getConfigurations().toArray(new ProjectConfiguration[0]);
        boolean modifiedProj = false;
        HashMap<String, String> newMidlets = new HashMap<String, String>();
        for (int i = 0; i < cfg.length; ++i) {
            HashMap midlets;
            boolean modifiedProp = false;
            String propName = pch.getDefaultConfiguration().equals(cfg[i]) ? "manifest.midlets" : "configs." + cfg[i].getDisplayName() + '.' + "manifest.midlets";
            String value = props.getProperty(propName);
            if (value == null || (midlets = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(value, null, null)) == null) continue;
            int m2 = 1;
            newMidlets.clear();
            for (int m = 1; !midlets.isEmpty() && m < 10000; ++m) {
                String record = (String)midlets.remove("MIDlet-" + String.valueOf(m));
                if (record == null) continue;
                String[] s = record.split(",", -1);
                if (s.length == 3 && s[2].trim().equals(oldClassName)) {
                    modifiedProp = true;
                    if (newClassName == null) continue;
                    newMidlets.put("MIDlet-" + String.valueOf(m2++), s[0] + ',' + s[1] + ',' + newClassName);
                    continue;
                }
                newMidlets.put("MIDlet-" + String.valueOf(m2++), record);
            }
            if (!modifiedProp) continue;
            props.setProperty(propName, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(newMidlets, null, null));
            modifiedProj = true;
        }
        if (modifiedProj) {
            try {
                helper.putProperties("nbproject/project.properties", props);
                ProjectManager.getDefault().saveProject(project);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }
}

