/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.MIDletsCacheListener;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public class MIDletsCacheHelper
implements AntProjectListener {
    private final AntProjectHelper helper;
    private final ProjectConfigurationsHelper confs;
    protected final ArrayList<MIDletsCacheListener> list = new ArrayList();
    private HashSet<String> set = new HashSet();

    public MIDletsCacheHelper(AntProjectHelper helper, ProjectConfigurationsHelper confs) {
        this.helper = helper;
        this.confs = confs;
        this.refresh();
        helper.addAntProjectListener((AntProjectListener)this);
        confs.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("activeConfiguration".equals(evt.getPropertyName())) {
                    MIDletsCacheHelper.this.refresh();
                }
            }
        });
    }

    public synchronized boolean contains(String midlet) {
        return this.set.contains(midlet);
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
    }

    public void propertiesChanged(AntProjectEvent ev) {
        this.refresh();
    }

    public final void refresh() {
        this.refreshCore();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MIDletsCacheListener[] mcl;
                ArrayList<MIDletsCacheListener> arrayList = MIDletsCacheHelper.this.list;
                synchronized (arrayList) {
                    mcl = MIDletsCacheHelper.this.list.toArray(new MIDletsCacheListener[MIDletsCacheHelper.this.list.size()]);
                }
                for (int i = 0; i < mcl.length; ++i) {
                    mcl[i].cacheChanged();
                }
            }
        });
    }

    private void refreshCore() {
        ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Object item;
                ProjectConfiguration activeProjectConfiguration = MIDletsCacheHelper.this.confs.getActiveConfiguration();
                String activeConfiguration = activeProjectConfiguration != null && activeProjectConfiguration != MIDletsCacheHelper.this.confs.getDefaultConfiguration() ? activeProjectConfiguration.getDisplayName() : null;
                MIDletsCacheHelper.this.set = new HashSet();
                String value = null;
                PropertyEvaluator pe = MIDletsCacheHelper.this.helper.getStandardPropertyEvaluator();
                if (activeConfiguration != null) {
                    String property = VisualPropertySupport.prefixPropertyName(activeConfiguration, "manifest.midlets");
                    value = pe.getProperty(property);
                }
                if (value == null) {
                    value = pe.getProperty("manifest.midlets");
                }
                if (value == null) {
                    return null;
                }
                HashMap map = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(value, null, null);
                if (map == null) {
                    return null;
                }
                int i = 1;
                while ((item = map.get("MIDlet-" + i)) != null) {
                    String midlet;
                    String[] strs;
                    ++i;
                    if (!(item instanceof String) || (strs = ((String)item).split(",", -1)).length < 2 || "".equals(midlet = strs[2].trim())) continue;
                    MIDletsCacheHelper.this.set.add(midlet);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMIDletsCacheListener(MIDletsCacheListener listener) {
        ArrayList<MIDletsCacheListener> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMIDletsCacheListener(MIDletsCacheListener listener) {
        ArrayList<MIDletsCacheListener> arrayList = this.list;
        synchronized (arrayList) {
            this.list.remove(listener);
        }
    }
}

