/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.modules.project.support.customizer.AntArtifactChooser;
import org.netbeans.modules.project.support.customizer.LibrariesChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class VisualClasspathSupport {
    static File lastFile = null;
    final JTable classpathTable;
    final JButton addJarButton;
    final JButton addFolderButton;
    final JButton addLibraryButton;
    final String libraryType;
    final JButton addArtifactButton;
    final JButton removeButton;
    final JButton upButton;
    final JButton downButton;
    private FileObject myRoot;
    private final ClasspathTableModel classpathModel;
    private ProjectProperties properties;
    private String libsClasspath;
    private String extraClasspath;

    public VisualClasspathSupport(JTable classpathTable, JButton addJarButton, JButton addFolderButton, JButton addLibraryButton, String libraryType, JButton addArtifactButton, JButton removeButton, JButton upButton, JButton downButton) {
        this.classpathTable = classpathTable;
        this.classpathModel = new ClasspathTableModel();
        this.classpathTable.setModel(this.classpathModel);
        this.classpathTable.getSelectionModel().setSelectionMode(2);
        this.classpathTable.setDefaultRenderer(VisualClassPathItem.class, new ClassPathRenderer());
        TableColumn column = classpathTable.getColumnModel().getColumn(1);
        JTableHeader header = classpathTable.getTableHeader();
        column.setMaxWidth(24 + SwingUtilities.computeStringWidth(header.getFontMetrics(header.getFont()), String.valueOf(column.getHeaderValue())));
        this.addJarButton = addJarButton;
        this.addFolderButton = addFolderButton;
        this.addLibraryButton = addLibraryButton;
        this.libraryType = libraryType;
        this.addArtifactButton = addArtifactButton;
        this.removeButton = removeButton;
        this.upButton = upButton;
        this.downButton = downButton;
        ClasspathSupportListener csl = new ClasspathSupportListener();
        addJarButton.addActionListener(csl);
        addFolderButton.addActionListener(csl);
        addLibraryButton.addActionListener(csl);
        addArtifactButton.addActionListener(csl);
        removeButton.addActionListener(csl);
        upButton.addActionListener(csl);
        downButton.addActionListener(csl);
        classpathTable.getSelectionModel().addListSelectionListener(csl);
        csl.valueChanged(null);
    }

    public void setProperties(ProjectProperties props) {
        this.properties = props;
        this.myRoot = props.getProjectDirectory();
    }

    public void setEnabled(boolean enabled) {
        this.classpathTable.setEnabled(enabled);
        this.addJarButton.setEnabled(enabled);
        this.addFolderButton.setEnabled(enabled);
        this.addLibraryButton.setEnabled(enabled);
        this.addArtifactButton.setEnabled(enabled);
        if (enabled) {
            boolean remove;
            int[] si = this.classpathTable.getSelectedRows();
            boolean bl = remove = si != null && si.length > 0;
            if (remove) {
                for (int i = 0; i < si.length; ++i) {
                    VisualClassPathItem vcpi = this.classpathModel.get(si[i]);
                    if (vcpi.canDelete()) continue;
                    remove = false;
                    break;
                }
            }
            boolean up = si != null && si.length > 0 && si[0] != 0;
            boolean down = si != null && si.length > 0 && si[si.length - 1] != this.classpathModel.getRowCount() - 1;
            this.removeButton.setEnabled(remove);
            this.upButton.setEnabled(up);
            this.downButton.setEnabled(down);
        } else {
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void setVisualClassPathItems(List<VisualClassPathItem> items) {
        this.classpathModel.clear();
        for (VisualClassPathItem cpItem : items) {
            this.classpathModel.addElement(cpItem);
        }
    }

    public List<VisualClassPathItem> getVisualClassPathItems() {
        ArrayList<VisualClassPathItem> items = new ArrayList<VisualClassPathItem>();
        Enumeration<VisualClassPathItem> e = this.classpathModel.elements();
        while (e.hasMoreElements()) {
            VisualClassPathItem cpItem = e.nextElement();
            items.add(cpItem);
        }
        return items;
    }

    public List<VisualClassPathItem> getExtraClassPathItems() {
        ArrayList<VisualClassPathItem> items = new ArrayList<VisualClassPathItem>();
        Enumeration<VisualClassPathItem> e = this.classpathModel.elements();
        while (e.hasMoreElements()) {
            VisualClassPathItem cpItem = e.nextElement();
            if (!cpItem.isExtra()) continue;
            items.add(cpItem);
        }
        return items;
    }

    public synchronized void setPropertyNames(String libs, String extra) {
        this.libsClasspath = libs;
        this.extraClasspath = extra;
    }

    private synchronized void fireActionPerformed() {
        this.properties.put(this.libsClasspath, this.getVisualClassPathItems());
        this.properties.put(this.extraClasspath, this.getExtraClassPathItems());
    }

    protected void addLibraries(Library[] libraries) {
        int[] si = this.classpathTable.getSelectedRows();
        int lastIndex = si == null || si.length == 0 ? -1 : si[si.length - 1];
        for (int i = 0; i < libraries.length; ++i) {
            String libraryName = libraries[i].getName();
            this.classpathModel.add(lastIndex + 1 + i, new VisualClassPathItem(libraries[i], 1, "${libs." + libraryName + ".classpath}", libraries[i].getDisplayName()));
        }
        this.fireActionPerformed();
    }

    protected void addJarFiles(File[] files) {
        int[] si = this.classpathTable.getSelectedRows();
        int lastIndex = si == null || si.length == 0 ? -1 : si[si.length - 1];
        for (int i = 0; i < files.length; ++i) {
            files[i] = FileUtil.normalizeFile((File)files[i]);
            this.classpathModel.add(lastIndex + 1 + i, new VisualClassPathItem(files[i], 0, null, files[i].getPath()));
        }
        this.fireActionPerformed();
    }

    protected void addFolders(File[] files) {
        int[] si = this.classpathTable.getSelectedRows();
        int lastIndex = si == null || si.length == 0 ? -1 : si[si.length - 1];
        for (int i = 0; i < files.length; ++i) {
            files[i] = FileUtil.normalizeFile((File)files[i]);
            this.classpathModel.add(lastIndex + 1 + i, new VisualClassPathItem(files[i], 4, null, files[i].getPath()));
        }
        this.fireActionPerformed();
    }

    protected void addArtifacts(AntArtifactChooser.ArtifactItem[] artifacts) {
        int[] si = this.classpathTable.getSelectedRows();
        int lastIndex = si == null || si.length == 0 ? -1 : si[si.length - 1];
        for (int i = 0; i < artifacts.length; ++i) {
            String location;
            AntArtifact artifact = artifacts[i].getArtifact();
            URI uri = artifacts[i].getURI();
            try {
                location = FileUtil.normalizeFile((File)new File(artifact.getScriptLocation().getParentFile().toURI().resolve(uri))).getPath();
            }
            catch (Exception e) {
                location = uri.getPath();
            }
            Project p = artifact.getProject();
            if (p != null && p.getProjectDirectory().equals(this.myRoot)) continue;
            this.classpathModel.add(lastIndex + 1 + i, new VisualClassPathItem(artifact, uri, 2, null, location));
        }
        this.fireActionPerformed();
    }

    protected void removeElements() {
        int[] si = this.classpathTable.getSelectedRows();
        if (si == null || si.length == 0) assert (false) : "Remove button should be disabled";
        for (int i = si.length - 1; i >= 0; --i) {
            this.classpathModel.remove(si[i]);
        }
        if (this.classpathModel.getRowCount() > 0) {
            int selectedIndex = si[si.length - 1] - si.length + 1;
            if (selectedIndex > this.classpathModel.getRowCount() - 1) {
                selectedIndex = this.classpathModel.getRowCount() - 1;
            }
            this.classpathTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
        this.fireActionPerformed();
    }

    protected void moveUp() {
        int i;
        int[] si = this.classpathTable.getSelectedRows();
        if (si == null || si.length == 0) assert (false) : "MoveUp button should be disabled";
        for (i = 0; i < si.length; ++i) {
            VisualClassPathItem item = this.classpathModel.get(si[i]);
            this.classpathModel.remove(si[i]);
            this.classpathModel.add(si[i] - 1, item);
        }
        for (i = 0; i < si.length; ++i) {
            int n = i;
            si[n] = si[n] - 1;
            if (i == 0) {
                this.classpathTable.getSelectionModel().setSelectionInterval(si[i], si[i]);
                continue;
            }
            this.classpathTable.getSelectionModel().addSelectionInterval(si[i], si[i]);
        }
        this.fireActionPerformed();
    }

    protected void moveDown() {
        int i;
        int[] si = this.classpathTable.getSelectedRows();
        if (si == null || si.length == 0) assert (false) : "MoveDown button should be disabled";
        for (i = si.length - 1; i >= 0; --i) {
            VisualClassPathItem item = this.classpathModel.get(si[i]);
            this.classpathModel.remove(si[i]);
            this.classpathModel.add(si[i] + 1, item);
        }
        for (i = 0; i < si.length; ++i) {
            int n = i;
            si[n] = si[n] + 1;
            if (i == 0) {
                this.classpathTable.getSelectionModel().setSelectionInterval(si[i], si[i]);
                continue;
            }
            this.classpathTable.getSelectionModel().addSelectionInterval(si[i], si[i]);
        }
        this.fireActionPerformed();
    }

    private class ClasspathTableModel
    extends AbstractTableModel {
        private Vector<VisualClassPathItem> items = new Vector();

        private ClasspathTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return NbBundle.getMessage(VisualClasspathSupport.class, (String)(column == 0 ? "CPTable_Column1" : "CPTable_Column2"));
        }

        public Class getColumnClass(int arg0) {
            return arg0 == 0 ? VisualClassPathItem.class : Boolean.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.items.get(rowIndex).setExtra((Boolean)aValue == false);
            VisualClasspathSupport.this.fireActionPerformed();
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public VisualClassPathItem get(int row) {
            return this.items.get(row);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? this.get(rowIndex) : Boolean.valueOf(!this.get(rowIndex).isExtra());
        }

        public void clear() {
            this.items.clear();
            this.fireTableDataChanged();
        }

        public void addElement(VisualClassPathItem elem) {
            int row = this.items.size();
            this.items.add(elem);
            this.fireTableRowsInserted(row, row);
        }

        public void add(int index, VisualClassPathItem elem) {
            this.items.add(index, elem);
            this.fireTableRowsInserted(index, index);
        }

        public void remove(int index) {
            this.items.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public Enumeration<VisualClassPathItem> elements() {
            return this.items.elements();
        }
    }

    private static class JarFileFilter
    extends FileFilter {
        private JarFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            String s = f.getName().toLowerCase();
            return f.isDirectory() || s.endsWith(".zip") || s.endsWith(".jar");
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_JarFileFilter");
        }
    }

    private static class ClassPathRenderer
    extends DefaultTableCellRenderer {
        private ClassPathRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            VisualClassPathItem visualClassPathItem = (VisualClassPathItem)value;
            this.setIcon(visualClassPathItem == null ? null : visualClassPathItem.getIcon());
            return this;
        }
    }

    private class ClasspathSupportListener
    implements ActionListener,
    ListSelectionListener {
        private ClasspathSupportListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == VisualClasspathSupport.this.addJarButton) {
                int option;
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                chooser.setMultiSelectionEnabled(true);
                chooser.setDialogTitle(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddJar"));
                chooser.setFileFilter(new JarFileFilter());
                chooser.setAcceptAllFileFilterUsed(false);
                if (lastFile != null) {
                    chooser.setSelectedFile(lastFile);
                }
                if ((option = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(VisualClasspathSupport.this.addJarButton))) == 0) {
                    File[] files = chooser.getSelectedFiles();
                    if (files.length > 0) {
                        lastFile = files[0];
                    }
                    VisualClasspathSupport.this.addJarFiles(files);
                }
            } else if (source == VisualClasspathSupport.this.addFolderButton) {
                int option;
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setMultiSelectionEnabled(true);
                chooser.setDialogTitle(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddFolder"));
                if (lastFile != null) {
                    chooser.setSelectedFile(lastFile);
                }
                if ((option = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(VisualClasspathSupport.this.addFolderButton))) == 0) {
                    File[] files = chooser.getSelectedFiles();
                    if (files.length > 0) {
                        lastFile = files[0];
                    }
                    VisualClasspathSupport.this.addFolders(files);
                }
            } else if (source == VisualClasspathSupport.this.addLibraryButton) {
                LibrariesChooser panel = new LibrariesChooser(VisualClasspathSupport.this.libraryType);
                JButton addLibraryButton = new JButton(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_AddLibrary"));
                addLibraryButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_AddLibrary"));
                addLibraryButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_AddLibrary"));
                Object[] options = new Object[]{addLibraryButton, NotifyDescriptor.CANCEL_OPTION};
                DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddLibrary"), true, options, options[0], 0, null, null);
                desc.setHelpCtx(new HelpCtx(LibrariesChooser.class));
                Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
                dlg.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddLibrary"));
                dlg.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VisualClasspathSupport.class, (String)"LBL_Classpath_AddLibrary"));
                dlg.setVisible(true);
                if (desc.getValue() == options[0]) {
                    VisualClasspathSupport.this.addLibraries(panel.getSelectedLibraries());
                }
                dlg.dispose();
            } else if (source == VisualClasspathSupport.this.addArtifactButton) {
                AntArtifactChooser.ArtifactItem[] artifacts = AntArtifactChooser.showDialog("jar");
                if (artifacts != null) {
                    VisualClasspathSupport.this.addArtifacts(artifacts);
                }
            } else if (source == VisualClasspathSupport.this.removeButton) {
                VisualClasspathSupport.this.removeElements();
            } else if (source == VisualClasspathSupport.this.upButton) {
                VisualClasspathSupport.this.moveUp();
            } else if (source == VisualClasspathSupport.this.downButton) {
                VisualClasspathSupport.this.moveDown();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            VisualClasspathSupport.this.setEnabled(true);
        }
    }
}

