/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.JavaMELibsPreviewHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.DocumentAdapter;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.NameAndLocationWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class NameAndLocationVisualPanel
extends JPanel {
    private static final String MSG_EMPTY_LIB_NAME = "MSG_EmptyLibraryName";
    private static final String MSG_EMPTY_LIB_DISPLAY_NAME = "MSG_EmptyLibraryDisplayName";
    private static final String MSG_LIB_EXISTS = "MSG_LibraryExists";
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel libraryDisplayName;
    private JTextField libraryDisplayNameValue;
    private JLabel libraryName;
    private JTextField libraryNameValue;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JLabel projectName;
    private JTextField projectNameValue;
    private WizardDescriptor mySettings;
    private NameAndLocationWizardPanel myPanel;

    NameAndLocationVisualPanel(NameAndLocationWizardPanel panel) {
        this.myPanel = panel;
        this.initComponents();
        DocumentAdapter dListener = new DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameAndLocationVisualPanel.this.setEnabledForFilesInfo(NameAndLocationVisualPanel.this.checkValidity());
                NameAndLocationVisualPanel.this.setFilesInfoIntoTextAreas();
            }
        };
        this.libraryNameValue.getDocument().addDocumentListener(dListener);
        this.libraryDisplayNameValue.getDocument().addDocumentListener(dListener);
    }

    private static String getMessage(String key, Object ... args) {
        return NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)key, (Object[])args);
    }

    protected void storeData(WizardDescriptor descriptor) {
        descriptor.putProperty("libName", (Object)this.getLibNameValue());
        descriptor.putProperty("displayName", (Object)this.getDisplayNameValue());
    }

    void readData(WizardDescriptor descriptor) {
        this.mySettings = descriptor;
        this.libraryNameValue.setText(this.getLibName());
        this.libraryDisplayNameValue.setText(this.getDisplayName());
        this.projectNameValue.setText((String)descriptor.getProperty("projName"));
        this.checkValidity();
    }

    private void setEnabledForFilesInfo(boolean enabled) {
        this.createdFilesValue.setEnabled(enabled);
        this.modifiedFilesValue.setEnabled(enabled);
    }

    private void setFilesInfoIntoTextAreas() {
        ArrayList<String> created = new ArrayList<String>();
        ArrayList<String> modified = new ArrayList<String>();
        this.addLibJarToList(created, modified);
        this.addLibXmlToList(created, modified);
        this.addLayerXmlToList(created, modified);
        this.addBundleToList(created, modified);
        this.createdFilesValue.setText(UIUtils.generateTextAreaContent(created.toArray(new String[0])));
        this.modifiedFilesValue.setText(UIUtils.generateTextAreaContent(modified.toArray(new String[0])));
    }

    private void addLibJarToList(List<String> created, List<String> modified) {
        List<String> existingArchives = NameAndLocationVisualPanel.getExistingArchives(this.getExistingLibraries(), this.getExistingLibraryNames());
        Library library = (Library)this.mySettings.getProperty("library");
        List<String> archives = JavaMELibsPreviewHelper.extractLibraryJarsPaths(library, this.getLibNameValue());
        for (String arch : archives) {
            if (existingArchives.contains(arch)) continue;
            created.add(arch);
        }
    }

    private static List<String> getExistingArchives(List<Library> existingLibs, List<String> existingLibNames) {
        ArrayList<String> existingArchives = new ArrayList<String>();
        if (existingLibs == null || existingLibNames == null) {
            return existingArchives;
        }
        Iterator<Library> itLib = existingLibs.iterator();
        Iterator<String> itName = existingLibNames.iterator();
        while (itLib.hasNext()) {
            Library library = itLib.next();
            String name = itName.next();
            existingArchives.addAll(JavaMELibsPreviewHelper.extractLibraryJarsPaths(library, name));
        }
        return existingArchives;
    }

    private void addLibXmlToList(List<String> created, List<String> modified) {
        String dotCodeNameBase = this.getCodeNameBase();
        String libName = this.getLibNameValue();
        String codeNameBase = dotCodeNameBase.replace('.', '/');
        created.add(codeNameBase + "/" + libName + ".xml");
    }

    private void addLayerXmlToList(List<String> created, List<String> modified) {
        String dotCodeNameBase = this.getCodeNameBase();
        String codeNameBase = dotCodeNameBase.replace('.', '/');
        modified.add(codeNameBase + "/" + "layer.xml");
    }

    private void addBundleToList(List<String> created, List<String> modified) {
        String dotCodeNameBase = this.getCodeNameBase();
        String codeNameBase = dotCodeNameBase.replace('.', '/');
        modified.add(codeNameBase + "/" + "Bundle.properties");
    }

    private String getDisplayName() {
        String displayName = (String)this.mySettings.getProperty("displayName");
        if (displayName == null) {
            Library library = (Library)this.mySettings.getProperty("library");
            displayName = library.getDisplayName();
        }
        return displayName;
    }

    private String getLibName() {
        String libName = (String)this.mySettings.getProperty("libName");
        if (libName == null) {
            Library library = (Library)this.mySettings.getProperty("library");
            libName = library.getName();
        }
        return libName;
    }

    private String getDisplayNameValue() {
        return this.libraryDisplayNameValue.getText();
    }

    private String getLibNameValue() {
        return this.libraryNameValue.getText();
    }

    private boolean checkValidity() {
        if (!this.isValidLibraryName()) {
            this.setError(NameAndLocationVisualPanel.getMessage(MSG_EMPTY_LIB_NAME, new Object[0]));
            return false;
        }
        if (!this.isValidLibraryDisplayName()) {
            this.setError(NameAndLocationVisualPanel.getMessage(MSG_EMPTY_LIB_DISPLAY_NAME, new Object[0]));
            return false;
        }
        if (this.isLibraryNameAlreadyExists()) {
            this.setError(NameAndLocationVisualPanel.getMessage(MSG_LIB_EXISTS, this.getLibNameValue()));
            return false;
        }
        this.markValid();
        return true;
    }

    private boolean isValidLibraryName() {
        return this.getLibNameValue() != null && this.getLibNameValue().trim().length() != 0;
    }

    public boolean isValidLibraryDisplayName() {
        return this.getDisplayNameValue() != null && this.getDisplayNameValue().trim().length() != 0;
    }

    public boolean isLibraryNameAlreadyExists() {
        String libName = this.getLibNameValue();
        List<String> existingLibNames = this.getExistingLibraryNames();
        if (existingLibNames == null || existingLibNames.size() == 0) {
            return false;
        }
        for (String name : existingLibNames) {
            if (!name.equals(libName)) continue;
            return true;
        }
        return false;
    }

    private List<String> getExistingLibraryNames() {
        return (List)this.mySettings.getProperty("existLibName");
    }

    private List<Library> getExistingLibraries() {
        return (List)this.mySettings.getProperty("existLibrary");
    }

    private String getCodeNameBase() {
        return (String)this.mySettings.getProperty("codeBaseName");
    }

    protected final void setError(String message) {
        assert (message != null);
        this.setMessage(message);
        this.setValid(false);
    }

    protected final void markValid() {
        this.setMessage(null);
        this.setValid(true);
    }

    private final void setMessage(String message) {
        this.mySettings.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    private final void setValid(boolean valid) {
        this.myPanel.setValid(valid);
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(NameAndLocationVisualPanel.class);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkValidity();
    }

    private void initComponents() {
        this.libraryName = new JLabel();
        this.libraryNameValue = new JTextField();
        this.libraryDisplayName = new JLabel();
        this.libraryDisplayNameValue = new JTextField();
        this.projectName = new JLabel();
        this.projectNameValue = new JTextField();
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.libraryName.setLabelFor(this.libraryNameValue);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/vmd/componentssupport/ui/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.libraryName, (String)bundle.getString("LBL_LibraryName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add((Component)this.libraryName, gridBagConstraints);
        this.libraryName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_Name"));
        this.libraryName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.add((Component)this.libraryNameValue, gridBagConstraints);
        this.libraryDisplayName.setLabelFor(this.libraryDisplayNameValue);
        Mnemonics.setLocalizedText((JLabel)this.libraryDisplayName, (String)bundle.getString("LBL_LibraryDisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.libraryDisplayName, gridBagConstraints);
        this.libraryDisplayName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_DisplayName"));
        this.libraryDisplayName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.libraryDisplayNameValue, gridBagConstraints);
        this.projectName.setLabelFor(this.projectNameValue);
        Mnemonics.setLocalizedText((JLabel)this.projectName, (String)bundle.getString("LBL_LibraryProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_LibraryProjectName"));
        this.projectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_LibraryProjectName"));
        this.projectNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.projectNameValue, gridBagConstraints);
        this.projectNameValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSN_ProjectName"));
        this.projectNameValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSD_ProjectName"));
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)bundle.getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.createdFiles.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_CreatedFiles"));
        this.createdFiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_CreatedFiles"));
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)bundle.getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        this.modifiedFiles.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_ModifiedFiles"));
        this.modifiedFiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_LBL_ModifiedFiles"));
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setToolTipText(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"LBL_CreatedFilesTip"));
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        this.createdFilesValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSN_CreatedFiles"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSD_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFilesValueS, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"LBL_ModifiedFilesTip"));
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        this.modifiedFilesValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSN_ModifiedFiles"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACSD_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.modifiedFilesValueS, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_NameLocationPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NameAndLocationVisualPanel.class, (String)"ACS_NameLocationPanel"));
    }
}

