/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.LayersBridge;
import org.netbeans.modules.options.keymap.XMLStorage;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ExportShortcutsAction {
    private static Action exportIDEActionsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_IDE_Actions_Action"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayersBridge layersBridge = new LayersBridge();
            Map<String, Set<ShortcutAction>> categoryToActions = layersBridge.getActions();
            Map m = ExportShortcutsAction.resolveNames(categoryToActions);
            ExportShortcutsAction.generateLayersXML(layersBridge, m);
        }
    };
    private static Action exportIDEShortcutsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_IDE_Shortcuts_Action"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashMap<String, Map<String, ShortcutAction>> allKeyMaps = new HashMap<String, Map<String, ShortcutAction>>();
            LayersBridge layersBridge = new LayersBridge();
            layersBridge.getActions();
            List<String> keyMaps = layersBridge.getProfiles();
            for (String keyMapName : keyMaps) {
                Map<ShortcutAction, Set<String>> actionToShortcuts = layersBridge.getKeymap(keyMapName);
                Map<String, ShortcutAction> shortcutToAction = LayersBridge.shortcutToAction(actionToShortcuts);
                allKeyMaps.put(keyMapName, shortcutToAction);
            }
            ExportShortcutsAction.generateLayersXML(layersBridge, allKeyMaps);
        }
    };
    private static Action exportEditorShortcutsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_Editor_Shortcuts_Action"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeymapManager editorBridge = null;
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                if (!"EditorBridge".equals(keymapManager.getName())) continue;
                editorBridge = keymapManager;
                break;
            }
            if (editorBridge != null) {
                Map<ShortcutAction, Set<String>> actionToShortcuts = editorBridge.getKeymap(editorBridge.getCurrentProfile());
                ExportShortcutsAction.generateEditorXML(actionToShortcuts);
            }
        }
    };
    private static Action exportShortcutsToHTMLAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_Shortcuts_to_HTML_Action"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExportShortcutsAction.exportShortcutsToHTML();
        }
    };

    private ExportShortcutsAction() {
    }

    public static Action getExportIDEActionsAction() {
        return exportIDEActionsAction;
    }

    public static Action getExportIDEShortcutsAction() {
        return exportIDEShortcutsAction;
    }

    public static Action getExportEditorShortcutsAction() {
        return exportEditorShortcutsAction;
    }

    public static Action getExportShortcutsToHTMLAction() {
        return exportShortcutsToHTMLAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportShortcutsToHTML() {
        KeymapModel keymapModel = new KeymapModel();
        TreeMap<String, Map<ShortcutAction, Set<String>>> keymaps = new TreeMap<String, Map<ShortcutAction, Set<String>>>();
        for (String profile : keymapModel.getProfiles()) {
            keymaps.put(profile, keymapModel.getKeymap(profile));
        }
        try {
            StringBuffer sb = new StringBuffer();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "html", attribs, "");
            XMLStorage.generateFolderStart(sb, "body", attribs, "  ");
            attribs.add("border", "1");
            attribs.add("cellpadding", "1");
            attribs.add("cellspacing", "0");
            XMLStorage.generateFolderStart(sb, "table", attribs, "    ");
            attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "tr", attribs, "      ");
            XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
            XMLStorage.generateFolderStart(sb, "h2", attribs, "        ");
            sb.append("Action Name");
            XMLStorage.generateFolderEnd(sb, "h2", "        ");
            XMLStorage.generateFolderEnd(sb, "td", "        ");
            for (String profile : keymaps.keySet()) {
                XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
                XMLStorage.generateFolderStart(sb, "h2", attribs, "        ");
                sb.append(profile);
                XMLStorage.generateFolderEnd(sb, "h2", "        ");
                XMLStorage.generateFolderEnd(sb, "td", "        ");
            }
            ExportShortcutsAction.exportShortcutsToHTML2(keymapModel, sb, keymaps);
            XMLStorage.generateFolderEnd(sb, "table", "    ");
            XMLStorage.generateFolderEnd(sb, "body", "  ");
            XMLStorage.generateFolderEnd(sb, "html", "");
            FileObject fo = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)"shortcuts.html");
            FileLock fileLock = fo.lock();
            try {
                OutputStream outputStream = fo.getOutputStream(fileLock);
                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                writer.write(sb.toString());
                writer.close();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static void exportShortcutsToHTML2(KeymapModel keymapModel, StringBuffer sb, Map<String, Map<ShortcutAction, Set<String>>> keymaps) {
        ArrayList<String> categories = new ArrayList<String>(keymapModel.getActionCategories());
        Collections.sort(categories);
        XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
        for (String category : categories) {
            XMLStorage.generateFolderStart(sb, "tr", attribs, "      ");
            attribs.add("colspan", Integer.toString(keymaps.size() + 1));
            attribs.add("rowspan", "1");
            XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
            attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "h3", attribs, "        ");
            sb.append(category);
            XMLStorage.generateFolderEnd(sb, "h3", "        ");
            XMLStorage.generateFolderEnd(sb, "td", "        ");
            XMLStorage.generateFolderEnd(sb, "tr", "      ");
            ExportShortcutsAction.exportShortcutsToHTML3(sb, keymapModel, category, keymaps);
        }
    }

    private static void exportShortcutsToHTML3(StringBuffer sb, KeymapModel keymapModel, String category, Map<String, Map<ShortcutAction, Set<String>>> keymaps) {
        Set<ShortcutAction> actions = keymapModel.getActions(category);
        TreeMap<String, ShortcutAction> sortedActions = new TreeMap<String, ShortcutAction>();
        for (ShortcutAction action : actions) {
            sortedActions.put(action.getDisplayName(), action);
        }
        XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
        for (Map.Entry entry : sortedActions.entrySet()) {
            String actionName = (String)entry.getKey();
            ShortcutAction action = (ShortcutAction)entry.getValue();
            XMLStorage.generateFolderStart(sb, "tr", attribs, "      ");
            XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
            sb.append(actionName);
            XMLStorage.generateFolderEnd(sb, "td", "        ");
            for (String profile : keymaps.keySet()) {
                Map<ShortcutAction, Set<String>> keymap = keymaps.get(profile);
                Set<String> shortcuts = keymap.get(action);
                XMLStorage.generateFolderStart(sb, "td", attribs, "        ");
                ExportShortcutsAction.printShortcuts(shortcuts, sb);
                XMLStorage.generateFolderEnd(sb, "td", "        ");
            }
            XMLStorage.generateFolderEnd(sb, "tr", "      ");
        }
    }

    private static void printShortcuts(Set<String> shortcuts, StringBuffer sb) {
        if (shortcuts == null) {
            sb.append('-');
            return;
        }
        Iterator<String> it = shortcuts.iterator();
        while (it.hasNext()) {
            String shortcut = it.next();
            sb.append(shortcut);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateLayersXML(LayersBridge layersBridge, Map<String, Map<String, ShortcutAction>> categoryToActions) {
        Writer fw = null;
        try {
            fw = ExportShortcutsAction.openWriter();
            if (fw == null) {
                return;
            }
            StringBuffer sb = XMLStorage.generateHeader();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "filesystem", attribs, "");
            attribs.add("name", "Keymaps");
            XMLStorage.generateFolderStart(sb, "folder", attribs, "    ");
            ExportShortcutsAction.generateShadowsToXML(layersBridge, sb, categoryToActions, "        ");
            XMLStorage.generateFolderEnd(sb, "folder", "    ");
            XMLStorage.generateFolderEnd(sb, "filesystem", "");
            System.out.println(sb.toString());
            fw.write(sb.toString());
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateEditorXML(Map<ShortcutAction, Set<String>> actionToShortcuts) {
        Writer fw = null;
        try {
            fw = ExportShortcutsAction.openWriter();
            if (fw == null) {
                return;
            }
            StringBuffer sb = XMLStorage.generateHeader();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(sb, "bindings", attribs, "");
            TreeMap<String, Set<String>> sortedMap = new TreeMap<String, Set<String>>();
            for (ShortcutAction action : actionToShortcuts.keySet()) {
                sortedMap.put(action.getDisplayName(), actionToShortcuts.get(action));
            }
            for (String actionName : sortedMap.keySet()) {
                Set shortcuts = (Set)sortedMap.get(actionName);
                for (String shortcut : shortcuts) {
                    attribs = new XMLStorage.Attribs(true);
                    attribs.add("actionName", actionName);
                    attribs.add("key", shortcut);
                    XMLStorage.generateLeaf(sb, "bind", attribs, "  ");
                }
            }
            XMLStorage.generateFolderEnd(sb, "bindings", "");
            System.out.println(sb.toString());
            fw.write(sb.toString());
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static Map<String, Map<String, ShortcutAction>> resolveNames(Map<String, Set<ShortcutAction>> categoryToActions) {
        HashMap<String, Map<String, ShortcutAction>> result = new HashMap<String, Map<String, ShortcutAction>>();
        for (Map.Entry<String, Set<ShortcutAction>> entry : categoryToActions.entrySet()) {
            String category = entry.getKey();
            Set<ShortcutAction> actions = entry.getValue();
            HashMap<String, ShortcutAction> actionsMap = new HashMap<String, ShortcutAction>();
            for (ShortcutAction action : actions) {
                actionsMap.put(action.getDisplayName(), action);
            }
            result.put(category, actionsMap);
        }
        return result;
    }

    private static void generateShadowsToXML(LayersBridge layersBridge, StringBuffer sb, Map<String, Map<String, ShortcutAction>> shortcutToAction, String indentation) {
        for (String key : shortcutToAction.keySet()) {
            Map<String, ShortcutAction> value = shortcutToAction.get(key);
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            attribs.add("name", key);
            XMLStorage.generateFolderStart(sb, "folder", attribs, indentation);
            ExportShortcutsAction.generateShadowsToXML2(layersBridge, sb, value, "    " + indentation);
            XMLStorage.generateFolderEnd(sb, "folder", indentation);
        }
    }

    private static void generateShadowsToXML2(LayersBridge layersBridge, StringBuffer sb, Map<String, ShortcutAction> shortcutToAction, String indentation) {
        for (String key : shortcutToAction.keySet()) {
            ShortcutAction value = shortcutToAction.get(key);
            DataObject dob = layersBridge.getDataObject(value);
            if (dob == null) {
                System.out.println("no Dataobject " + value);
                continue;
            }
            FileObject fo = dob.getPrimaryFile();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            attribs.add("name", key + ".shadow");
            XMLStorage.generateFolderStart(sb, "file", attribs, indentation);
            XMLStorage.Attribs attribs2 = new XMLStorage.Attribs(true);
            attribs2.add("name", "originalFile");
            attribs2.add("stringvalue", fo.getPath());
            XMLStorage.generateLeaf(sb, "attr", attribs2, indentation + "    ");
            XMLStorage.generateFolderEnd(sb, "file", indentation);
        }
    }

    private static Writer openWriter() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        int result = fileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
        if (result != 0) {
            return null;
        }
        File f = fileChooser.getSelectedFile();
        return new FileWriter(f);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(ExportShortcutsAction.class, (String)key);
    }
}

