/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.editor.hints.WebServicesRulesEngine;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class WebServicesHintsProvider {
    private static final Object singleInstanceLock = new Object();
    private static WebServicesHintsProvider runningInstance = null;
    private FileObject file;
    private boolean cancelled = false;
    private ProblemContext context = null;
    private List<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
    private final Object cancellationLock = new Object();
    private WSDLModel wsdlModel;
    private Service service;
    private ComponentListener changeListener;

    public WebServicesHintsProvider(FileObject fileObject) {
        this.file = fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancelled = true;
        Object object = this.cancellationLock;
        synchronized (object) {
            if (this.context != null) {
                this.context.setCancelled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo compilationInfo) throws Exception {
        if (runningInstance != null) {
            runningInstance.cancel();
        }
        Object object = singleInstanceLock;
        synchronized (object) {
            runningInstance = this;
            this.cancelled = false;
            this.problemsFound.clear();
            for (Tree tree : compilationInfo.getCompilationUnit().getTypeDecls()) {
                if (this.isCancelled()) break;
                if (tree.getKind() != Tree.Kind.CLASS) continue;
                TreePath treePath = compilationInfo.getTrees().getPath(compilationInfo.getCompilationUnit(), tree);
                TypeElement typeElement = (TypeElement)compilationInfo.getTrees().getElement(treePath);
                if (typeElement == null) continue;
                this.initServiceMetadata(typeElement);
                this.createProblemContext(compilationInfo, typeElement);
                WebServicesRulesEngine webServicesRulesEngine = new WebServicesRulesEngine();
                typeElement.accept(webServicesRulesEngine, this.context);
                this.problemsFound.addAll(webServicesRulesEngine.getProblemsFound());
                Object object2 = this.cancellationLock;
                synchronized (object2) {
                    this.context = null;
                }
            }
            HintsController.setErrors((FileObject)this.file, (String)"WebService Verification", this.problemsFound);
            runningInstance = null;
        }
    }

    private void createProblemContext(CompilationInfo compilationInfo, TypeElement typeElement) {
        this.context = new ProblemContext();
        this.context.setJavaClass(typeElement);
        this.context.setFileObject(this.file);
        this.context.setCompilationInfo(compilationInfo);
        if (this.service != null) {
            this.context.addUserObject(this.service);
        }
        if (this.wsdlModel != null) {
            this.context.addUserObject(this.wsdlModel);
        }
    }

    private void initServiceMetadata(TypeElement typeElement) {
        JaxWsModel jaxWsModel;
        Project project;
        if (this.service == null && (project = FileOwnerQuery.getOwner((FileObject)this.file)) != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null) {
            this.service = jaxWsModel.findServiceByImplementationClass(typeElement.getQualifiedName().toString());
        }
        if (this.service != null && this.service.getLocalWsdlFile() != null && (project = JAXWSSupport.getJAXWSSupport((FileObject)this.file)) != null && (jaxWsModel = project.getLocalWsdlFolderForService(this.service.getName(), false)) != null) {
            FileObject fileObject = jaxWsModel.getFileObject(this.service.getLocalWsdlFile());
            WSDLModel wSDLModel = WSDLModelFactory.getDefault().getModel(Utilities.getModelSource((FileObject)fileObject, (boolean)true));
            if (wSDLModel != this.wsdlModel) {
                if (this.wsdlModel != null && this.changeListener != null) {
                    this.wsdlModel.removeComponentListener(this.changeListener);
                    this.changeListener = null;
                }
                this.wsdlModel = wSDLModel;
                if (this.wsdlModel != null) {
                    if (this.changeListener == null) {
                        this.changeListener = (ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)((Object)new WsdlModelListener(this.file)), (Object)this.wsdlModel);
                    }
                    this.wsdlModel.addComponentListener(this.changeListener);
                }
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<? extends ErrorDescription> getProblemsFound() {
        return this.problemsFound;
    }

    private class WsdlModelListener
    extends RescanTrigger
    implements ComponentListener {
        WsdlModelListener(FileObject fileObject) {
            super(fileObject);
        }

        public void valueChanged(ComponentEvent componentEvent) {
            if (!WebServicesHintsProvider.this.isCancelled()) {
                this.rescan();
            }
        }

        public void childrenAdded(ComponentEvent componentEvent) {
            if (!WebServicesHintsProvider.this.isCancelled()) {
                this.rescan();
            }
        }

        public void childrenDeleted(ComponentEvent componentEvent) {
            if (!WebServicesHintsProvider.this.isCancelled()) {
                this.rescan();
            }
        }
    }

    private abstract class RescanTrigger {
        private FileObject file;

        RescanTrigger(FileObject fileObject) {
            this.file = fileObject;
        }

        void rescan() {
            final JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            if (javaSource != null) {
                try {
                    if (EventQueue.isDispatchThread()) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    javaSource.runUserActionTask((Task)new ProblemFinderCompControl(RescanTrigger.this.file), true);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                    } else {
                        javaSource.runUserActionTask((Task)new ProblemFinderCompControl(this.file), true);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static class ProblemFinderCompControl
    extends WebServicesHintsProvider
    implements CancellableTask<CompilationController> {
        public ProblemFinderCompControl(FileObject fileObject) {
            super(fileObject);
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            super.run((CompilationInfo)compilationController);
        }
    }

    public static class ProblemFinderCompInfo
    extends WebServicesHintsProvider
    implements CancellableTask<CompilationInfo> {
        public ProblemFinderCompInfo(FileObject fileObject) {
            super(fileObject);
        }
    }
}

