/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api.config;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.eecommon.api.config.GlassfishConfiguration;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class FolderListener
implements FileChangeListener {
    private final File configKey;
    private final String[] targets;

    public static FileChangeListener createListener(File file, FileObject fileObject, J2eeModule.Type type) {
        return new FolderListener(file, fileObject, type);
    }

    private FolderListener(File file, FileObject fileObject, J2eeModule.Type type) {
        this.configKey = file;
        if (type == J2eeModule.Type.WAR) {
            this.targets = new String[]{"web.xml", "webservices.xml"};
        } else if (type == J2eeModule.Type.EJB) {
            this.targets = new String[]{"ejb-jar.xml", "webservices.xml"};
        } else if (type == J2eeModule.Type.EAR) {
            this.targets = new String[]{"application.xml"};
        } else if (type == J2eeModule.Type.CAR) {
            this.targets = new String[]{"application-client.xml"};
        } else {
            Logger.getLogger("glassfish-eecommon").log(Level.WARNING, "Unsupported module type: " + type);
            this.targets = new String[0];
        }
        fileObject.addFileChangeListener((FileChangeListener)this);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        for (String string : this.targets) {
            GlassfishConfiguration glassfishConfiguration;
            if (!string.equals(fileObject.getNameExt()) || (glassfishConfiguration = GlassfishConfiguration.getConfiguration(this.configKey)) == null) continue;
            glassfishConfiguration.addDescriptorListener(fileObject);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }
}

