/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.gsfret.InstantRenameAction;
import org.netbeans.modules.gsf.DeleteToNextCamelCasePosition;
import org.netbeans.modules.gsf.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.gsf.GsfDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.NextCamelCasePosition;
import org.netbeans.modules.gsf.PreviousCamelCasePosition;
import org.netbeans.modules.gsf.SelectCodeElementAction;
import org.netbeans.modules.gsf.SelectNextCamelCasePosition;
import org.netbeans.modules.gsf.SelectPreviousCamelCasePosition;
import org.netbeans.modules.gsf.ToggleBlockCommentAction;
import org.netbeans.modules.gsf.api.GsfLanguage;
import org.netbeans.modules.gsf.api.KeystrokeHandler;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.spi.CommentHandler;
import org.netbeans.modules.gsf.spi.DefaultLanguageConfig;
import org.netbeans.modules.gsfret.editor.fold.GsfFoldManager;
import org.netbeans.modules.gsfret.editor.hyperlink.GoToSupport;
import org.netbeans.modules.gsfret.editor.semantic.GoToMarkOccurrencesAction;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GsfEditorKitFactory {
    public static final String expandAllCodeBlockFolds = "expand-all-code-block-folds";
    public static final String collapseAllCodeBlockFolds = "collapse-all-code-block-folds";
    Language language;
    String mimeType;

    public GsfEditorKitFactory(Language language) {
        assert (language != null);
        this.language = language;
        this.mimeType = language.getMimeType();
    }

    public GsfEditorKit kit() {
        return new GsfEditorKit();
    }

    public static Action findAction(Action[] actions, String name) {
        for (Action a : actions) {
            Object nameObj = a.getValue("Name");
            if (!(nameObj instanceof String) || !name.equals(nameObj)) continue;
            return a;
        }
        return null;
    }

    static KeystrokeHandler getBracketCompletion(Document doc, int offset) {
        BaseDocument baseDoc = (BaseDocument)doc;
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDoc, offset);
        for (Language l : list) {
            if (l.getBracketCompletion() == null) continue;
            return l.getBracketCompletion();
        }
        return null;
    }

    private static boolean completionSettingEnabled() {
        return true;
    }

    public static class CollapseAllCodeBlockFolds
    extends BaseAction {
        public CollapseAllCodeBlockFolds() {
            super(GsfEditorKitFactory.collapseAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(GsfEditorKitFactory.class).getString(GsfEditorKitFactory.collapseAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(GsfEditorKitFactory.class).getString("popup-collapse-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(GsfFoldManager.CODE_BLOCK_FOLD_TYPE);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, types);
        }
    }

    public static class ExpandAllCodeBlockFolds
    extends BaseAction {
        public ExpandAllCodeBlockFolds() {
            super(GsfEditorKitFactory.expandAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle(GsfEditorKitFactory.class).getString(GsfEditorKitFactory.expandAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle(GsfEditorKitFactory.class).getString("popup-expand-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(GsfFoldManager.CODE_BLOCK_FOLD_TYPE);
            FoldUtilities.expand((FoldHierarchy)hierarchy, types);
        }
    }

    public class GsfEditorKit
    extends NbEditorKit {
        public String getContentType() {
            return GsfEditorKitFactory.this.language.getMimeType();
        }

        public Document createDefaultDocument() {
            GsfDocument doc = new GsfDocument(GsfEditorKitFactory.this.language);
            doc.putProperty("mimeType", this.getContentType());
            return doc;
        }

        public SyntaxSupport createSyntaxSupport(final BaseDocument doc) {
            return new ExtSyntaxSupport(doc){

                public int[] findMatchingBlock(int offset, boolean simpleSearch) throws BadLocationException {
                    KeystrokeHandler bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)doc, offset);
                    if (bracketCompletion != null) {
                        OffsetRange range = bracketCompletion.findMatching((Document)this.getDocument(), offset);
                        if (range == OffsetRange.NONE) {
                            return null;
                        }
                        return new int[]{range.getStart(), range.getEnd()};
                    }
                    return null;
                }
            };
        }

        protected void initDocument(BaseDocument doc) {
            CodeTemplateManager.get((Document)doc);
        }

        public Object clone() {
            return new GsfEditorKit();
        }

        protected Action[] createActions() {
            String lineCommentPrefix;
            Action[] superActions = super.createActions();
            GsfLanguage gsfLanguage = GsfEditorKitFactory.this.language.getGsfLanguage();
            ArrayList<Object> actions = new ArrayList<Object>(30);
            actions.add((Object)new GsfDefaultKeyTypedAction());
            actions.add((Object)new GsfInsertBreakAction());
            actions.add(new GsfDeleteCharAction("delete-previous", false));
            String string = lineCommentPrefix = gsfLanguage != null ? gsfLanguage.getLineCommentPrefix() : null;
            if (lineCommentPrefix != null) {
                actions.add(new ExtKit.CommentAction(lineCommentPrefix));
                actions.add(new ExtKit.UncommentAction(lineCommentPrefix));
                actions.add(new ExtKit.ToggleCommentAction(lineCommentPrefix));
            } else {
                CommentHandler ch;
                CommentHandler commentHandler = ch = gsfLanguage != null && gsfLanguage instanceof DefaultLanguageConfig ? ((DefaultLanguageConfig)gsfLanguage).getCommentHandler() : null;
                if (ch != null) {
                    actions.add(new ExtKit.CommentAction(lineCommentPrefix));
                    actions.add(new ExtKit.UncommentAction(lineCommentPrefix));
                    actions.add((Object)new ToggleBlockCommentAction(ch));
                }
            }
            actions.add((Object)new InstantRenameAction());
            actions.add((Object)new GenericGoToDeclarationAction());
            actions.add((Object)new GenericGenerateGoToPopupAction());
            actions.add((Object)new SelectCodeElementAction("select-element-next", true));
            actions.add((Object)new SelectCodeElementAction("select-element-previous", false));
            actions.add((Object)new NextCamelCasePosition(GsfEditorKitFactory.findAction(superActions, "caret-next-word")));
            actions.add((Object)new PreviousCamelCasePosition(GsfEditorKitFactory.findAction(superActions, "caret-previous-word")));
            actions.add((Object)new SelectNextCamelCasePosition(GsfEditorKitFactory.findAction(superActions, "selection-next-word")));
            actions.add((Object)new SelectPreviousCamelCasePosition(GsfEditorKitFactory.findAction(superActions, "selection-previous-word")));
            actions.add((Object)new DeleteToNextCamelCasePosition(GsfEditorKitFactory.findAction(superActions, "remove-word-next")));
            actions.add((Object)new DeleteToPreviousCamelCasePosition(GsfEditorKitFactory.findAction(superActions, "remove-word-previous")));
            if (GsfEditorKitFactory.this.language.hasOccurrencesFinder()) {
                actions.add((Object)new GoToMarkOccurrencesAction(false));
                actions.add((Object)new GoToMarkOccurrencesAction(true));
            }
            return TextAction.augmentList(superActions, actions.toArray(new Action[actions.size()]));
        }

        private class GenericGenerateGoToPopupAction
        extends NbEditorKit.NbGenerateGoToPopupAction {
            private GenericGenerateGoToPopupAction() {
            }

            public void actionPerformed(ActionEvent evt, JTextComponent target) {
            }

            private void addAcceleretors(Action a, JMenuItem item, JTextComponent target) {
                Keymap km = target.getKeymap();
                if (km != null) {
                    KeyStroke ks;
                    KeyStroke[] keys = km.getKeyStrokesForAction(a);
                    if (keys != null && keys.length > 0) {
                        item.setAccelerator(keys[0]);
                    } else if (a != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
                        item.setAccelerator(ks);
                    }
                }
            }

            private void addAction(JTextComponent target, JMenu menu, Action a) {
                if (a != null) {
                    String actionName = (String)a.getValue("Name");
                    JMenuItem item = null;
                    if (a instanceof BaseAction) {
                        item = ((BaseAction)a).getPopupMenuItem(target);
                    }
                    if (item == null) {
                        String itemText = (String)a.getValue("trimmed-text");
                        if (itemText == null) {
                            itemText = this.getItemText(target, actionName, a);
                        }
                        if (itemText != null) {
                            item = new JMenuItem(itemText);
                            Mnemonics.setLocalizedText((AbstractButton)item, (String)itemText);
                            item.addActionListener(a);
                            this.addAcceleretors(a, item, target);
                            item.setEnabled(a.isEnabled());
                            Object helpID = a.getValue("helpID");
                            if (helpID != null && helpID instanceof String) {
                                item.putClientProperty("HelpID", helpID);
                            }
                        } else if ("goto-source".equals(actionName)) {
                            item = new JMenuItem(NbBundle.getBundle(GsfEditorKit.class).getString("goto_source_open_source_not_formatted"));
                            this.addAcceleretors(a, item, target);
                            item.setEnabled(false);
                        }
                    }
                    if (item != null) {
                        menu.add(item);
                    }
                }
            }

            private void addAction(JTextComponent target, JMenu menu, String actionName) {
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                if (kit == null) {
                    return;
                }
                Action a = kit.getActionByName(actionName);
                if (a != null) {
                    this.addAction(target, menu, a);
                } else {
                    menu.addSeparator();
                }
            }

            private String getItemText(JTextComponent target, String actionName, Action a) {
                String itemText = a instanceof BaseAction ? ((BaseAction)a).getPopupMenuText(target) : actionName;
                return itemText;
            }

            public JMenuItem getPopupMenuItem(JTextComponent target) {
                String menuText = NbBundle.getBundle(GsfEditorKit.class).getString("generate-goto-popup");
                JMenu jm = new JMenu(menuText);
                this.addAction(target, jm, "goto-declaration");
                return jm;
            }
        }

        private class GenericGoToDeclarationAction
        extends ExtKit.GotoDeclarationAction {
            private GenericGoToDeclarationAction() {
            }

            public boolean gotoDeclaration(JTextComponent target) {
                GoToSupport.performGoTo((Document)((BaseDocument)target.getDocument()), target.getCaretPosition());
                return true;
            }
        }

        public class GsfDeleteCharAction
        extends ExtKit.ExtDeleteCharAction
        implements NextCharProvider {
            private JTextComponent currentTarget;

            public GsfDeleteCharAction(String nm, boolean nextChar) {
                super(nm, nextChar);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt, JTextComponent target) {
                target.putClientProperty(NextCharProvider.class, this);
                try {
                    this.currentTarget = target;
                    super.actionPerformed(evt, target);
                }
                finally {
                    this.currentTarget = null;
                    target.putClientProperty(NextCharProvider.class, null);
                }
            }

            protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
                KeystrokeHandler bracketCompletion;
                if (GsfEditorKitFactory.completionSettingEnabled() && (bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)doc, dotPos)) != null) {
                    boolean success = bracketCompletion.charBackspaced((Document)doc, dotPos, this.currentTarget, ch);
                    return;
                }
                super.charBackspaced(doc, dotPos, caret, ch);
            }

            @Override
            public boolean getNextChar() {
                return this.nextChar;
            }
        }

        public class GsfInsertBreakAction
        extends BaseKit.InsertBreakAction {
            static final long serialVersionUID = -1506173310438326380L;

            protected Object beforeBreak(JTextComponent target, BaseDocument doc, Caret caret) {
                KeystrokeHandler bracketCompletion;
                if (GsfEditorKitFactory.completionSettingEnabled() && (bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)doc, caret.getDot())) != null) {
                    try {
                        int newOffset = bracketCompletion.beforeBreak((Document)doc, caret.getDot(), target);
                        if (newOffset >= 0) {
                            return new Integer(newOffset);
                        }
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                    }
                }
                return null;
            }

            protected void afterBreak(JTextComponent target, BaseDocument doc, Caret caret, Object cookie) {
                if (GsfEditorKitFactory.completionSettingEnabled() && cookie != null && cookie instanceof Integer) {
                    int dotPos = (Integer)cookie;
                    if (dotPos != -1) {
                        caret.setDot(dotPos);
                    } else {
                        int nowDotPos = caret.getDot();
                        caret.setDot(nowDotPos + 1);
                    }
                }
            }
        }

        public class GsfDefaultKeyTypedAction
        extends ExtKit.ExtDefaultKeyTypedAction {
            private JTextComponent currentTarget;

            public void actionPerformed(ActionEvent evt, JTextComponent target) {
                this.currentTarget = target;
                super.actionPerformed(evt, target);
                this.currentTarget = null;
            }

            protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
                KeystrokeHandler bracketCompletion;
                if (GsfEditorKitFactory.completionSettingEnabled() && (bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)doc, dotPos)) != null) {
                    boolean handled = bracketCompletion.beforeCharInserted((Document)doc, dotPos, this.currentTarget, str.charAt(0));
                    if (!handled) {
                        super.insertString(doc, dotPos, caret, str, overwrite);
                        handled = bracketCompletion.afterCharInserted((Document)doc, dotPos, this.currentTarget, str.charAt(0));
                    }
                    return;
                }
                super.insertString(doc, dotPos, caret, str, overwrite);
            }

            protected void replaceSelection(JTextComponent target, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
                char insertedChar = str.charAt(0);
                Document document = target.getDocument();
                if (document instanceof BaseDocument) {
                    KeystrokeHandler bracketCompletion;
                    BaseDocument doc = (BaseDocument)document;
                    if (GsfEditorKitFactory.completionSettingEnabled() && (bracketCompletion = GsfEditorKitFactory.getBracketCompletion((Document)doc, dotPos)) != null) {
                        try {
                            int caretPosition = caret.getDot();
                            boolean handled = bracketCompletion.beforeCharInserted((Document)doc, caretPosition, target, insertedChar);
                            int p0 = Math.min(caret.getDot(), caret.getMark());
                            int p1 = Math.max(caret.getDot(), caret.getMark());
                            if (p0 != p1) {
                                doc.remove(p0, p1 - p0);
                            }
                            if (!handled) {
                                if (str != null && str.length() > 0) {
                                    doc.insertString(p0, str, null);
                                }
                                bracketCompletion.afterCharInserted((Document)doc, caret.getDot() - 1, target, insertedChar);
                            }
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                }
                super.replaceSelection(target, dotPos, caret, str, overwrite);
            }
        }
    }

    public static interface NextCharProvider {
        public boolean getNextChar();
    }
}

