/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.JBTargetModuleID;
import org.netbeans.modules.j2ee.jboss4.config.gen.JbossWeb;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JBDeployer
implements ProgressObject,
Runnable {
    private static final int TIMEOUT = 60000;
    private static final int POLLING_INTERVAL = 1000;
    private static final Logger LOGGER = Logger.getLogger(JBDeployer.class.getName());
    private final JBDeploymentManager dm;
    private File file;
    private String uri;
    private JBTargetModuleID mainModuleID;
    private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private DeploymentStatus deploymentStatus;

    public JBDeployer(String string, JBDeploymentManager jBDeploymentManager) {
        this.uri = string;
        this.dm = jBDeploymentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject deploy(Target[] targetArray, File file, File file2, String string, int n) {
        block15: {
            this.mainModuleID = new JBTargetModuleID(targetArray[0], file.getName());
            try {
                String string2 = "http://" + string + ":" + n;
                if (file.getName().endsWith(".war")) {
                    this.mainModuleID.setContextURL(string2 + JbossWeb.createGraph(file2).getContextRoot());
                    break block15;
                }
                if (!file.getName().endsWith(".ear")) break block15;
                JarFileSystem jarFileSystem = new JarFileSystem();
                jarFileSystem.setJarFile(file);
                FileObject fileObject = jarFileSystem.getRoot().getFileObject("META-INF/application.xml");
                if (fileObject != null) {
                    Application application = DDProvider.getDefault().getDDRoot(fileObject);
                    Module[] moduleArray = application.getModule();
                    for (int i = 0; i < moduleArray.length; ++i) {
                        JBTargetModuleID jBTargetModuleID = new JBTargetModuleID(targetArray[0]);
                        if (moduleArray[i].getWeb() != null) {
                            jBTargetModuleID.setContextURL(string2 + moduleArray[i].getWeb().getContextRoot());
                        }
                        this.mainModuleID.addChild(jBTargetModuleID);
                    }
                    break block15;
                }
                for (FileObject fileObject2 : jarFileSystem.getRoot().getChildren()) {
                    if (!fileObject2.hasExt("war") && !fileObject2.hasExt("jar")) continue;
                    JBTargetModuleID jBTargetModuleID = new JBTargetModuleID(targetArray[0]);
                    if (fileObject2.hasExt("war")) {
                        String string3 = fileObject2.getName();
                        ZipInputStream zipInputStream = new ZipInputStream(fileObject2.getInputStream());
                        try {
                            ZipEntry zipEntry = null;
                            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                                if (!"WEB-INF/jboss-web.xml".equals(zipEntry.getName())) continue;
                                String string4 = JbossWeb.createGraph(new ZipEntryInputStream(zipInputStream)).getContextRoot();
                                if (string4 != null) {
                                    string3 = string4;
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.INFO, "Error reading context-root", iOException);
                        }
                        finally {
                            zipInputStream.close();
                        }
                        jBTargetModuleID.setContextURL(string2 + string3);
                    }
                    this.mainModuleID.addChild(jBTargetModuleID);
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.INFO, null, exception);
            }
        }
        this.file = file;
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) {
        this.file = file;
        this.mainModuleID = (JBTargetModuleID)targetModuleIDArray[0];
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    @Override
    public void run() {
        String string = InstanceProperties.getInstanceProperties((String)this.uri).getProperty("deploy-dir");
        FileObject fileObject = FileUtil.toFileObject((File)this.file);
        FileObject fileObject2 = FileUtil.toFileObject((File)new File(string));
        String string2 = this.file.getName();
        File file = new File(string + File.separator + string2);
        if (file.exists()) {
            file.delete();
        }
        string2 = string2.substring(0, string2.lastIndexOf(46));
        String string3 = NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)this.file.getAbsolutePath());
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, string3));
        try {
            Object object;
            Long l = this.getDeploymentTime(file);
            FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)string2);
            JBTargetModuleID jBTargetModuleID = this.mainModuleID;
            String string4 = this.mainModuleID.getWebURL();
            if (string4 == null && (object = this.mainModuleID.getChildTargetModuleID()) != null) {
                for (int i = 0; i < ((TargetModuleID[])object).length; ++i) {
                    string4 = object[i].getWebURL();
                    if (string4 == null) continue;
                    jBTargetModuleID = object[i];
                    break;
                }
            }
            if (string4 != null) {
                object = new URL(string4);
                String string5 = NbBundle.getMessage(JBDeployer.class, (String)"MSG_Waiting_For_Url", (Object)object);
                this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, string5));
                boolean bl = this.waitForUrlReady(jBTargetModuleID, file, l, 60000L);
                if (!bl) {
                    LOGGER.log(Level.INFO, "URL wait timeouted after 60000");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.log(Level.INFO, null, malformedURLException);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (MissingResourceException missingResourceException) {
            LOGGER.log(Level.INFO, null, missingResourceException);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.INFO, null, interruptedException);
        }
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, "Applicaton Deployed"));
    }

    private boolean waitForUrlReady(TargetModuleID targetModuleID, File file, Long l, long l2) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted on wait enter");
        }
        int n = (int)l2 / 1000;
        for (int i = 0; i < n && !this.isApplicationReady(file, targetModuleID.getModuleID(), l, i == 0); ++i) {
            Thread.sleep(1000L);
        }
        return this.isApplicationReady(file, targetModuleID.getModuleID(), l, false);
    }

    private Long getDeploymentTime(File file) {
        assert (file != null);
        try {
            Object object = this.dm.invokeMBeanOperation(new ObjectName("jboss.system:service=MainDeployer"), "getDeployment", new Object[]{file.getCanonicalFile().toURL()}, new String[]{"java.net.URL"});
            if (object == null) {
                object = this.dm.invokeMBeanOperation(new ObjectName("jboss.system:service=MainDeployer"), "getDeployment", new Object[]{file.toURL()}, new String[]{"java.net.URL"});
            }
            if (object == null) {
                return Long.MIN_VALUE;
            }
            Class<?> clazz = object.getClass();
            return clazz.getDeclaredField("lastDeployed").getLong(object);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, null, exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isApplicationReady(File file, String string, Long l, boolean bl) throws InterruptedException {
        Object object;
        assert (file != null);
        assert (string != null);
        if (bl && l == null) {
            Thread.sleep(2000L);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            object = this.dm.invokeMBeanOperation(new ObjectName("jboss.system:service=MainDeployer"), "getDeployment", new Object[]{file.getCanonicalFile().toURL()}, new String[]{"java.net.URL"});
            if (object == null) {
                object = this.dm.invokeMBeanOperation(new ObjectName("jboss.system:service=MainDeployer"), "getDeployment", new Object[]{file.toURL()}, new String[]{"java.net.URL"});
            }
            if (object != null) {
                Thread.currentThread().setContextClassLoader(object.getClass().getClassLoader());
                Class<?> clazz = object.getClass();
                long l2 = clazz.getDeclaredField("lastDeployed").getLong(object);
                Object object2 = clazz.getDeclaredField("state").get(object);
                Object object3 = object2.getClass().getDeclaredField("STARTED").get(null);
                boolean bl2 = object3.equals(object2) && (l == null || l != l2);
                return bl2;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, null, exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        try {
            object = new ObjectName("jboss.web.deployment:war=" + string + ",*");
            MBeanServerConnection mBeanServerConnection = Util.getRMIServer(this.dm);
            Thread.currentThread().setContextClassLoader(mBeanServerConnection.getClass().getClassLoader());
            boolean bl3 = !mBeanServerConnection.queryMBeans((ObjectName)object, null).isEmpty();
            return bl3;
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, null, exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return false;
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Stop is not supported");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Cancel is not supported");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.mainModuleID};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentStatus getDeploymentStatus() {
        JBDeployer jBDeployer = this;
        synchronized (jBDeployer) {
            return this.deploymentStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent progressEvent = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        JBDeployer jBDeployer = this;
        synchronized (jBDeployer) {
            this.deploymentStatus = deploymentStatus;
        }
        for (ProgressListener progressListener : this.listeners) {
            progressListener.handleProgressEvent(progressEvent);
        }
    }

    private static class ZipEntryInputStream
    extends InputStream {
        private final ZipInputStream zis;

        public ZipEntryInputStream(ZipInputStream zipInputStream) {
            this.zis = zipInputStream;
        }

        @Override
        public int available() throws IOException {
            return this.zis.available();
        }

        @Override
        public void close() throws IOException {
            this.zis.closeEntry();
        }

        @Override
        public int read() throws IOException {
            if (this.available() > 0) {
                return this.zis.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.zis.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.zis.skip(l);
        }
    }
}

