/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ear.model;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.ApplicationMetadata;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EarProvider;
import org.netbeans.modules.maven.j2ee.ear.model.ApplicationImpl;
import org.netbeans.modules.maven.j2ee.ear.model.ApplicationMetadataImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class ApplicationMetadataModelImpl
implements MetadataModelImplementation<ApplicationMetadata> {
    private final Application root;
    private final ApplicationMetadata metadata;

    public ApplicationMetadataModelImpl(final Project project) {
        Application application = null;
        FileObject fileObject = this.getDeploymentDescriptor(project);
        if (fileObject != null) {
            try {
                application = DDProvider.getDefault().getDDRoot(fileObject);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        this.root = application != null ? application : (Application)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Application>(){

            public Application run() {
                return new ApplicationImpl(project);
            }
        });
        this.metadata = new ApplicationMetadataImpl(this.root);
    }

    public <R> R runReadAction(final MetadataModelAction<ApplicationMetadata, R> metadataModelAction) throws MetadataModelException, IOException {
        try {
            return (R)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<R>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public R run() throws Exception {
                    ApplicationMetadataModelImpl.this.enterRunReadAction();
                    try {
                        Object object = metadataModelAction.run((Object)ApplicationMetadataModelImpl.this.metadata);
                        return object;
                    }
                    finally {
                        ApplicationMetadataModelImpl.this.leaveRunReadAction();
                    }
                }
            });
        }
        catch (MutexException mutexException) {
            throw new MetadataModelException((Throwable)mutexException.getException());
        }
    }

    public boolean isReady() {
        return true;
    }

    public <R> Future<R> runReadActionWhenReady(MetadataModelAction<ApplicationMetadata, R> metadataModelAction) throws IOException {
        return new SimpleFuture<R>(this.runReadAction(metadataModelAction));
    }

    private FileObject getDeploymentDescriptor(Project project) {
        EarProvider earProvider = (EarProvider)project.getLookup().lookup(EarProvider.class);
        Ear ear = earProvider.findEar(project.getProjectDirectory());
        FileObject fileObject = ear.getDeploymentDescriptor();
        return fileObject;
    }

    private void enterRunReadAction() {
        Application application = this.metadata.getRoot();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).enterRunReadAction();
        }
    }

    private void leaveRunReadAction() {
        Application application = this.metadata.getRoot();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).leaveRunReadAction();
        }
    }

    private static final class SimpleFuture<R>
    implements Future<R> {
        private volatile R result;

        public SimpleFuture(R r) {
            this.result = r;
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public R get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }
}

