/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.netbeans.modules.maven.j2ee.web.WebModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebRunCustomizerPanel
extends JPanel {
    public static final String PROP_SHOW_IN_BROWSER = "netbeans.deploy.showBrowser";
    private Project project;
    private ModelHandle handle;
    private WebModule module;
    private WebModuleProviderImpl moduleProvider;
    private NetbeansActionMapping run;
    private NetbeansActionMapping debug;
    private NetbeansActionMapping profile;
    private boolean isRunCompatible;
    private boolean isDebugCompatible;
    private boolean isProfileCompatible;
    private String oldUrl;
    private ComboBoxUpdater<Wrapper> listener;
    private JCheckBox cbBrowser;
    private JComboBox comProfile;
    private JComboBox comServer;
    private JLabel lblContextPath;
    private JLabel lblHint1;
    private JLabel lblHint2;
    private JLabel lblJ2EEVersion;
    private JLabel lblProfile;
    private JLabel lblRelativeUrl;
    private JLabel lblServer;
    private JTextField txtContextPath;
    private JTextField txtJ2EEVersion;
    private JTextField txtRelativeUrl;

    public WebRunCustomizerPanel(final ModelHandle modelHandle, Project project) {
        this.initComponents();
        this.handle = modelHandle;
        this.project = project;
        this.module = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        this.moduleProvider = (WebModuleProviderImpl)((Object)project.getLookup().lookup(WebModuleProviderImpl.class));
        assert (this.moduleProvider != null);
        assert (this.module != null);
        this.loadComboModel();
        this.comProfile.setRenderer(new DefaultListCellRenderer(){

            @Override
            public java.awt.Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Profile profile = (Profile)object;
                String string = "Web";
                if (Profile.JAVA_EE_6_FULL.equals(profile)) {
                    string = "Full";
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        Profile profile = this.module.getJ2eeProfile();
        String string = profile.equals(Profile.JAVA_EE_6_WEB) ? Profile.JAVA_EE_6_FULL.toPropertiesString() : profile.toPropertiesString();
        this.txtJ2EEVersion.setText(string);
        WebModuleImpl webModuleImpl = this.moduleProvider.getWebModuleImplementation();
        if (Profile.JAVA_EE_6_WEB.equals(webModuleImpl.getDescriptorJ2eeProfile())) {
            this.lblProfile.setVisible(true);
            this.comProfile.setVisible(true);
            this.comProfile.setEnabled(true);
            this.comProfile.setModel(new DefaultComboBoxModel<Object>(new Object[]{Profile.JAVA_EE_6_WEB, Profile.JAVA_EE_6_FULL}));
            Profile profile2 = webModuleImpl.getPropertyJ2eeProfile();
            if (profile2 != null) {
                this.comProfile.setSelectedItem(profile2);
            } else {
                this.comProfile.setSelectedItem(Profile.JAVA_EE_6_WEB);
            }
            this.comProfile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Profile profile = (Profile)WebRunCustomizerPanel.this.comProfile.getSelectedItem();
                    org.netbeans.modules.maven.model.pom.Project project = modelHandle.getPOMModel().getProject();
                    if (profile.equals(Profile.JAVA_EE_6_FULL)) {
                        Properties properties = project.getProperties();
                        if (properties == null) {
                            properties = modelHandle.getPOMModel().getFactory().createProperties();
                            project.setProperties(properties);
                        }
                        WebRunCustomizerPanel.this.replaceDependency("javaee-web-api", "javaee-api");
                        properties.setProperty("netbeans.hint.j2eeVersion", profile.toPropertiesString());
                        modelHandle.markAsModified((Object)modelHandle.getPOMModel());
                    } else {
                        Properties properties = project.getProperties();
                        if (properties != null && properties.getProperty("netbeans.hint.j2eeVersion") != null) {
                            properties.setProperty("netbeans.hint.j2eeVersion", null);
                            if (properties.getProperties().size() == 0) {
                                ((AbstractDocumentComponent)project).removeChild("properties", (Component)properties);
                            }
                            WebRunCustomizerPanel.this.replaceDependency("javaee-api", "javaee-web-api");
                            modelHandle.markAsModified((Object)modelHandle.getPOMModel());
                        }
                    }
                }
            });
        } else {
            this.lblProfile.setVisible(false);
            this.comProfile.setVisible(false);
            this.comProfile.setEnabled(false);
        }
        this.initValues();
        this.txtContextPath.setText(webModuleImpl.getContextPath());
    }

    private void initValues() {
        this.listener = Wrapper.createComboBoxUpdater(this.handle, this.comServer, this.lblServer);
        this.run = ModelHandle.getActiveMapping((String)"run", (Project)this.project);
        this.debug = ModelHandle.getActiveMapping((String)"debug", (Project)this.project);
        this.profile = ModelHandle.getActiveMapping((String)"profile", (Project)this.project);
        this.isRunCompatible = this.checkMapping(this.run);
        this.isDebugCompatible = this.checkMapping(this.debug);
        this.isProfileCompatible = this.checkMapping(this.profile);
        String string = this.oldUrl = this.isRunCompatible ? this.run.getProperties().getProperty("netbeans.deploy.clientUrlPart") : this.debug.getProperties().getProperty("netbeans.deploy.clientUrlPart");
        if (this.oldUrl != null) {
            this.txtRelativeUrl.setText(this.oldUrl);
        } else {
            this.oldUrl = "";
        }
        this.txtRelativeUrl.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                WebRunCustomizerPanel.this.applyRelUrl();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                WebRunCustomizerPanel.this.applyRelUrl();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                WebRunCustomizerPanel.this.applyRelUrl();
            }
        });
        String string2 = (String)this.project.getProjectDirectory().getAttribute(PROP_SHOW_IN_BROWSER);
        boolean bl = string2 != null ? Boolean.parseBoolean(string2) : true;
        this.cbBrowser.setSelected(bl);
    }

    private void loadComboModel() {
        String[] stringArray = Deployment.getDefault().getServerInstanceIDs(Collections.singletonList(J2eeModule.Type.WAR), this.module.getJ2eeProfile());
        ArrayList<Wrapper> arrayList = new ArrayList<Wrapper>();
        SessionContent sessionContent = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        if (sessionContent != null && sessionContent.getServerInstanceId() != null) {
            arrayList.add(new Wrapper("DEV-NULL", sessionContent.getServerInstanceId()));
        } else {
            arrayList.add(new Wrapper("DEV-NULL"));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Wrapper wrapper = new Wrapper(stringArray[i]);
            arrayList.add(wrapper);
        }
        this.comServer.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void initComponents() {
        this.lblServer = new JLabel();
        this.comServer = new JComboBox();
        this.lblJ2EEVersion = new JLabel();
        this.txtJ2EEVersion = new JTextField();
        this.lblContextPath = new JLabel();
        this.txtContextPath = new JTextField();
        this.cbBrowser = new JCheckBox();
        this.lblHint1 = new JLabel();
        this.lblRelativeUrl = new JLabel();
        this.txtRelativeUrl = new JTextField();
        this.lblHint2 = new JLabel();
        this.lblProfile = new JLabel();
        this.comProfile = new JComboBox();
        this.lblServer.setLabelFor(this.comServer);
        Mnemonics.setLocalizedText((JLabel)this.lblServer, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Server"));
        this.lblJ2EEVersion.setLabelFor(this.txtJ2EEVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblJ2EEVersion, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_J2EE_Version"));
        this.txtJ2EEVersion.setEditable(false);
        this.lblContextPath.setLabelFor(this.txtContextPath);
        Mnemonics.setLocalizedText((JLabel)this.lblContextPath, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Context_Path"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbBrowser, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Display_on_Run"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint1, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Hint1"));
        this.lblRelativeUrl.setLabelFor(this.txtRelativeUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblRelativeUrl, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Relative_URL"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint2, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Hint2"));
        Mnemonics.setLocalizedText((JLabel)this.lblProfile, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"WebRunCustomizerPanel.lblProfile.text"));
        this.comProfile.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.cbBrowser).add((java.awt.Component)this.lblHint1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((java.awt.Component)this.lblRelativeUrl).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((java.awt.Component)this.lblHint2).addPreferredGap(0, 237, Short.MAX_VALUE)).add((java.awt.Component)this.txtRelativeUrl, -1, 377, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.lblContextPath).add((java.awt.Component)this.lblJ2EEVersion).add((java.awt.Component)this.lblServer)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (java.awt.Component)this.comServer, 0, 374, Short.MAX_VALUE).add((java.awt.Component)this.txtContextPath, -1, 374, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((java.awt.Component)this.txtJ2EEVersion, -1, 148, Short.MAX_VALUE).addPreferredGap(0).add((java.awt.Component)this.lblProfile).addPreferredGap(0).add((java.awt.Component)this.comProfile, 0, 159, Short.MAX_VALUE))))).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((java.awt.Component)this.lblServer).add((java.awt.Component)this.comServer, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((java.awt.Component)this.lblJ2EEVersion).add((java.awt.Component)this.txtJ2EEVersion, -2, -1, -2).add((java.awt.Component)this.lblProfile).add((java.awt.Component)this.comProfile, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((java.awt.Component)this.lblContextPath).add((java.awt.Component)this.txtContextPath, -2, -1, -2)).add(20, 20, 20).add((java.awt.Component)this.cbBrowser).add(16, 16, 16).add((java.awt.Component)this.lblHint1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((java.awt.Component)this.lblRelativeUrl).add((java.awt.Component)this.txtRelativeUrl, -2, -1, -2)).addPreferredGap(0).add((java.awt.Component)this.lblHint2).addContainerGap(97, Short.MAX_VALUE)));
        this.txtJ2EEVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"WebRunCustomizerPanel.txtJ2EEVersion.AccessibleContext.accessibleDescription"));
        this.txtContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"WebRunCustomizerPanel.txtContextPath.AccessibleContext.accessibleDescription"));
        this.cbBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"WebRunCustomizerPanel.cbBrowser.AccessibleContext.accessibleDescription"));
        this.txtRelativeUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"WebRunCustomizerPanel.txtRelativeUrl.AccessibleContext.accessibleDescription"));
    }

    private boolean checkMapping(NetbeansActionMapping netbeansActionMapping) {
        if (netbeansActionMapping == null) {
            return false;
        }
        for (String string : netbeansActionMapping.getGoals()) {
            if (string.indexOf("netbeans-deploy-plugin") <= -1) continue;
            return true;
        }
        return netbeansActionMapping.getProperties().containsKey("netbeans.deploy");
    }

    private void applyRelUrl() {
        String string = this.txtRelativeUrl.getText().trim();
        if (!string.equals(this.oldUrl)) {
            if (this.isRunCompatible) {
                this.run.getProperties().setProperty("netbeans.deploy.clientUrlPart", string);
                ModelHandle.setUserActionMapping((NetbeansActionMapping)this.run, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified((Object)this.handle.getActionMappings());
            }
            if (this.isDebugCompatible) {
                this.debug.getProperties().setProperty("netbeans.deploy.clientUrlPart", string);
                ModelHandle.setUserActionMapping((NetbeansActionMapping)this.debug, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified((Object)this.handle.getActionMappings());
            }
            if (this.isProfileCompatible) {
                this.profile.getProperties().setProperty("netbeans.deploy.clientUrlPart", string);
                ModelHandle.setUserActionMapping((NetbeansActionMapping)this.profile, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified((Object)this.handle.getActionMappings());
            }
        }
    }

    String applyChangesInAWT() {
        assert (SwingUtilities.isEventDispatchThread());
        boolean bl = this.cbBrowser.isSelected();
        try {
            this.project.getProjectDirectory().setAttribute(PROP_SHOW_IN_BROWSER, (Object)(bl ? null : Boolean.FALSE.toString()));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        Object object = this.comServer.getSelectedItem();
        if (object != null) {
            LogRecord logRecord = new LogRecord(Level.INFO, "USG_PROJECT_CONFIG_MAVEN_SERVER");
            logRecord.setLoggerName("org.netbeans.ui.metrics.maven");
            logRecord.setParameters(new Object[]{object.toString()});
            POHImpl.USG_LOGGER.log(logRecord);
        }
        return this.txtContextPath.getText().trim();
    }

    void applyChanges(String string) {
        assert (!SwingUtilities.isEventDispatchThread());
        SessionContent sessionContent = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        sessionContent.setServerInstanceId(null);
        POHImpl pOHImpl = (POHImpl)((Object)this.project.getLookup().lookup(POHImpl.class));
        pOHImpl.setContextPath(string);
        pOHImpl.hackModuleServerChange();
        this.moduleProvider = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
    }

    private void replaceDependency(String string, String string2) {
        Dependency dependency = ModelUtils.checkModelDependency((POMModel)this.handle.getPOMModel(), (String)"javax", (String)string, (boolean)false);
        if (dependency != null) {
            dependency.setArtifactId(string2);
        }
    }
}

