/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.api.schema;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.e2e.api.schema.Element;
import org.netbeans.modules.e2e.api.schema.SchemaConstruct;
import org.netbeans.modules.e2e.api.schema.SchemaHolder;
import org.netbeans.modules.e2e.api.schema.Type;
import org.netbeans.modules.e2e.api.schema.TypeMapping;

public class TypeMappingRegistry {
    private SchemaHolder schemaHolder;
    private Map<QName, TypeMapping> mappings;

    public TypeMappingRegistry(SchemaHolder schemaHolder) {
        this.schemaHolder = schemaHolder;
        this.mappings = new HashMap<QName, TypeMapping>();
        for (Element e : schemaHolder.getSchemaElements()) {
            this.mapType(e);
        }
    }

    public TypeMapping getType(QName name) {
        return this.mappings.get(name);
    }

    private void mapType(Element e) {
        Type type = e.getType();
        if (3 == type.getFlavor()) {
            this.mappings.put(e.getName(), new TypeMappingImpl(type, e.getMaxOccurs() > 1, e.isNillable()));
        } else if (1 == type.getFlavor()) {
            SchemaConstruct sc;
            if (type.getSubconstructs().size() == 0) {
                System.err.print("void");
            } else if (type.getSubconstructs().size() == 1 && SchemaConstruct.ConstructType.ELEMENT == (sc = type.getSubconstructs().get(0)).getConstructType()) {
                Element sce = (Element)sc;
                if (3 == sce.getType().getFlavor()) {
                    System.err.print(sce.getType().getJavaTypeName());
                } else {
                    System.err.print(sce.getName().getLocalPart());
                }
            }
        }
    }

    private static final class TypeMappingImpl
    implements TypeMapping {
        private String name;
        private boolean array;
        private boolean primitive;
        private boolean nillable;
        private Type type;

        public TypeMappingImpl(Type type, boolean array, boolean nillable) {
            this.type = type;
            this.array = array;
            this.nillable = nillable;
        }
    }
}

