/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.modules.web.beans.impl.model.FieldInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.TypeBindingFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class TypeProductionFilter
extends Filter<Element> {
    private WebBeansModelImplementation myImpl;
    private VariableElement myElement;
    private TypeMirror myType;
    private Map<Element, List<DeclaredType>> myResult;
    private static final Set<String> WRAPPERS = new HashSet<String>();

    private TypeProductionFilter() {
    }

    static TypeProductionFilter get() {
        return new TypeProductionFilter();
    }

    void init(VariableElement variableElement, TypeMirror typeMirror, WebBeansModelImplementation webBeansModelImplementation) {
        this.myElement = variableElement;
        this.myImpl = webBeansModelImplementation;
        this.myType = typeMirror;
        this.myResult = new HashMap<Element, List<DeclaredType>>();
    }

    @Override
    void filter(Set<Element> set) {
        if (this.filterPrimitives(set)) {
            this.fillSimpleResult(set);
            return;
        }
        if (this.filterArray(set)) {
            this.fillSimpleResult(set);
            return;
        }
        TypeBindingFilter typeBindingFilter = TypeBindingFilter.get();
        typeBindingFilter.init(this.getElement(), this.getElementType(), this.getImplementation());
        for (Element element : set) {
            TypeElement typeElement = this.getImplementation().getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
            List<DeclaredType> list = this.getDerived(typeElement);
            for (DeclaredType declaredType : list) {
                TypeMirror typeMirror = null;
                try {
                    if (element.getKind() == ElementKind.FIELD) {
                        typeMirror = this.getImplementation().getHelper().getCompilationController().getTypes().asMemberOf(declaredType, element);
                    } else if (element.getKind() == ElementKind.METHOD) {
                        typeMirror = this.getImplementation().getHelper().getCompilationController().getTypes().asMemberOf(declaredType, element);
                        typeMirror = ((ExecutableType)typeMirror).getReturnType();
                    }
                    if (!typeBindingFilter.isAssignable(typeMirror)) continue;
                    this.addResult(element, declaredType);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    Map<Element, List<DeclaredType>> getResult() {
        return this.myResult;
    }

    private void addResult(Element element, DeclaredType declaredType) {
        List<DeclaredType> list = this.myResult.get(element);
        if (list == null) {
            list = new ArrayList<DeclaredType>(2);
            this.myResult.put(element, list);
        }
        list.add(declaredType);
    }

    private void fillSimpleResult(Set<Element> set) {
        for (Element element : set) {
            TypeElement typeElement = this.getImplementation().getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
            DeclaredType declaredType = (DeclaredType)typeElement.asType();
            this.myResult.put(element, Collections.singletonList(declaredType));
        }
    }

    private List<DeclaredType> getDerived(TypeElement typeElement) {
        if (!this.isGeneric(typeElement)) {
            return Collections.singletonList((DeclaredType)typeElement.asType());
        }
        Set<TypeElement> set = FieldInjectionPointLogic.getImplementors(this.getImplementation(), typeElement);
        ArrayList<DeclaredType> arrayList = new ArrayList<DeclaredType>(set.size());
        for (TypeElement typeElement2 : set) {
            arrayList.add((DeclaredType)typeElement2.asType());
        }
        return arrayList;
    }

    private boolean isGeneric(TypeElement typeElement) {
        return typeElement.getTypeParameters().size() != 0;
    }

    private boolean filterArray(Set<? extends Element> set) {
        if (this.getElementType().getKind() == TypeKind.ARRAY) {
            TypeMirror typeMirror = ((ArrayType)this.getElementType()).getComponentType();
            Iterator<? extends Element> iterator = set.iterator();
            while (iterator.hasNext()) {
                Element element = iterator.next();
                TypeMirror typeMirror2 = null;
                if (element.getKind() == ElementKind.FIELD) {
                    typeMirror2 = element.asType();
                } else if (element.getKind() == ElementKind.METHOD) {
                    typeMirror2 = ((ExecutableElement)element).getReturnType();
                }
                if (typeMirror2 == null) continue;
                if (typeMirror2.getKind() != TypeKind.ARRAY) {
                    iterator.remove();
                    continue;
                }
                if (this.getImplementation().getHelper().getCompilationController().getTypes().isSameType(typeMirror, ((ArrayType)typeMirror2).getComponentType())) continue;
                iterator.remove();
            }
            return true;
        }
        return false;
    }

    private boolean filterPrimitives(Set<? extends Element> set) {
        Object object;
        Object object2;
        PrimitiveType primitiveType = null;
        TypeElement typeElement = null;
        if (this.getElementType().getKind().isPrimitive()) {
            primitiveType = this.getImplementation().getHelper().getCompilationController().getTypes().getPrimitiveType(this.getElementType().getKind());
            typeElement = this.getImplementation().getHelper().getCompilationController().getTypes().boxedClass(primitiveType);
        } else if (this.getElementType().getKind() == TypeKind.DECLARED && (object2 = this.getImplementation().getHelper().getCompilationController().getTypes().asElement(this.getElementType())) instanceof TypeElement && WRAPPERS.contains(object = ((TypeElement)object2).getQualifiedName().toString())) {
            primitiveType = this.getImplementation().getHelper().getCompilationController().getTypes().unboxedType(object2.asType());
            typeElement = (TypeElement)object2;
        }
        if (primitiveType != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (Element)object2.next();
                Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
                TypeMirror typeMirror = null;
                if (object.getKind() == ElementKind.FIELD) {
                    typeMirror = object.asType();
                } else if (object.getKind() == ElementKind.METHOD) {
                    typeMirror = ((ExecutableElement)object).getReturnType();
                }
                if (typeMirror == null || types.isSameType(typeMirror, primitiveType) || types.isSameType(typeMirror, typeElement.asType())) continue;
                object2.remove();
            }
        }
        return primitiveType != null;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    private VariableElement getElement() {
        return this.myElement;
    }

    private TypeMirror getElementType() {
        return this.myType;
    }

    static {
        WRAPPERS.add(Boolean.class.getCanonicalName());
        WRAPPERS.add(Byte.class.getCanonicalName());
        WRAPPERS.add(Character.class.getCanonicalName());
        WRAPPERS.add(Double.class.getCanonicalName());
        WRAPPERS.add(Float.class.getCanonicalName());
        WRAPPERS.add(Integer.class.getCanonicalName());
        WRAPPERS.add(Long.class.getCanonicalName());
        WRAPPERS.add(Short.class.getCanonicalName());
    }
}

