/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.wizard;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BeansXmlIterator
implements TemplateWizard.Iterator {
    private int index;
    private static final String defaultName = "beans";
    private transient WizardDescriptor.Panel[] panels;

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        String string = Templates.getTargetName((WizardDescriptor)templateWizard);
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        FileObject fileObject2 = DDHelper.createBeansXml((Profile)Profile.JAVA_EE_6_FULL, (FileObject)fileObject, (String)string);
        if (fileObject2 != null) {
            return Collections.singleton(DataObject.find((FileObject)fileObject2));
        }
        return Collections.EMPTY_SET;
    }

    public void initialize(TemplateWizard templateWizard) {
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        WizardDescriptor.Panel panel = Templates.createSimpleTargetChooser((Project)project, null);
        this.panels = new WizardDescriptor.Panel[]{panel};
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = BeansXmlIterator.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jComponent = (JComponent)this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = jComponent.getName();
            }
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        Templates.setTargetName((WizardDescriptor)templateWizard, (String)defaultName);
        Templates.setTargetFolder((WizardDescriptor)templateWizard, (FileObject)this.getTargetFolder(project));
    }

    private FileObject getTargetFolder(Project project) {
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            FileObject fileObject = webModule.getWebInf();
            if (fileObject == null) {
                try {
                    fileObject = FileUtil.createFolder((FileObject)webModule.getDocumentBase(), (String)"WEB-INF");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return fileObject;
        }
        EjbJar[] ejbJarArray = EjbJar.getEjbJars((Project)project);
        if (ejbJarArray.length > 0) {
            return ejbJarArray[0].getMetaInf();
        }
        Car[] carArray = Car.getCars((Project)project);
        if (carArray.length > 0) {
            return carArray[0].getMetaInf();
        }
        return project.getProjectDirectory();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(BeansXmlIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public static String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }
}

