/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.modules.project.rake;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeBasedProjectType;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RakeBasedProjectFactorySingleton
implements ProjectFactory {
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final Map<Project, Reference<RakeProjectHelper>> project2Helper;
    private static final Map<RakeProjectHelper, Reference<Project>> helper2Project;
    private static final Map<RakeBasedProjectType, List<Reference<RakeProjectHelper>>> type2Projects;
    private static final Lookup.Result<RakeBasedProjectType> antBasedProjectTypes;
    private static Map<String, RakeBasedProjectType> antBasedProjectTypesByType;
    public static RakeProjectHelperCallback HELPER_CALLBACK;

    private static void antBasedProjectTypesRemoved(Set<RakeBasedProjectType> removed) {
        for (RakeBasedProjectType type : removed) {
            List<Reference<RakeProjectHelper>> projects = type2Projects.get(type);
            if (projects != null) {
                for (Reference<RakeProjectHelper> r : projects) {
                    RakeProjectHelper helper = r.get();
                    if (helper == null) continue;
                    helper.notifyDeleted();
                }
            }
            type2Projects.remove(type);
        }
    }

    private static synchronized RakeBasedProjectType findRakeBasedProjectType(String type) {
        if (antBasedProjectTypesByType == null) {
            antBasedProjectTypesByType = new HashMap<String, RakeBasedProjectType>();
            for (RakeBasedProjectType abpt : antBasedProjectTypes.allInstances()) {
                antBasedProjectTypesByType.put(abpt.getType(), abpt);
            }
        }
        return antBasedProjectTypesByType.get(type);
    }

    public boolean isProject(FileObject dir) {
        File dirF = FileUtil.toFile((FileObject)dir);
        if (dirF == null) {
            return false;
        }
        File projectXmlF = new File(new File(dirF, "nbproject"), "project.xml");
        return projectXmlF.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
        Document projectXml;
        if (FileUtil.toFile((FileObject)projectDirectory) == null) {
            return null;
        }
        FileObject projectFile = projectDirectory.getFileObject(PROJECT_XML_PATH);
        if (projectFile == null || !projectFile.isData() || projectFile.isVirtual()) {
            return null;
        }
        File projectDiskFile = FileUtil.toFile((FileObject)projectFile);
        if (projectDiskFile == null) {
            return null;
        }
        try {
            projectXml = XMLUtil.parse((InputSource)new InputSource(projectDiskFile.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (SAXException e) {
            IOException ioe = (IOException)new IOException(projectDiskFile + ": " + e.toString()).initCause(e);
            Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(RakeBasedProjectFactorySingleton.class, (String)"RakeBasedProjectFactorySingleton.parseError", (Object)projectDiskFile.getAbsolutePath(), (Object)e.getMessage()));
            throw ioe;
        }
        Element projectEl = projectXml.getDocumentElement();
        if (!"project".equals(projectEl.getLocalName()) || !PROJECT_NS.equals(projectEl.getNamespaceURI())) {
            return null;
        }
        Element typeEl = XMLUtil.findElement((Element)projectEl, (String)"type", (String)PROJECT_NS);
        if (typeEl == null) {
            return null;
        }
        String type = XMLUtil.findText((Node)typeEl);
        if (type == null) {
            return null;
        }
        RakeBasedProjectType provider = RakeBasedProjectFactorySingleton.findRakeBasedProjectType(type);
        if (provider == null) {
            return null;
        }
        RakeProjectHelper helper = HELPER_CALLBACK.createHelper(projectDirectory, projectXml, state, provider);
        Project project = provider.createProject(helper);
        project2Helper.put(project, new WeakReference<RakeProjectHelper>(helper));
        Map<RakeProjectHelper, Reference<Project>> map = helper2Project;
        synchronized (map) {
            helper2Project.put(helper, new WeakReference<Project>(project));
        }
        List<Reference<RakeProjectHelper>> l = type2Projects.get(provider);
        if (l == null) {
            l = new ArrayList<Reference<RakeProjectHelper>>();
            type2Projects.put(provider, l);
        }
        l.add(new WeakReference<RakeProjectHelper>(helper));
        return project;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        Reference<RakeProjectHelper> helperRef = project2Helper.get(project);
        if (helperRef == null) {
            throw new ClassCastException(project.getClass().getName());
        }
        RakeProjectHelper helper = helperRef.get();
        assert (helper != null) : "RakeProjectHelper collected for " + project;
        HELPER_CALLBACK.save(helper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project getProjectFor(RakeProjectHelper helper) {
        Reference<Project> projectRef;
        Map<RakeProjectHelper, Reference<Project>> map = helper2Project;
        synchronized (map) {
            projectRef = helper2Project.get(helper);
        }
        assert (projectRef != null) : "Expecting a Project reference for " + helper;
        Project p = projectRef.get();
        assert (p != null) : "Expecting a non-null Project for " + helper;
        return p;
    }

    public static RakeProjectHelper getHelperFor(Project p) {
        Reference<RakeProjectHelper> helperRef = project2Helper.get(p);
        return helperRef != null ? helperRef.get() : null;
    }

    static {
        block3: {
            project2Helper = new WeakHashMap<Project, Reference<RakeProjectHelper>>();
            helper2Project = new WeakHashMap<RakeProjectHelper, Reference<Project>>();
            type2Projects = new HashMap<RakeBasedProjectType, List<Reference<RakeProjectHelper>>>();
            antBasedProjectTypesByType = null;
            antBasedProjectTypes = Lookup.getDefault().lookupResult(RakeBasedProjectType.class);
            antBasedProjectTypes.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent ev) {
                    Class<RakeBasedProjectFactorySingleton> clazz = RakeBasedProjectFactorySingleton.class;
                    synchronized (RakeBasedProjectFactorySingleton.class) {
                        Set oldTypes = type2Projects.keySet();
                        HashSet removed = new HashSet(oldTypes);
                        removed.removeAll(antBasedProjectTypes.allInstances());
                        RakeBasedProjectFactorySingleton.antBasedProjectTypesRemoved(removed);
                        antBasedProjectTypesByType = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            Class<RakeProjectHelper> c = RakeProjectHelper.class;
            try {
                Class.forName(c.getName(), true, c.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
        assert (HELPER_CALLBACK != null);
    }

    public static interface RakeProjectHelperCallback {
        public RakeProjectHelper createHelper(FileObject var1, Document var2, ProjectState var3, RakeBasedProjectType var4);

        public void save(RakeProjectHelper var1) throws IOException;
    }
}

