/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.annotations.common.CheckForNull;

public class AstPath
implements Iterable<Node> {
    private ArrayList<Node> path = new ArrayList(30);

    public AstPath() {
    }

    public AstPath(AstPath other) {
        this.path.addAll(other.path);
    }

    public AstPath(ArrayList<Node> path) {
        this.path = path;
    }

    public AstPath(Node root, int caretOffset) {
        this.findPathTo(root, caretOffset);
    }

    public AstPath(Node node, Node target) {
        if (!this.find(node, target)) {
            this.path.clear();
        } else {
            Collections.reverse(this.path);
        }
    }

    public void descend(Node node) {
        this.path.add(node);
    }

    public void ascend() {
        this.path.remove(this.path.size() - 1);
    }

    public boolean contains(NodeType nodeType) {
        int n = this.path.size();
        for (int i = 0; i < n; ++i) {
            if (this.path.get(i).getNodeType() != nodeType) continue;
            return true;
        }
        return false;
    }

    public Node findPathTo(Node node, int offset) {
        Node result = this.find(node, offset);
        if (result != null) {
            this.path.add(node);
            Collections.reverse(this.path);
        }
        return result;
    }

    private Node find(Node node, int offset) {
        if (node.isInvisible()) {
            return null;
        }
        SourcePosition pos = node.getPosition();
        int begin = pos.getStartOffset();
        int end = pos.getEndOffset();
        if (offset >= begin && offset <= end) {
            List children = node.childNodes();
            for (Node child : children) {
                Node found;
                if (child.isInvisible() || (found = this.find(child, offset)) == null) continue;
                this.path.add(child);
                return found;
            }
            return node;
        }
        List children = node.childNodes();
        if (children == null) {
            Logger logger = Logger.getLogger(AstPath.class.getName());
            logger.log(Level.WARNING, "JRuby AST node " + node + " of type " + node.getClass().getName() + " has null as children");
        }
        for (Node child : children) {
            Node found;
            if (child == null) {
                Logger logger = Logger.getLogger(AstPath.class.getName());
                logger.log(Level.WARNING, "JRuby AST node " + node + " of type " + node.getClass().getName() + " has a null child");
                continue;
            }
            if (child.isInvisible() || (found = this.find(child, offset)) == null) continue;
            this.path.add(child);
            return found;
        }
        return null;
    }

    public boolean find(Node node, Node target) {
        if (node == target) {
            return true;
        }
        List children = node.childNodes();
        for (Node child : children) {
            boolean found;
            if (child.isInvisible() || !(found = this.find(child, target))) continue;
            this.path.add(child);
            return found;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Path(");
        sb.append(this.path.size());
        sb.append(")=[");
        for (Node n : this.path) {
            String name = n.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            sb.append(name);
            sb.append(":");
        }
        sb.append("]");
        return sb.toString();
    }

    @CheckForNull
    public Node leaf() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(this.path.size() - 1);
    }

    public Node leafParent() {
        if (this.path.size() < 2) {
            return null;
        }
        return this.path.get(this.path.size() - 2);
    }

    public Node leafGrandParent() {
        if (this.path.size() < 3) {
            return null;
        }
        return this.path.get(this.path.size() - 3);
    }

    public Node root() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(0);
    }

    @Override
    public Iterator<Node> iterator() {
        return new LeafToRootIterator(this.path);
    }

    public ListIterator<Node> rootToLeaf() {
        return this.path.listIterator();
    }

    public ListIterator<Node> leafToRoot() {
        return new LeafToRootIterator(this.path);
    }

    private static class LeafToRootIterator
    implements ListIterator<Node> {
        private final ListIterator<Node> it;

        private LeafToRootIterator(ArrayList<Node> path) {
            this.it = path.listIterator(path.size());
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public Node next() {
            return this.it.previous();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public Node previous() {
            return this.it.next();
        }

        @Override
        public int nextIndex() {
            return this.it.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.nextIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void set(Node arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void add(Node arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

