/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ruby.RubyUtils;

public final class RubyType {
    private static final Logger LOGGER = Logger.getLogger(RubyType.class.getName());
    public static final RubyType ARRAY = new RubyType("Array");
    public static final RubyType BIGNUM = new RubyType("Bignum");
    public static final RubyType FALSE_CLASS = new RubyType("FalseClass");
    public static final RubyType FIXNUM = new RubyType("Fixnum");
    public static final RubyType FLOAT = new RubyType("Float");
    public static final RubyType HASH = new RubyType("Hash");
    public static final RubyType NIL_CLASS = new RubyType("NilClass");
    public static final RubyType OBJECT = new RubyType("Object");
    public static final RubyType RANGE = new RubyType("Range");
    public static final RubyType REGEXP = new RubyType("Regexp");
    public static final RubyType STRING = new RubyType("String");
    public static final RubyType SYMBOL = new RubyType("Symbol");
    public static final RubyType TRUE_CLASS = new RubyType("TrueClass");
    public static final RubyType INTEGER = new RubyType("Integer");
    public static final RubyType DATE = new RubyType("Date");
    public static final RubyType TIME = new RubyType("Time");
    private Set<String> realTypes;
    private boolean hasUnknownMember;
    private static final RubyType UNKNOWN = new RubyType();
    public static final RubyType BOOLEAN;
    private static final Map<String, RubyType> CORE_TYPES;

    public static RubyType create(String realType) {
        RubyType.checkType(realType);
        RubyType coreType = CORE_TYPES.get(realType);
        return coreType == null ? new RubyType(realType) : coreType;
    }

    public static RubyType unknown() {
        return UNKNOWN;
    }

    public RubyType() {
        this.realTypes = new LinkedHashSet<String>();
    }

    public RubyType(RubyType ... types) {
        this.realTypes = new LinkedHashSet<String>();
        for (RubyType rubyType : types) {
            this.append(rubyType);
        }
    }

    public RubyType(String ... types) {
        this(Arrays.asList(types));
    }

    public RubyType(Collection<String> types) {
        assert (!types.contains(null)) : "cannot add arrays with null realType member";
        this.realTypes = new LinkedHashSet<String>(types);
    }

    private RubyType(String realType) {
        assert (realType != null) : "cannot add null realType";
        RubyType.checkType(realType);
        this.realTypes = new LinkedHashSet<String>(Collections.singleton(realType));
    }

    public Set<String> getRealTypes() {
        return Collections.unmodifiableSet(this.realTypes);
    }

    public String first() {
        return this.getRealTypes().iterator().next();
    }

    void append(RubyType type) {
        assert (!type.realTypes.contains(null)) : "cannot add arrays with null realType member";
        if (type.isKnown()) {
            this.realTypes.addAll(type.realTypes);
        }
        if (type.hasUnknownMember()) {
            this.hasUnknownMember = true;
        }
    }

    void add(String realType) {
        assert (realType != null) : "cannot add null realType";
        RubyType.checkType(realType);
        this.realTypes.add(realType);
    }

    private static void checkType(String realType) {
        if (LOGGER.isLoggable(Level.FINE) && (realType.length() == 0 || Character.isLowerCase(realType.charAt(0)))) {
            LOGGER.log(Level.FINE, "Likely not a valid type {0}", realType);
        }
    }

    public boolean isSingleton() {
        return this.isKnown() && this.realTypes.size() == 1;
    }

    public boolean isKnown() {
        return !this.realTypes.isEmpty();
    }

    boolean hasUnknownMember() {
        return this.hasUnknownMember;
    }

    String asIndexedString() {
        return this.asString("|");
    }

    String asString(String delimiter) {
        return RubyUtils.join(this.realTypes, delimiter);
    }

    String asString(String delimiter, String lastDelimiter) {
        return RubyUtils.join(this.realTypes, delimiter, lastDelimiter);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyType other = (RubyType)obj;
        if (!(this.realTypes == other.realTypes || this.realTypes != null && ((Object)this.realTypes).equals(other.realTypes))) {
            return false;
        }
        return this.hasUnknownMember == other.hasUnknownMember;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.realTypes != null ? ((Object)this.realTypes).hashCode() : 0);
        hash = 97 * hash + (this.hasUnknownMember ? 1 : 0);
        return hash;
    }

    public String toString() {
        return "RubyType[realTypes:" + this.realTypes + ", hasUnknownMember: " + this.hasUnknownMember + ']';
    }

    static {
        RubyType.UNKNOWN.hasUnknownMember = true;
        BOOLEAN = new RubyType(TRUE_CLASS, FALSE_CLASS);
        CORE_TYPES = new HashMap<String, RubyType>(16);
        CORE_TYPES.put(ARRAY.first(), ARRAY);
        CORE_TYPES.put(BIGNUM.first(), BIGNUM);
        CORE_TYPES.put(FALSE_CLASS.first(), FALSE_CLASS);
        CORE_TYPES.put(FIXNUM.first(), FIXNUM);
        CORE_TYPES.put(FLOAT.first(), FLOAT);
        CORE_TYPES.put(HASH.first(), HASH);
        CORE_TYPES.put(NIL_CLASS.first(), NIL_CLASS);
        CORE_TYPES.put(OBJECT.first(), OBJECT);
        CORE_TYPES.put(RANGE.first(), RANGE);
        CORE_TYPES.put(REGEXP.first(), REGEXP);
        CORE_TYPES.put(STRING.first(), STRING);
        CORE_TYPES.put(SYMBOL.first(), SYMBOL);
        CORE_TYPES.put(TRUE_CLASS.first(), TRUE_CLASS);
    }
}

