/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;

final class TestNameResolver {
    private static final String SHOULDA_METHOD = "should";
    private static final String RSPEC_DESCRIBE = "describe";
    private static final String[] TEST_METHOD_NAMES = new String[]{"test", "describe", "specify", "context", "should", "it", "before", "after"};

    TestNameResolver() {
    }

    static boolean isTestMethodName(String name) {
        for (String each : TEST_METHOD_NAMES) {
            if (!each.equals(name)) continue;
            return true;
        }
        return false;
    }

    static boolean isRspecDescribe(String name) {
        return RSPEC_DESCRIBE.equals(name);
    }

    static boolean isShouldaMethod(String name) {
        return SHOULDA_METHOD.equals(name);
    }

    static String getTestName(AstPath path) {
        ListIterator<Node> it = path.leafToRoot();
        ArrayList<String> shouldaMethodName = new ArrayList<String>();
        boolean appendClassName = true;
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.getNodeType() == NodeType.FCALLNODE) {
                String desc;
                FCallNode fc = (FCallNode)node;
                if ("test".equals(fc.getName())) {
                    desc = TestNameResolver.getNodeDesc(fc);
                    if (desc != null) {
                        return "test_" + desc.replace(' ', '_');
                    }
                    return null;
                }
                if (SHOULDA_METHOD.equals(fc.getName())) {
                    TestNameResolver.buildShouldaMethod(" should " + TestNameResolver.getNodeDesc(fc), shouldaMethodName, false);
                    continue;
                }
                if (!"context".equals(fc.getName())) continue;
                desc = TestNameResolver.getNodeDesc(fc);
                if (desc != null) {
                    appendClassName = false;
                }
                TestNameResolver.buildShouldaMethod(desc, shouldaMethodName, true);
                continue;
            }
            if (node.getNodeType() == NodeType.CLASSNODE && appendClassName) {
                String className = TestNameResolver.getClassNameForShoulda((IScopingNode)node);
                TestNameResolver.buildShouldaMethod(className, shouldaMethodName, false);
                continue;
            }
            if (node.getNodeType() != NodeType.DEFNNODE && node.getNodeType() != NodeType.DEFSNODE) continue;
            return AstUtilities.getName(node);
        }
        if (!shouldaMethodName.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String each : shouldaMethodName) {
                sb.append(each);
            }
            return TestNameResolver.removeLeadingWhiteSpace(sb.toString());
        }
        return null;
    }

    private static String getNodeDesc(FCallNode fc) {
        if (fc.getIterNode() == null) {
            return null;
        }
        Node argsNode = fc.getArgsNode();
        if (argsNode instanceof ListNode) {
            ListNode args = (ListNode)argsNode;
            int max = args.size();
            for (int i = 0; i < max; ++i) {
                Node n = args.get(i);
                if (!(n instanceof StrNode)) continue;
                String descBl = ((StrNode)n).getValue();
                if (descBl == null || descBl.length() <= 0) break;
                return descBl.toString();
            }
        }
        return null;
    }

    private static void buildShouldaMethod(String desc, List<String> shouldaMethodName, boolean trim) {
        if (desc == null) {
            return;
        }
        if (trim) {
            desc = desc.trim();
        }
        if (shouldaMethodName.isEmpty()) {
            shouldaMethodName.add(desc);
        } else {
            shouldaMethodName.add(0, " " + desc);
        }
    }

    private static String getClassNameForShoulda(IScopingNode classNode) {
        String testClassName = AstUtilities.getClassOrModuleName(classNode);
        if (testClassName != null && testClassName.indexOf("Test") != -1) {
            return testClassName.substring(0, testClassName.indexOf("Test"));
        }
        return null;
    }

    private static String removeLeadingWhiteSpace(String str) {
        if (str.startsWith(" ")) {
            return str.substring(1);
        }
        return str;
    }
}

