/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.aspect.ProfileErrorReporterAspect;
import org.apache.maven.realm.DefaultMavenRealmManager;
import org.apache.maven.realm.MavenRealmManager;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;

public class DefaultProfileManager
implements ProfileManager {
    private PlexusContainer container;
    private Map profilesById = new LinkedHashMap();
    private ProfileActivationContext profileActivationContext;
    static /* synthetic */ Class class$0;

    public DefaultProfileManager(PlexusContainer container, ProfileActivationContext profileActivationContext) {
        this.container = container;
        this.profileActivationContext = profileActivationContext == null ? this.createDefaultActivationContext() : profileActivationContext;
    }

    public DefaultProfileManager(PlexusContainer container) {
        this.container = container;
        this.profileActivationContext = this.createDefaultActivationContext();
    }

    private ProfileActivationContext createDefaultActivationContext() {
        Logger logger = this.container.getLoggerManager().getLoggerForComponent(DefaultProfileManager.class.getName());
        DefaultMavenRealmManager manager = new DefaultMavenRealmManager(this.container, logger);
        return new DefaultProfileActivationContext(manager, System.getProperties(), false);
    }

    public ProfileActivationContext getProfileActivationContext() {
        return this.profileActivationContext;
    }

    public void setProfileActivationContext(ProfileActivationContext profileActivationContext) {
        this.profileActivationContext = profileActivationContext;
    }

    public Map getProfilesById() {
        return this.profilesById;
    }

    public void addProfile(Profile profile) {
        String profileId = profile.getId();
        Profile existing = (Profile)this.profilesById.get(profileId);
        if (existing != null) {
            this.container.getLogger().warn("Overriding profile: '" + profileId + "' (source: " + existing.getSource() + ") with new instance from source: " + profile.getSource());
        }
        this.profilesById.put(profile.getId(), profile);
        Activation activation = profile.getActivation();
        if (activation != null && activation.isActiveByDefault()) {
            this.activateAsDefault(profileId);
        }
    }

    public void explicitlyActivate(String profileId) {
        List activatedIds = this.profileActivationContext.getExplicitlyActiveProfileIds();
        if (!activatedIds.contains(profileId)) {
            this.container.getLogger().debug("Profile with id: '" + profileId + "' has been explicitly activated.");
            this.profileActivationContext.setActive(profileId);
        }
    }

    public void explicitlyActivate(List profileIds) {
        for (String profileId : profileIds) {
            this.explicitlyActivate(profileId);
        }
    }

    public void explicitlyDeactivate(String profileId) {
        List deactivatedIds = this.profileActivationContext.getExplicitlyInactiveProfileIds();
        if (!deactivatedIds.contains(profileId)) {
            this.container.getLogger().debug("Profile with id: '" + profileId + "' has been explicitly deactivated.");
            this.profileActivationContext.setInactive(profileId);
        }
    }

    public void explicitlyDeactivate(List profileIds) {
        for (String profileId : profileIds) {
            this.explicitlyDeactivate(profileId);
        }
    }

    public List getActiveProfiles() throws ProfileActivationException {
        return this.getActiveProfiles(null);
    }

    public List getActiveProfiles(Model model) throws ProfileActivationException {
        ArrayList<Profile> arrayList;
        block11: {
            MavenRealmManager realmManager = this.profileActivationContext.getRealmManager();
            ClassRealm projectRealm = null;
            ClassRealm oldLookupRealm = null;
            if (model != null && realmManager != null) {
                projectRealm = realmManager.getProjectRealm(ModelUtils.getGroupId(model), model.getArtifactId(), ModelUtils.getVersion(model));
                oldLookupRealm = this.container.setLookupRealm(projectRealm);
            }
            try {
                ArrayList<Profile> activeFromPom = new ArrayList<Profile>();
                ArrayList<Profile> activeExternal = new ArrayList<Profile>();
                for (Map.Entry entry : this.profilesById.entrySet()) {
                    String profileId = (String)entry.getKey();
                    Profile profile = (Profile)entry.getValue();
                    boolean shouldAdd = false;
                    if (this.profileActivationContext.isExplicitlyActive(profileId)) {
                        shouldAdd = true;
                    } else if (this.isActive(profile, this.profileActivationContext)) {
                        shouldAdd = true;
                    }
                    if (this.profileActivationContext.isExplicitlyInactive(profileId) || !shouldAdd) continue;
                    if ("pom".equals(profile.getSource())) {
                        activeFromPom.add(profile);
                        continue;
                    }
                    activeExternal.add(profile);
                }
                if (activeFromPom.isEmpty()) {
                    List defaultIds = this.profileActivationContext.getActiveByDefaultProfileIds();
                    List deactivatedIds = this.profileActivationContext.getExplicitlyInactiveProfileIds();
                    for (String profileId : defaultIds) {
                        Profile profile;
                        if (deactivatedIds.contains(profileId) || (profile = (Profile)this.profilesById.get(profileId)) == null) continue;
                        activeFromPom.add(profile);
                    }
                }
                ArrayList<Profile> allActive = new ArrayList<Profile>(activeFromPom.size() + activeExternal.size());
                allActive.addAll(activeExternal);
                allActive.addAll(activeFromPom);
                arrayList = allActive;
                if (projectRealm == null) break block11;
                this.container.setLookupRealm(oldLookupRealm);
            }
            catch (Throwable throwable) {
                if (projectRealm != null) {
                    this.container.setLookupRealm(oldLookupRealm);
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isActive(Profile profile, ProfileActivationContext profileActivationContext) throws ProfileActivationException {
        boolean bl;
        block39: {
            Profile profile2 = profile;
            ProfileActivationContext profileActivationContext2 = profileActivationContext;
            Object[] objectArray = new Object[]{profile2, profileActivationContext2};
            ProfileErrorReporterAspect.ajc$cflowStack$1.push(objectArray);
            try {
                List activators = null;
                try {
                    List list;
                    try {
                        try {
                            list = this.container.lookupList(ProfileActivator.ROLE);
                        }
                        catch (ComponentLookupException componentLookupException) {
                            if (ProfileErrorReporterAspect.ajc$cflowStack$0.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$1.isValid()) {
                                ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$1$46f353ab((Model)ProfileErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$0.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), componentLookupException);
                            }
                            throw componentLookupException;
                        }
                    }
                    catch (ComponentLookupException componentLookupException) {
                        if (ProfileErrorReporterAspect.ajc$cflowStack$1.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$2.isValid()) {
                            ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$2$7c22a6df((Model)ProfileErrorReporterAspect.ajc$cflowStack$2.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$2.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), componentLookupException);
                        }
                        throw componentLookupException;
                    }
                    activators = list;
                    for (ProfileActivator activator : activators) {
                        boolean bl2;
                        boolean bl3;
                        void profile3;
                        void context;
                        void var11_12 = context;
                        void var12_13 = profile3;
                        ProfileActivator profileActivator = activator;
                        try {
                            try {
                                bl3 = profileActivator.canDetermineActivation((Profile)var12_13, (ProfileActivationContext)var11_12);
                            }
                            catch (ProfileActivationException profileActivationException) {
                                if (ProfileErrorReporterAspect.ajc$cflowStack$0.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$1.isValid()) {
                                    ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$3$b080968d(profileActivator, (Model)ProfileErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$0.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), profileActivationException);
                                }
                                throw profileActivationException;
                            }
                        }
                        catch (ProfileActivationException profileActivationException) {
                            if (ProfileErrorReporterAspect.ajc$cflowStack$1.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$2.isValid()) {
                                ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$6$bfa62bd7(profileActivator, (Model)ProfileErrorReporterAspect.ajc$cflowStack$2.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$2.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), profileActivationException);
                            }
                            throw profileActivationException;
                        }
                        if (!bl3) continue;
                        void var16_15 = context;
                        void var17_16 = profile3;
                        ProfileActivator profileActivator2 = activator;
                        try {
                            try {
                                bl2 = profileActivator2.isActive((Profile)var17_16, (ProfileActivationContext)var16_15);
                            }
                            catch (ProfileActivationException profileActivationException) {
                                if (ProfileErrorReporterAspect.ajc$cflowStack$0.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$1.isValid()) {
                                    ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$3$b080968d(profileActivator2, (Model)ProfileErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$0.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), profileActivationException);
                                }
                                throw profileActivationException;
                            }
                        }
                        catch (ProfileActivationException profileActivationException) {
                            if (ProfileErrorReporterAspect.ajc$cflowStack$1.isValid() && ProfileErrorReporterAspect.ajc$cflowStack$2.isValid()) {
                                ProfileErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_ProfileErrorReporterAspect$6$bfa62bd7(profileActivator2, (Model)ProfileErrorReporterAspect.ajc$cflowStack$2.get(0), (File)ProfileErrorReporterAspect.ajc$cflowStack$2.get(1), (Profile)ProfileErrorReporterAspect.ajc$cflowStack$1.get(0), (ProfileActivationContext)ProfileErrorReporterAspect.ajc$cflowStack$1.get(1), profileActivationException);
                            }
                            throw profileActivationException;
                        }
                        if (!bl2) continue;
                        this.container.getLogger().debug("Profile: " + profile3.getId() + " is active. (source: " + profile3.getSource() + ")");
                        bl = true;
                        break block39;
                    }
                    bl = false;
                    break block39;
                }
                catch (ComponentLookupException e) {
                    throw new ProfileActivationException("Cannot retrieve list of profile activators.", e);
                }
                {
                    finally {
                        this.container.getContext().put("SystemProperties", null);
                        if (activators != null) {
                            try {
                                this.container.releaseAll(activators);
                            }
                            catch (ComponentLifecycleException e) {
                                this.container.getLogger().debug("Error releasing profile activators - ignoring.", e);
                            }
                        }
                    }
                }
            }
            finally {
                ProfileErrorReporterAspect.ajc$cflowStack$1.pop();
            }
        }
        return bl;
    }

    public void addProfiles(List profiles) {
        for (Profile profile : profiles) {
            this.addProfile(profile);
        }
    }

    public void activateAsDefault(String profileId) {
        List defaultIds = this.profileActivationContext.getActiveByDefaultProfileIds();
        if (!defaultIds.contains(profileId)) {
            this.profileActivationContext.setActiveByDefault(profileId);
        }
    }

    public List getExplicitlyActivatedIds() {
        return this.profileActivationContext.getExplicitlyActiveProfileIds();
    }

    public List getExplicitlyDeactivatedIds() {
        return this.profileActivationContext.getExplicitlyInactiveProfileIds();
    }

    public List getIdsActivatedByDefault() {
        return this.profileActivationContext.getActiveByDefaultProfileIds();
    }
}

