/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.project.MissingRepositoryElementException;
import org.codehaus.plexus.PlexusContainer;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static List buildArtifactRepositories(List repositories, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws InvalidRepositoryException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        for (Repository mavenRepo : repositories) {
            ArtifactRepository artifactRepo = ProjectUtils.buildArtifactRepository(mavenRepo, artifactRepositoryFactory, container);
            if (repos.contains(artifactRepo)) continue;
            repos.add(artifactRepo);
        }
        return repos;
    }

    public static ArtifactRepository buildDeploymentArtifactRepository(DeploymentRepository repo, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            return artifactRepositoryFactory.createDeploymentArtifactRepository(id, url, repo.getLayout(), repo.isUniqueVersion());
        }
        return null;
    }

    public static ArtifactRepository buildArtifactRepository(Repository repo, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            if (id == null || id.trim().length() < 1) {
                throw new MissingRepositoryElementException("Repository ID must not be empty (URL is: " + url + ").");
            }
            if (url == null || url.trim().length() < 1) {
                throw new MissingRepositoryElementException("Repository URL must not be empty (ID is: " + id + ").", id);
            }
            ArtifactRepositoryPolicy snapshots = ProjectUtils.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = ProjectUtils.buildArtifactRepositoryPolicy(repo.getReleases());
            return artifactRepositoryFactory.createArtifactRepository(id, url, repo.getLayout(), snapshots, releases);
        }
        return null;
    }

    private static ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }
}

