/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.classdetector;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.openide.filesystems.FileObject;

public class TypeFinder
implements CancellableTask<CompilationController> {
    private volatile boolean cancelled;
    private final ClassPath classpath;
    private final String fqn;
    private Callback callback;
    private final Logger LOG = Logger.getLogger(TypeFinder.class.getName());

    public TypeFinder(String string, ClassPath classPath) {
        this.classpath = classPath;
        this.fqn = string;
        this.LOG.log(Level.FINER, "Create a TypeFinder for {0} on {1}", new Object[]{string, classPath});
    }

    public void findTypes(Callback callback) {
        assert (!EventQueue.isDispatchThread());
        this.callback = callback;
        for (FileObject fileObject : this.classpath.getRoots()) {
            this.LOG.log(Level.FINER, "Scan {0} for {1}", new Object[]{fileObject, this.fqn});
            this.analyze(fileObject);
        }
    }

    private void analyze(FileObject fileObject) {
        block4: {
            block3: {
                this.LOG.log(Level.FINEST, "Analyze {0}", new Object[]{fileObject});
                if (!fileObject.isFolder()) break block3;
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    this.analyze(fileObject2);
                }
                break block4;
            }
            if (!"text/x-java".equals(fileObject.getMIMEType())) break block4;
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            try {
                this.LOG.log(Level.FINEST, "Check java source {0}", new Object[]{fileObject});
                javaSource.runUserActionTask((Task)this, true);
            }
            catch (IOException iOException) {
                Logger.getLogger(TypeFinder.class.getName()).log(Level.INFO, "Problem scanning " + fileObject.getPath(), iOException);
            }
        }
    }

    public void reset() {
        this.cancelled = false;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationController compilationController) throws Exception {
        if (this.cancelled) {
            return;
        }
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        if (this.cancelled) {
            return;
        }
        List<? extends Tree> list = compilationController.getCompilationUnit().getTypeDecls();
        for (Tree tree : list) {
            if (this.cancelled) {
                return;
            }
            TypeMirror typeMirror = compilationController.getTrees().getTypeMirror(TreePath.getPath(compilationController.getCompilationUnit(), tree));
            this.LOG.log(Level.FINEST, "Check type {0}", typeMirror);
            if (!(tree instanceof ClassTree) || !this.match(typeMirror, compilationController.getTypes())) continue;
            this.callback.foundFileObject(compilationController.getFileObject(), ((Object)typeMirror).toString());
        }
    }

    boolean match(Trees trees, Types types, CompilationUnitTree compilationUnitTree, Tree tree) {
        TypeMirror typeMirror = trees.getTypeMirror(TreePath.getPath(compilationUnitTree, tree));
        return this.match(typeMirror, types);
    }

    boolean match(TypeMirror typeMirror, Types types) {
        boolean bl = false;
        if (typeMirror != null && !"java.lang.Object".equals(((Object)typeMirror).toString()) && !(bl = this.fqn.equals(((Object)typeMirror).toString()))) {
            List<? extends TypeMirror> list = types.directSupertypes(typeMirror);
            for (TypeMirror typeMirror2 : list) {
                bl = this.match(typeMirror2, types);
                if (this.cancelled) {
                    return bl;
                }
                if (!bl) continue;
                break;
            }
        }
        this.LOG.log(Level.FINEST, "Match {0}? ", new Object[]{typeMirror, bl});
        return bl;
    }

    public static interface Callback {
        public void foundFileObject(FileObject var1, String var2);
    }
}

