/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndAbstractTokenProcessor;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public class BracketCompletion {
    static void charInserted(BaseDocument doc, int dotPos, Caret caret, char ch, boolean blockCommentStart) throws BadLocationException {
        if (!BracketCompletion.completionSettingEnabled((Document)doc)) {
            return;
        }
        TokenItem tokenAtDot = CndTokenUtilities.getToken((Document)doc, (int)dotPos, (boolean)true);
        if (tokenAtDot == null) {
            return;
        }
        if (ch == ')' || ch == ']' || ch == '(' || ch == '[') {
            switch ((CppTokenId)tokenAtDot.id()) {
                case RBRACKET: 
                case RPAREN: {
                    BracketCompletion.skipClosingBracket(doc, caret, ch);
                    break;
                }
                case LBRACKET: 
                case LPAREN: {
                    BracketCompletion.completeOpeningBracket(doc, dotPos, caret, ch);
                }
            }
        } else if (ch == '\"' || ch == '\'') {
            BracketCompletion.completeQuote(doc, dotPos, caret, ch);
        } else if (ch == ';') {
            BracketCompletion.moveSemicolon(doc, dotPos, caret);
        } else if (ch == '<') {
            if (tokenAtDot.id() == CppTokenId.PREPROCESSOR_SYS_INCLUDE && tokenAtDot.partType() == PartType.START) {
                BracketCompletion.completeOpeningBracket(doc, dotPos, caret, ch);
            }
        } else if (ch == '>') {
            char[] match;
            if (tokenAtDot.id() == CppTokenId.PREPROCESSOR_SYS_INCLUDE && (match = doc.getChars(dotPos + 1, 1)) != null && match[0] == '>') {
                doc.remove(dotPos + 1, 1);
            }
        } else if (ch == '.') {
            if (dotPos > 0 && (tokenAtDot = CndTokenUtilities.getToken((Document)doc, (int)(dotPos - 1), (boolean)true)).id() == CppTokenId.THIS) {
                doc.remove(dotPos, 1);
                doc.insertString(dotPos, "->", null);
                caret.setDot(dotPos + 2);
            }
        } else if (ch == '*' && blockCommentStart && tokenAtDot.id() == CppTokenId.BLOCK_COMMENT) {
            doc.insertString(dotPos + 1, "*/", null);
            caret.setDot(dotPos + 1);
        }
    }

    private static void moveSemicolon(BaseDocument doc, int dotPos, Caret caret) throws BadLocationException {
        int eolPos = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
        TokenSequence cppTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)dotPos, (boolean)true, (boolean)false);
        if (cppTokenSequence == null) {
            return;
        }
        int lastParenPos = dotPos;
        while (cppTokenSequence.moveNext() && cppTokenSequence.offset() < eolPos) {
            Token token = cppTokenSequence.token();
            if (token.id() == CppTokenId.RPAREN) {
                lastParenPos = cppTokenSequence.offset();
                continue;
            }
            if ("whitespace".equals(((CppTokenId)token.id()).primaryCategory())) continue;
            return;
        }
        if (BracketCompletion.posWithinAnyQuote(doc, dotPos) || BracketCompletion.isForLoopSemicolon(doc, dotPos)) {
            return;
        }
        doc.remove(dotPos, 1);
        doc.insertString(lastParenPos, ";", null);
        caret.setDot(lastParenPos + 1);
    }

    private static boolean isForLoopSemicolon(BaseDocument doc, int dotPos) {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)dotPos, (boolean)true, (boolean)false);
        if (ts == null || ts.token().id() != CppTokenId.SEMICOLON) {
            return false;
        }
        int parDepth = 0;
        int braceDepth = 0;
        boolean semicolonFound = false;
        while (ts.movePrevious()) {
            Token token = ts.token();
            if (token.id() == CppTokenId.LPAREN) {
                if (parDepth == 0) {
                    String category;
                    while (ts.movePrevious() && ("whitespace".equals(category = ((CppTokenId)(token = ts.token()).id()).primaryCategory()) || "comment".equals(category))) {
                    }
                    return token.id() == CppTokenId.FOR;
                }
                --parDepth;
                continue;
            }
            if (token.id() == CppTokenId.RPAREN) {
                ++parDepth;
                continue;
            }
            if (token.id() == CppTokenId.LBRACE) {
                if (braceDepth == 0) {
                    return false;
                }
                --braceDepth;
                continue;
            }
            if (token.id() == CppTokenId.RBRACE) {
                ++braceDepth;
                continue;
            }
            if (token.id() != CppTokenId.SEMICOLON) continue;
            if (semicolonFound) {
                return false;
            }
            semicolonFound = true;
        }
        return false;
    }

    static void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        if (BracketCompletion.completionSettingEnabled((Document)doc)) {
            char[] match;
            if (doc.getLength() == 0) {
                return;
            }
            if (ch == '(' || ch == '[') {
                TokenItem token = CndTokenUtilities.getToken((Document)doc, (int)dotPos, (boolean)true);
                if (token == null) {
                    return;
                }
                if (token.id() == CppTokenId.RBRACKET && BracketCompletion.tokenBalance(doc, CppTokenId.LBRACKET, CppTokenId.RBRACKET, dotPos) != 0 || token.id() == CppTokenId.RPAREN && BracketCompletion.tokenBalance(doc, CppTokenId.LPAREN, CppTokenId.RPAREN, dotPos) != 0) {
                    doc.remove(dotPos, 1);
                }
            } else if (ch == '\"') {
                char[] match2 = doc.getChars(dotPos, 1);
                if (match2 != null && match2[0] == '\"') {
                    doc.remove(dotPos, 1);
                }
            } else if (ch == '\'') {
                char[] match3 = doc.getChars(dotPos, 1);
                if (match3 != null && match3[0] == '\'') {
                    doc.remove(dotPos, 1);
                }
            } else if (ch == '<' && (match = doc.getChars(dotPos, 1)) != null && match[0] == '>' && dotPos > 0) {
                TokenItem token = CndTokenUtilities.getFirstNonWhiteBwd((Document)doc, (int)(dotPos - 1));
                switch ((CppTokenId)token.id()) {
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: {
                        doc.remove(dotPos, 1);
                    }
                }
            }
        }
    }

    private static TokenSequence<CppTokenId> cppTokenSequence(Document doc, int offset, boolean backwardBias) {
        return CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (boolean)backwardBias);
    }

    static boolean isAddRightBrace(BaseDocument doc, int caretOffset) throws BadLocationException {
        if (!BracketCompletion.completionSettingEnabled((Document)doc)) {
            return false;
        }
        if (BracketCompletion.tokenBalance(doc, CppTokenId.LBRACE, CppTokenId.RBRACE, caretOffset) <= 0) {
            return false;
        }
        int caretRowStartOffset = Utilities.getRowStart((BaseDocument)doc, (int)caretOffset);
        TokenSequence<CppTokenId> ts = BracketCompletion.cppTokenSequence((Document)doc, caretOffset, true);
        if (ts == null) {
            return false;
        }
        boolean first = true;
        do {
            if (ts.offset() < caretRowStartOffset) {
                return false;
            }
            switch ((CppTokenId)ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: {
                    break;
                }
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: {
                    if (!first || caretOffset <= ts.offset() || caretOffset >= ts.offset() + ts.token().length()) break;
                    return false;
                }
                case LBRACE: {
                    return true;
                }
            }
            first = false;
        } while (ts.movePrevious());
        return false;
    }

    static int getRowOrBlockEnd(BaseDocument doc, int caretOffset) throws BadLocationException {
        int rowEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)caretOffset);
        if (rowEnd == -1 || caretOffset >= rowEnd) {
            return caretOffset;
        }
        ++rowEnd;
        int parenBalance = 0;
        int braceBalance = 0;
        int bracketBalance = 0;
        TokenSequence<CppTokenId> cppTokenSequence = BracketCompletion.cppTokenSequence((Document)doc, caretOffset, false);
        if (cppTokenSequence == null) {
            return caretOffset;
        }
        while (cppTokenSequence.moveNext() && cppTokenSequence.offset() < rowEnd) {
            switch ((CppTokenId)cppTokenSequence.token().id()) {
                case LPAREN: {
                    ++parenBalance;
                    break;
                }
                case RPAREN: {
                    if (parenBalance-- != 0) break;
                    return cppTokenSequence.offset();
                }
                case LBRACE: {
                    ++braceBalance;
                    break;
                }
                case RBRACE: {
                    if (braceBalance-- != 0) break;
                    return cppTokenSequence.offset();
                }
                case LBRACKET: {
                    ++bracketBalance;
                    break;
                }
                case RBRACKET: {
                    if (bracketBalance-- != 0) break;
                    return cppTokenSequence.offset();
                }
            }
        }
        return rowEnd;
    }

    private static int tokenBalance(BaseDocument doc, CppTokenId open, CppTokenId close, int caretOffset) throws BadLocationException {
        BalanceTokenProcessor tp = new BalanceTokenProcessor(open, close);
        CndTokenUtilities.processTokens((CndTokenProcessor)tp, (Document)doc, (int)0, (int)doc.getLength());
        return tp.getBalance();
    }

    private static void skipClosingBracket(BaseDocument doc, Caret caret, char theBracket) throws BadLocationException {
        CppTokenId bracketId = theBracket == ')' ? CppTokenId.RPAREN : CppTokenId.RBRACKET;
        int caretOffset = caret.getDot();
        if (BracketCompletion.isSkipClosingBracket(doc, caretOffset, bracketId)) {
            doc.remove(caretOffset - 1, 1);
            caret.setDot(caretOffset);
        }
    }

    static boolean isSkipClosingBracket(BaseDocument doc, int caretOffset, CppTokenId bracketId) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return false;
        }
        boolean skipClosingBracket = false;
        TokenSequence<CppTokenId> ts = BracketCompletion.cppTokenSequence((Document)doc, caretOffset, false);
        if (ts == null) {
            return false;
        }
        if (ts.token().id() == bracketId) {
            CppTokenId id;
            CppTokenId leftBracketId = ts.token().id() == CppTokenId.RPAREN ? CppTokenId.LPAREN : CppTokenId.LBRACKET;
            int lastRBracketIndex = ts.index();
            while (ts.moveNext() && ts.token().id() == bracketId) {
                lastRBracketIndex = ts.index();
            }
            int braceBalance = 0;
            int bracketBalance = -1;
            boolean finished = false;
            while (!finished && ts.movePrevious()) {
                id = (CppTokenId)ts.token().id();
                switch (id) {
                    case LBRACKET: 
                    case LPAREN: {
                        if (id != bracketId || ++bracketBalance != 0) break;
                        if (braceBalance != 0) {
                            bracketBalance = 1;
                        }
                        finished = true;
                        break;
                    }
                    case RBRACKET: 
                    case RPAREN: {
                        if (id != bracketId) break;
                        --bracketBalance;
                        break;
                    }
                    case LBRACE: {
                        if (++braceBalance <= 0) break;
                        finished = true;
                        break;
                    }
                    case RBRACE: {
                        --braceBalance;
                    }
                }
            }
            if (bracketBalance != 0) {
                skipClosingBracket = true;
            } else {
                braceBalance = 0;
                bracketBalance = 1;
                ts.moveIndex(lastRBracketIndex);
                ts.moveNext();
                ts.moveNext();
                finished = false;
                while (!finished && ts.movePrevious()) {
                    id = (CppTokenId)ts.token().id();
                    switch (id) {
                        case LBRACKET: 
                        case LPAREN: {
                            if (id != leftBracketId) break;
                            ++bracketBalance;
                            break;
                        }
                        case RBRACKET: 
                        case RPAREN: {
                            if (id != bracketId || --bracketBalance != 0) break;
                            if (braceBalance != 0) {
                                bracketBalance = -1;
                            }
                            finished = true;
                            break;
                        }
                        case LBRACE: {
                            ++braceBalance;
                            break;
                        }
                        case RBRACE: {
                            if (--braceBalance >= 0) break;
                            finished = true;
                        }
                    }
                }
                skipClosingBracket = bracketBalance == 0;
            }
        }
        return skipClosingBracket;
    }

    private static void completeOpeningBracket(BaseDocument doc, int dotPos, Caret caret, char theBracket) throws BadLocationException {
        if (BracketCompletion.isCompletablePosition(doc, dotPos + 1)) {
            String matchinBracket = "" + BracketCompletion.matching(theBracket);
            doc.insertString(dotPos + 1, matchinBracket, null);
            caret.setDot(dotPos + 1);
        }
    }

    private static boolean isEscapeSequence(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos <= 0) {
            return false;
        }
        char previousChar = doc.getChars(dotPos - 1, 1)[0];
        return previousChar == '\\';
    }

    private static void completeQuote(BaseDocument doc, int dotPos, Caret caret, char theBracket) throws BadLocationException {
        CppTokenId[] cppTokenIdArray;
        if (BracketCompletion.isEscapeSequence(doc, dotPos)) {
            return;
        }
        if (theBracket == '\"') {
            CppTokenId[] cppTokenIdArray2 = new CppTokenId[2];
            cppTokenIdArray2[0] = CppTokenId.STRING_LITERAL;
            cppTokenIdArray = cppTokenIdArray2;
            cppTokenIdArray2[1] = CppTokenId.PREPROCESSOR_USER_INCLUDE;
        } else {
            CppTokenId[] cppTokenIdArray3 = new CppTokenId[1];
            cppTokenIdArray = cppTokenIdArray3;
            cppTokenIdArray3[0] = CppTokenId.CHAR_LITERAL;
        }
        CppTokenId[] tokenIds = cppTokenIdArray;
        if (BracketCompletion.posWithinQuotes(doc, dotPos + 1, theBracket, tokenIds) && BracketCompletion.isCompletablePosition(doc, dotPos + 1) && BracketCompletion.isUnclosedStringAtLineEnd(doc, dotPos + 1, tokenIds) && (doc.getLength() == dotPos + 1 || doc.getLength() != dotPos + 1 && doc.getChars(dotPos + 1, 1)[0] != theBracket)) {
            doc.insertString(dotPos + 1, "" + theBracket, null);
            caret.setDot(dotPos + 1);
        } else {
            char[] charss = doc.getChars(dotPos + 1, 1);
            if (charss != null && charss[0] == theBracket) {
                doc.remove(dotPos + 1, 1);
            }
        }
    }

    private static boolean isCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        char chr = doc.getChars(dotPos, 1)[0];
        return chr == ')' || chr == ',' || chr == '\"' || chr == '\'' || chr == ' ' || chr == '-' || chr == '+' || chr == '|' || chr == '&' || chr == ']' || chr == '}' || chr == '\n' || chr == '\t' || chr == ';';
    }

    private static boolean completionSettingEnabled(Document doc) {
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((Document)doc)).lookup(Preferences.class);
        return prefs.getBoolean("pair-characters-completion", true);
    }

    private static char matching(char theBracket) {
        switch (theBracket) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '<': {
                return '>';
            }
        }
        return ' ';
    }

    static boolean posWithinString(BaseDocument doc, int dotPos) {
        return BracketCompletion.posWithinQuotes(doc, dotPos, '\"', new CppTokenId[]{CppTokenId.STRING_LITERAL});
    }

    static boolean posWithinQuotes(BaseDocument doc, int dotPos, char quote, CppTokenId[] tokenIDs) {
        TokenSequence<CppTokenId> cppTS = BracketCompletion.cppTokenSequence((Document)doc, dotPos, true);
        if (cppTS != null && BracketCompletion.matchIDs((CppTokenId)cppTS.token().id(), tokenIDs)) {
            return dotPos - cppTS.offset() == 1 || DocumentUtilities.getText((Document)doc).charAt(dotPos - 1) != quote;
        }
        return false;
    }

    static boolean posWithinAnyQuote(BaseDocument doc, int dotPos) {
        TokenSequence<CppTokenId> cppTS = BracketCompletion.cppTokenSequence((Document)doc, dotPos - 1, false);
        if (cppTS != null) {
            switch ((CppTokenId)cppTS.token().id()) {
                case STRING_LITERAL: 
                case CHAR_LITERAL: 
                case PREPROCESSOR_USER_INCLUDE: 
                case PREPROCESSOR_SYS_INCLUDE: {
                    char ch = DocumentUtilities.getText((Document)doc).charAt(dotPos - 1);
                    return dotPos - cppTS.offset() == 1 || ch != '\"' && ch != '\'';
                }
            }
        }
        return false;
    }

    static boolean isUnclosedStringAtLineEnd(BaseDocument doc, int dotPos, CppTokenId[] tokenIDs) {
        int lastNonWhiteOffset;
        try {
            lastNonWhiteOffset = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)dotPos);
        }
        catch (BadLocationException e) {
            return false;
        }
        TokenSequence<CppTokenId> cppTS = BracketCompletion.cppTokenSequence((Document)doc, lastNonWhiteOffset, false);
        if (cppTS != null) {
            return BracketCompletion.matchIDs((CppTokenId)cppTS.token().id(), tokenIDs);
        }
        return false;
    }

    static boolean matchIDs(TokenID toCheck, TokenID[] checkWith) {
        for (int i = checkWith.length - 1; i >= 0; --i) {
            if (toCheck != checkWith[i]) continue;
            return true;
        }
        return false;
    }

    static boolean matchIDs(CppTokenId toCheck, CppTokenId[] checkWith) {
        for (int i = checkWith.length - 1; i >= 0; --i) {
            if (toCheck != checkWith[i]) continue;
            return true;
        }
        return false;
    }

    static boolean matchIDs(Token<CppTokenId> toCheck, Token<CppTokenId>[] checkWith) {
        for (int i = checkWith.length - 1; i >= 0; --i) {
            if (toCheck != checkWith[i]) continue;
            return true;
        }
        return false;
    }

    private static class BalanceTokenProcessor
    extends CndAbstractTokenProcessor<Token<CppTokenId>> {
        private CppTokenId leftTokenID;
        private CppTokenId rightTokenID;
        private Stack<Integer> stack = new Stack();
        private int balance;
        private boolean isDefine;

        BalanceTokenProcessor(CppTokenId leftTokenID, CppTokenId rightTokenID) {
            this.leftTokenID = leftTokenID;
            this.rightTokenID = rightTokenID;
        }

        public boolean token(Token<CppTokenId> token, int tokenOffset) {
            if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return true;
            }
            switch ((CppTokenId)token.id()) {
                case NEW_LINE: {
                    this.isDefine = false;
                    break;
                }
                case PREPROCESSOR_DEFINE: {
                    this.isDefine = true;
                    break;
                }
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: {
                    this.stack.push(this.balance);
                    break;
                }
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    if (this.stack.empty()) break;
                    this.balance = this.stack.peek();
                    break;
                }
                case PREPROCESSOR_ENDIF: {
                    if (this.stack.empty()) break;
                    this.stack.pop();
                    break;
                }
                default: {
                    if (this.isDefine) break;
                    if (token.id() == this.leftTokenID) {
                        ++this.balance;
                        break;
                    }
                    if (token.id() != this.rightTokenID) break;
                    --this.balance;
                }
            }
            return false;
        }

        private int getBalance() {
            return this.balance;
        }
    }

    static class MyTokenProcessor
    implements TokenProcessor {
        public TokenID tokenID = null;
        public int tokenStart = -1;
        private int bufferStartPos = 0;

        MyTokenProcessor() {
        }

        public boolean token(TokenID tokenID, TokenContextPath tcp, int tokBuffOffset, int tokLength) {
            this.tokenStart = this.tokenBuffer2DocumentOffset(tokBuffOffset);
            this.tokenID = tokenID;
            return false;
        }

        public int eot(int offset) {
            return 0;
        }

        public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
            this.bufferStartPos = startPos - offset;
        }

        private int tokenBuffer2DocumentOffset(int offs) {
            return offs + this.bufferStartPos;
        }
    }
}

